/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.rascal.model;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.vscode.lsp.util.Lazy;
import org.rascalmpl.vscode.lsp.util.locations.IRangeMap;
import org.rascalmpl.vscode.lsp.util.locations.Locations;
import org.rascalmpl.vscode.lsp.util.locations.impl.TreeMapLookup;

public class SummaryBridge {
    private static final ISet EMPTY_SET = ValueFactoryFactory.getValueFactory().set(new IValue[0]);
    private static final IMap EMPTY_MAP = ValueFactoryFactory.getValueFactory().map();
    private static final IConstructor EMPTY_SUMMARY;
    private final IWithKeywordParameters<? extends IConstructor> data;
    private final Lazy<IRangeMap<List<Location>>> definitions;
    private final Lazy<IRangeMap<String>> typeNames;

    public SummaryBridge() {
        this.data = EMPTY_SUMMARY.asWithKeywordParameters();
        this.definitions = TreeMapLookup::new;
        this.typeNames = TreeMapLookup::new;
    }

    public SummaryBridge(ISourceLocation self, IConstructor summary, ColumnMaps cm) {
        this.data = summary.asWithKeywordParameters();
        this.definitions = Lazy.defer(() -> SummaryBridge.translateRelation(SummaryBridge.getKWFieldSet(this.data, "useDef"), self, v -> Locations.toLSPLocation((ISourceLocation)v, cm), cm));
        this.typeNames = Lazy.defer(() -> SummaryBridge.translateMap(SummaryBridge.getKWFieldMap(this.data, "locationTypes"), self, v -> ((IString)v).getValue(), cm));
    }

    private static <T> IRangeMap<List<T>> translateRelation(ISet binaryRel, ISourceLocation self, Function<IValue, T> valueMapper, ColumnMaps cm) {
        TreeMapLookup<List<List<T>>> result = new TreeMapLookup<List<List<T>>>();
        for (IValue v : binaryRel) {
            ITuple row = (ITuple)v;
            ISourceLocation fromLoc = (ISourceLocation)row.get(0);
            if (!fromLoc.top().equals(self)) continue;
            Range from = Locations.toRange(fromLoc, cm);
            T to = valueMapper.apply(row.get(1));
            List<T> existing = result.getExact(from);
            if (existing == null) {
                result.put(from, Collections.singletonList(to));
                continue;
            }
            if (existing.size() == 1) {
                existing = new ArrayList<T>(existing);
                result.put(from, existing);
                existing.add(to);
                continue;
            }
            existing.add(to);
        }
        return result;
    }

    private static <T> IRangeMap<T> translateMap(IMap binaryMap, ISourceLocation self, Function<IValue, T> valueMapper, ColumnMaps cm) {
        TreeMapLookup result = new TreeMapLookup();
        binaryMap.entryIterator().forEachRemaining(e -> {
            ISourceLocation fromLoc = (ISourceLocation)e.getKey();
            if (fromLoc.top().equals(self)) {
                Range from = Locations.toRange(fromLoc, cm);
                Object to = valueMapper.apply((IValue)e.getValue());
                result.put(from, to);
            }
        });
        return result;
    }

    private static ISet getKWFieldSet(IWithKeywordParameters<? extends IConstructor> data, String name) {
        if (data.hasParameter(name)) {
            return (ISet)data.getParameter(name);
        }
        return EMPTY_SET;
    }

    private static IMap getKWFieldMap(IWithKeywordParameters<? extends IConstructor> data, String name) {
        if (data.hasParameter(name)) {
            return (IMap)data.getParameter(name);
        }
        return EMPTY_MAP;
    }

    private static <T> T replaceNull(@Nullable T value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public List<Location> getDefinition(Position cursor) {
        return this.getDefinition(new Range(cursor, cursor));
    }

    public List<Location> getDefinition(Range cursor) {
        return SummaryBridge.replaceNull((List)((IRangeMap)this.definitions.get()).lookup(cursor), Collections.emptyList());
    }

    public String getTypeName(Position cursor) {
        return this.getTypeName(new Range(cursor, cursor));
    }

    public String getTypeName(Range cursor) {
        return SummaryBridge.replaceNull((String)((IRangeMap)this.typeNames.get()).lookup(cursor), "");
    }

    static {
        TypeFactory TF = TypeFactory.getInstance();
        TypeStore TS = new TypeStore(new TypeStore[0]);
        Type summaryCons = TF.constructor(TS, TF.abstractDataType(TS, "Summary", new Type[0]), "summary", new Type[0]);
        EMPTY_SUMMARY = IRascalValueFactory.getInstance().constructor(summaryCons);
    }
}

