/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.terminal;

import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.services.LanguageClient;
import org.rascalmpl.ideservices.IRemoteIDEServices;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.LogicalMapResolver;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.vscode.lsp.IBaseLanguageClient;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.util.Diagnostics;
import org.rascalmpl.vscode.lsp.util.DocumentChanges;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class RemoteIDEServicesServer
implements IRemoteIDEServices {
    private static final Logger logger = LogManager.getLogger(RemoteIDEServicesServer.class);
    private final IBaseLanguageClient languageClient;
    private final IBaseTextDocumentService docService;
    private final ExecutorService exec;

    public RemoteIDEServicesServer(LanguageClient languageClient, IBaseTextDocumentService docService, ExecutorService exec) {
        this.languageClient = (IBaseLanguageClient)languageClient;
        this.docService = docService;
        this.exec = exec;
    }

    public CompletableFuture<Void> edit(ISourceLocation loc, int viewColumn) {
        logger.trace("edit({})", (Object)loc);
        return CompletableFuture.runAsync(() -> {
            ISourceLocation physical = Locations.toClientLocation(loc);
            Range range = loc.hasOffsetLength() ? Locations.toRange(physical, this.docService.getColumnMaps()) : null;
            this.languageClient.editDocument(Locations.toUri(physical), range, viewColumn);
        }, this.exec);
    }

    public CompletableFuture<Void> browse(URI uri, IString title, IInteger viewColumn) {
        logger.trace("browse({})", (Object)uri);
        return CompletableFuture.runAsync(() -> this.languageClient.showContent(uri, title, viewColumn), this.exec);
    }

    public CompletableFuture<ISourceLocation> resolveProjectLocation(ISourceLocation loc) {
        logger.trace("resolveProjectLocation({})", (Object)loc);
        try {
            return CompletableFutureUtils.completedFuture(URIResolverRegistry.getInstance().logicalToPhysical(loc), this.exec);
        }
        catch (IOException e) {
            return CompletableFutureUtils.completedFuture(loc, this.exec);
        }
    }

    public CompletableFuture<Void> applyDocumentsEdits(IRemoteIDEServices.DocumentEditsParameter edits) {
        logger.trace("applyDocumentsEdits({})", (Object)edits);
        return CompletableFuture.runAsync(() -> this.languageClient.applyEdit(new ApplyWorkspaceEditParams(DocumentChanges.translateDocumentChanges(edits.getEdits(), this.docService.getColumnMaps()))), this.exec);
    }

    public CompletableFuture<Void> registerLocations(IString scheme, IString authority, ISourceLocation[][] mapping) {
        logger.trace("registerLocaions({}, {}, {})", (Object)scheme, (Object)authority, (Object)mapping);
        return CompletableFuture.runAsync(() -> URIResolverRegistry.getInstance().registerLogical((ILogicalSourceLocationResolver)new LogicalMapResolver(scheme.getValue(), authority.getValue(), IRemoteIDEServices.locArrayToMapLocLoc((ISourceLocation[][])mapping))), this.exec);
    }

    public CompletableFuture<Void> registerDiagnostics(IRemoteIDEServices.RegisterDiagnosticsParameters param) {
        logger.trace("registerDiagnostics({})", (Object)param);
        return CompletableFuture.runAsync(() -> {
            Map<ISourceLocation, List<Diagnostic>> translated = Diagnostics.translateMessages(param.getMessages(), this.docService.getColumnMaps());
            for (Map.Entry<ISourceLocation, List<Diagnostic>> entry : translated.entrySet()) {
                this.languageClient.publishDiagnostics(new PublishDiagnosticsParams(Locations.toUri(entry.getKey()).toString(), entry.getValue()));
            }
        }, this.exec);
    }

    public CompletableFuture<Void> unregisterDiagnostics(ISourceLocation[] locs) {
        logger.trace("unregisterDiagnostics({})", locs);
        return CompletableFuture.runAsync(() -> {
            for (ISourceLocation loc : locs) {
                loc = Locations.toPhysicalIfPossible(loc);
                this.languageClient.publishDiagnostics(new PublishDiagnosticsParams(Locations.toUri(loc).toString(), Collections.emptyList()));
            }
        }, this.exec);
    }

    public CompletableFuture<Void> startDebuggingSession(int serverPort) {
        logger.trace("startDebuggingSession({})", (Object)serverPort);
        return CompletableFuture.runAsync(() -> this.languageClient.startDebuggingSession(serverPort), this.exec);
    }

    public CompletableFuture<Void> registerDebugServerPort(int processID, int serverPort) {
        logger.trace("registerDebugServerPort({}, {})", (Object)processID, (Object)serverPort);
        return CompletableFuture.runAsync(() -> this.languageClient.registerDebugServerPort(processID, serverPort), this.exec);
    }
}

