/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.uri;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.rascalmpl.uri.FileAttributes;
import org.rascalmpl.uri.ISourceLocationInput;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.vscode.lsp.TextDocumentState;
import org.rascalmpl.vscode.lsp.uri.FallbackResolver;
import org.rascalmpl.vscode.lsp.uri.StringByteUtils;
import org.rascalmpl.vscode.lsp.util.Versioned;

public class LSPOpenFileResolver
implements ISourceLocationInput {
    private TextDocumentState getEditorState(ISourceLocation uri) throws IOException {
        return FallbackResolver.getInstance().getDocumentState(LSPOpenFileResolver.stripLspPrefix(uri));
    }

    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        return StringByteUtils.streamingBytes(this.getEditorState(uri).getCurrentContent().get(), StandardCharsets.UTF_16);
    }

    public Charset getCharset(ISourceLocation uri) throws IOException {
        return StandardCharsets.UTF_16;
    }

    public boolean exists(ISourceLocation uri) {
        return FallbackResolver.getInstance().isFileManaged(LSPOpenFileResolver.stripLspPrefix(uri));
    }

    public long lastModified(ISourceLocation uri) throws IOException {
        return this.getEditorState(uri).getLastModified();
    }

    public boolean isDirectory(ISourceLocation uri) {
        return false;
    }

    public boolean isFile(ISourceLocation uri) {
        return this.exists(uri);
    }

    public static ISourceLocation stripLspPrefix(ISourceLocation uri) {
        if (uri.getScheme().startsWith("lsp+")) {
            try {
                return URIUtil.changeScheme((ISourceLocation)uri, (String)uri.getScheme().substring("lsp+".length()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uri;
    }

    public String[] list(ISourceLocation uri) throws IOException {
        throw new IOException("`list` is not supported on files");
    }

    public String scheme() {
        return "lsp";
    }

    public boolean supportsHost() {
        return false;
    }

    public long size(ISourceLocation uri) throws IOException {
        return this.size(this.getEditorState(uri).getCurrentContent());
    }

    private int size(Versioned<String> s) {
        return StringByteUtils.byteCount(s.get(), StandardCharsets.UTF_16);
    }

    public boolean isReadable(ISourceLocation uri) throws IOException {
        return FallbackResolver.getInstance().isFileManaged(LSPOpenFileResolver.stripLspPrefix(uri));
    }

    public FileAttributes stat(ISourceLocation uri) throws IOException {
        if (!this.exists(uri)) {
            return new FileAttributes(false, false, -1L, -1L, false, false, 0L);
        }
        Versioned<String> current = this.getEditorState(uri).getCurrentContent();
        long modified = current.getTimestamp();
        boolean isWritable = FallbackResolver.getInstance().isWritable(LSPOpenFileResolver.stripLspPrefix(uri));
        return new FileAttributes(true, true, modified, modified, true, isWritable, (long)this.size(current));
    }
}

