/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.uri.jsonrpc.impl;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.vscode.lsp.IRascalFileSystemServices;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.VSCodeUriResolverClient;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.VSCodeUriResolverServer;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.VSCodeVFS;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.ISourceLocationChanged;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.WatchRequest;
import org.rascalmpl.vscode.lsp.util.NamedThreadPool;

public class VSCodeVFSClient
implements VSCodeUriResolverClient,
AutoCloseable {
    private static final Logger logger = LogManager.getLogger(VSCodeVFSClient.class);
    private final Map<WatchSubscriptionKey, Watchers> watchers = new ConcurrentHashMap<WatchSubscriptionKey, Watchers>();
    private final Map<String, Watchers> watchersById = new ConcurrentHashMap<String, Watchers>();
    private final Socket socket;
    private static final ExecutorService exec = NamedThreadPool.cachedDaemon("FallbackResolver-watcher");

    private VSCodeVFSClient(Socket socket) {
        this.socket = socket;
    }

    @Override
    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            logger.debug("Closing failed", (Throwable)e);
        }
    }

    @Override
    public void emitWatch(ISourceLocationChanged event) {
        logger.trace("emitWatch: {}", (Object)event);
        Watchers watch = this.watchersById.get(event.getWatchId());
        if (watch != null) {
            watch.publish(event.translate());
        }
    }

    @Override
    public void addWatcher(ISourceLocation loc, boolean recursive, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback, VSCodeUriResolverServer server) throws IOException {
        logger.trace("addWatcher: {}", (Object)loc);
        try {
            Watchers watch = this.watchers.computeIfAbsent(new WatchSubscriptionKey(loc, recursive), k -> {
                logger.trace("Fresh watch, setting up request to server");
                Watchers result = new Watchers();
                result.addNewWatcher(callback);
                this.watchersById.put(result.id, result);
                server.watch(new WatchRequest(loc, recursive, result.id)).join();
                return result;
            });
            watch.addNewWatcher(callback);
        }
        catch (CompletionException ce) {
            logger.error("Error setting up watch", ce.getCause());
            throw new IOException(ce.getCause());
        }
    }

    @Override
    public void removeWatcher(ISourceLocation loc, boolean recursive, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback, VSCodeUriResolverServer server) throws IOException {
        logger.trace("removeWatcher: {}", (Object)loc);
        WatchSubscriptionKey watchKey = new WatchSubscriptionKey(loc, recursive);
        Watchers watch = this.watchers.get(watchKey);
        if (watch != null && watch.removeWatcher(callback)) {
            logger.trace("No other watchers registered, so unregistering at server");
            this.watchers.remove(watchKey);
            if (!watch.callbacks.isEmpty()) {
                logger.trace("Raced by another thread, canceling unregister");
                this.watchers.put(watchKey, watch);
                return;
            }
            this.watchersById.remove(watch.id);
            try {
                server.unwatch(new WatchRequest(loc, recursive, watch.id)).join();
            }
            catch (CompletionException ce) {
                logger.error("Error removing watch", ce.getCause());
                throw new IOException(ce.getCause());
            }
        }
    }

    public static void buildAndRegister(int port) {
        try {
            VSCodeUriResolverClient existingClient = VSCodeVFS.INSTANCE.getClient();
            if (existingClient instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)existingClient)).close();
                }
                catch (Exception e) {
                    logger.error("Error closing old client", (Throwable)e);
                }
            }
            logger.debug("Connecting to VFS: {}", (Object)port);
            Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
            socket.setTcpNoDelay(true);
            VSCodeVFSClient newClient = new VSCodeVFSClient(socket);
            Launcher<VSCodeUriResolverServer> clientLauncher = new Launcher.Builder<VSCodeUriResolverServer>().setRemoteInterface(VSCodeUriResolverServer.class).setLocalService(newClient).setInput(socket.getInputStream()).setOutput(socket.getOutputStream()).setExecutorService(IRascalFileSystemServices.executor).create();
            clientLauncher.startListening();
            VSCodeVFS.INSTANCE.provideServer(clientLauncher.getRemoteProxy());
            VSCodeVFS.INSTANCE.provideClient(newClient);
        }
        catch (Throwable e) {
            logger.error("Error setting up VFS connection", e);
        }
    }

    private static class Watchers {
        private final String id;
        private final List<Consumer<ISourceLocationWatcher.ISourceLocationChanged>> callbacks = new CopyOnWriteArrayList<Consumer<ISourceLocationWatcher.ISourceLocationChanged>>();

        public Watchers() {
            this.id = UUID.randomUUID().toString();
        }

        public void addNewWatcher(Consumer<ISourceLocationWatcher.ISourceLocationChanged> watcher) {
            this.callbacks.add(watcher);
        }

        public boolean removeWatcher(Consumer<ISourceLocationWatcher.ISourceLocationChanged> watcher) {
            this.callbacks.remove(watcher);
            return this.callbacks.isEmpty();
        }

        public void publish(ISourceLocationWatcher.ISourceLocationChanged changed) {
            for (Consumer<ISourceLocationWatcher.ISourceLocationChanged> c : this.callbacks) {
                exec.submit(() -> c.accept(changed));
            }
        }
    }

    private static class WatchSubscriptionKey {
        private final ISourceLocation loc;
        private final boolean recursive;

        public WatchSubscriptionKey(ISourceLocation loc, boolean recursive) {
            this.loc = loc;
            this.recursive = recursive;
        }

        public int hashCode() {
            return Objects.hash(this.loc, this.recursive);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WatchSubscriptionKey) {
                WatchSubscriptionKey other = (WatchSubscriptionKey)obj;
                return this.recursive == other.recursive && Objects.equals(this.loc, other.loc);
            }
            return false;
        }
    }
}

