/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.uri.jsonrpc.messages;

import io.usethesource.vallang.ISourceLocation;
import java.net.URISyntaxException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.PathConfigMode;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class PathConfigParameter {
    @NonNull
    private String uri;
    @NonNull
    private PathConfigMode mode;

    public PathConfigParameter(@NonNull String uri, @NonNull PathConfigMode mode) {
        this.uri = uri;
        this.mode = mode;
    }

    public String getUri() {
        return this.uri;
    }

    public ISourceLocation getLocation() throws URISyntaxException {
        return Locations.toCheckedLoc(this.uri);
    }

    public PathConfigMode getMode() {
        return this.mode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PathConfigParameter) {
            PathConfigParameter other = (PathConfigParameter)obj;
            return this.uri.equals(other.uri) && this.mode == other.mode;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.mode});
    }

    public String toString() {
        return "PathConfigParameter [uri=" + this.uri + ", mode=" + String.valueOf((Object)this.mode) + "]";
    }
}

