/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import com.google.gson.JsonPrimitive;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.vscode.lsp.util.DocumentSymbols;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class CallHierarchy {
    private static final IRascalValueFactory VF = IRascalValueFactory.getInstance();
    private static final TypeFactory TF = TypeFactory.getInstance();
    private final IConstructor incoming;
    private final IConstructor outgoing;
    private final Type callHierarchyItemCons;
    private final Executor exec;

    public CallHierarchy(Executor exec) {
        TypeStore store = new TypeStore(new TypeStore[0]);
        Type directionAdt = TF.abstractDataType(store, "CallDirection", new Type[0]);
        this.incoming = VF.constructor(TF.constructor(store, directionAdt, "incoming", new Type[0]));
        this.outgoing = VF.constructor(TF.constructor(store, directionAdt, "outgoing", new Type[0]));
        Type callHierarchyItemAdt = TF.abstractDataType(store, "CallHierarchyItem", new Type[0]);
        this.callHierarchyItemCons = TF.constructor(store, callHierarchyItemAdt, "callHierarchyItem", new Object[]{TF.stringType(), "name", DocumentSymbols.getSymbolKindType(), "kind", TF.sourceLocationType(), "src", TF.sourceLocationType(), "selection"});
        this.exec = exec;
    }

    public IConstructor direction(Direction dir) {
        switch (dir) {
            case INCOMING: {
                return this.incoming;
            }
            case OUTGOING: {
                return this.outgoing;
            }
        }
        throw new IllegalArgumentException("Unknown call direction: " + dir.name().toLowerCase());
    }

    public CallHierarchyItem toLSP(IConstructor cons, ColumnMaps columns) {
        String name = ((IString)cons.get("name")).getValue();
        SymbolKind kind = DocumentSymbols.symbolKindToLSP((IConstructor)cons.get("kind"));
        ISourceLocation def = (ISourceLocation)cons.get("src");
        Range definitionRange = Locations.toRange(def, columns);
        ISourceLocation selection = (ISourceLocation)cons.get("selection");
        Range selectionRange = Locations.toRange(selection, columns);
        CallHierarchyItem ci = new CallHierarchyItem(name, kind, Locations.toUri(def.top()).toString(), definitionRange, selectionRange);
        IWithKeywordParameters kws = cons.asWithKeywordParameters();
        if (kws.hasParameter("tags")) {
            ci.setTags(DocumentSymbols.symbolTagsToLSP((ISet)kws.getParameter("tags")));
        }
        if (kws.hasParameter("detail")) {
            ci.setDetail(((IString)kws.getParameter("detail")).getValue());
        }
        if (kws.hasParameter("data")) {
            ci.setData(this.serializeData((IConstructor)kws.getParameter("data")));
        }
        return ci;
    }

    private String serializeData(IConstructor data) {
        return data.toString();
    }

    public CompletableFuture<IConstructor> toRascal(CallHierarchyItem ci, Function<String, CompletableFuture<IConstructor>> dataParser, ColumnMaps columns) {
        CompletableFuture parseData = ci.getData() != null ? dataParser.apply(((JsonPrimitive)ci.getData()).getAsString()).thenApply(Optional::of) : CompletableFutureUtils.completedFuture(Optional.empty(), this.exec);
        return parseData.thenApply(data -> {
            String detail;
            HashMap<String, Object> kwArgs = new HashMap<String, Object>();
            List<SymbolTag> tags = ci.getTags();
            if (tags != null) {
                kwArgs.put("tags", DocumentSymbols.symbolTagsToRascal(tags));
            }
            if ((detail = ci.getDetail()) != null) {
                kwArgs.put("detail", VF.string(detail));
            }
            data.ifPresent(dt -> kwArgs.put("data", dt));
            ISourceLocation loc = Locations.toLoc(ci.getUri());
            return VF.constructor(this.callHierarchyItemCons, new IValue[]{VF.string(ci.getName()), DocumentSymbols.symbolKindToRascal(ci.getKind()), Locations.setRange(loc, ci.getRange(), columns), Locations.setRange(loc, ci.getSelectionRange(), columns)}, kwArgs);
        });
    }

    public static enum Direction {
        INCOMING,
        OUTGOING;

    }
}

