/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import com.google.gson.JsonPrimitive;
import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.util.DocumentChanges;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;

public class CodeActions {
    private CodeActions() {
    }

    public static CompletableFuture<Stream<IValue>> extractActionsFromDiagnostics(CodeActionParams params, Function<String, CompletableFuture<IList>> actionParser, Executor exec) {
        Stream actions = params.getContext().getDiagnostics().stream().map(Diagnostic::getData).filter(Objects::nonNull).filter(JsonPrimitive.class::isInstance).map(JsonPrimitive.class::cast).map(JsonPrimitive::getAsString).map(actionParser);
        return CompletableFutureUtils.flatten(actions, CompletableFutureUtils.completedFuture(IRascalValueFactory.getInstance().list(new IValue[0]), exec), IList::concat).thenApply(ICollection::stream);
    }

    public static CompletableFuture<List<Either<Command, CodeAction>>> mergeAndConvertCodeActions(IBaseTextDocumentService doc, String dedicatedLanguageName, String languageName, CompletableFuture<Stream<IValue>> quickfixes, CompletableFuture<Stream<IValue>> codeActions) {
        return codeActions.thenCombine(quickfixes, (actions, quicks) -> Stream.concat(quicks, actions).map(IConstructor.class::cast).map(cons -> CodeActions.constructorToCodeAction(doc, dedicatedLanguageName, languageName, cons)).map(Either::forRight).collect(Collectors.toList()));
    }

    private static CodeAction constructorToCodeAction(IBaseTextDocumentService doc, String dedicatedLanguageName, String languageName, IConstructor codeAction) {
        IWithKeywordParameters kw = codeAction.asWithKeywordParameters();
        IConstructor command = (IConstructor)kw.getParameter("command");
        IString title = (IString)kw.getParameter("title");
        IList edits = (IList)kw.getParameter("edits");
        IConstructor kind = (IConstructor)kw.getParameter("kind");
        if (title == null) {
            if (command != null) {
                title = (IString)command.asWithKeywordParameters().getParameter("title");
            }
            if (title == null) {
                title = IRascalValueFactory.getInstance().string("");
            }
        }
        CodeAction result = new CodeAction(title.getValue());
        if (command != null) {
            result.setCommand(CodeActions.constructorToCommand(dedicatedLanguageName, languageName, command));
        }
        if (edits != null) {
            result.setEdit(DocumentChanges.translateDocumentChanges(edits, doc.getColumnMaps()));
        }
        result.setKind(CodeActions.constructorToCodeActionKind(kind));
        return result;
    }

    private static String constructorToCodeActionKind(@Nullable IConstructor kind) {
        if (kind == null) {
            return "quickfix";
        }
        Object name = kind.getName();
        if (((String)name).isEmpty()) {
            return "";
        }
        if (((String)name).length() == 1) {
            return ((String)name).toUpperCase();
        }
        if ("empty".equals(name)) {
            return "";
        }
        IWithKeywordParameters kw = kind.asWithKeywordParameters();
        for (String kwn : kw.getParameterNames()) {
            String nestedName = CodeActions.constructorToCodeActionKind((IConstructor)kw.getParameter(kwn));
            name = (String)name + (String)(nestedName.isEmpty() ? "" : "." + nestedName);
        }
        return name;
    }

    public static Command constructorToCommand(String dedicatedLanguageName, String languageName, IConstructor command) {
        IWithKeywordParameters kw = command.asWithKeywordParameters();
        IString possibleTitle = (IString)kw.getParameter("title");
        return new Command(possibleTitle != null ? possibleTitle.getValue() : command.toString(), CodeActions.getRascalMetaCommandName(languageName, dedicatedLanguageName), Arrays.asList(languageName, command.toString()));
    }

    public static String getRascalMetaCommandName(String language, String dedicatedLanguageName) {
        if (!dedicatedLanguageName.isEmpty()) {
            return "rascal-meta-command-" + dedicatedLanguageName;
        }
        if ("Rascal".equals(language)) {
            return "rascal-command";
        }
        return "rascal-meta-command";
    }
}

