/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.io.StandardTextWriter;
import java.awt.AWTError;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.services.LanguageClient;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.staticErrors.StaticError;
import org.rascalmpl.interpreter.utils.LimitedResultWriter;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.jar.JarURIResolver;
import org.rascalmpl.vscode.lsp.BaseWorkspaceService;
import org.rascalmpl.vscode.lsp.IBaseLanguageClient;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.LSPIDEServices;
import org.rascalmpl.vscode.lsp.RascalLSPMonitor;
import org.rascalmpl.vscode.lsp.rascal.RascalLanguageServer;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;

public class EvaluatorUtil {
    private static final Logger logger = LogManager.getLogger(EvaluatorUtil.class);

    public static <T> InterruptibleFuture<@PolyNull T> runEvaluator(String task, CompletableFuture<Evaluator> eval, Function<Evaluator, @PolyNull T> call, @PolyNull T interruptedResult, Executor exec, boolean isParametric, LanguageClient client) {
        AtomicBoolean interrupted = new AtomicBoolean(false);
        AtomicReference<@Nullable Object> runningEvaluator = new AtomicReference<Object>(null);
        AtomicReference<InterruptibleFuture<@PolyNull T>> future = new AtomicReference();
        future.set(new InterruptibleFuture(eval.thenApplyAsync(actualEval -> {
            try {
                InterruptibleFuture self;
                while ((self = (InterruptibleFuture)future.get()) == null) {
                    Thread.yield();
                }
                IRascalMonitor monitor = actualEval.getMonitor();
                if (monitor instanceof LSPIDEServices) {
                    monitor = ((LSPIDEServices)monitor).getMonitor();
                }
                if (monitor instanceof RascalLSPMonitor) {
                    ((RascalLSPMonitor)monitor).registerActiveFuture(task, self);
                }
                actualEval.jobStart(task);
                Evaluator evaluator = actualEval;
                synchronized (evaluator) {
                    boolean jobSuccess = false;
                    try {
                        runningEvaluator.set(actualEval);
                        if (interrupted.get()) {
                            Object object = interruptedResult;
                            return object;
                        }
                        Object result = call.apply((Evaluator)actualEval);
                        jobSuccess = true;
                        Object r = result;
                        return r;
                    }
                    catch (InterruptException e) {
                        actualEval.endAllJobs();
                        Object object = interruptedResult;
                        return object;
                    }
                    finally {
                        if (jobSuccess) {
                            actualEval.jobEnd(task, jobSuccess);
                        }
                        if (monitor instanceof RascalLSPMonitor) {
                            ((RascalLSPMonitor)monitor).unregisterActiveFuture(task);
                        }
                        runningEvaluator.set(null);
                        actualEval.__setInterrupt(false);
                    }
                }
            }
            catch (Throw e) {
                logger.error("Internal error during {}\n{}: {}\n{}", (Object)task, (Object)e.getLocation(), (Object)e.getMessage(), (Object)e.getTrace());
                if (isParametric) throw new ResponseErrorException(new ResponseError(ResponseErrorCode.RequestFailed, EvaluatorUtil.formatMessage(e), null));
                EvaluatorUtil.reportInternalError(e, task, client);
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.RequestFailed, EvaluatorUtil.formatMessage(e), null));
            }
            catch (StaticError e) {
                logger.error("Static Rascal error in {}\n{}: {}", (Object)task, (Object)e.getLocation(), (Object)e.getMessage());
                if (isParametric) throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, EvaluatorUtil.formatMessage(e), null));
                EvaluatorUtil.reportInternalError(e, task, client);
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, EvaluatorUtil.formatMessage(e), null));
            }
            catch (ResponseErrorException e) {
                logger.debug("{} threw an intentional error that should be forwarded to the lsp client without our involvement: {}", (Object)task, (Object)e.getMessage());
                throw e;
            }
            catch (Throwable e) {
                logger.error("{} failed", (Object)task, (Object)e);
                if (isParametric) throw e;
                EvaluatorUtil.reportInternalError(e, task, client);
                throw e;
            }
        }, exec), () -> {
            interrupted.set(true);
            Evaluator actualEval = (Evaluator)runningEvaluator.get();
            if (actualEval != null) {
                actualEval.interrupt();
            }
        }));
        return (InterruptibleFuture)future.get();
    }

    private static void extractReasonAndStackTrace(Throwable e, String task, StringWriter reason, StringWriter stackTrace) {
        reason.append(task);
        reason.append(" crashed unexpectedly with: ");
        if (e instanceof Throw) {
            stackTrace.append(((Throw)e).getTrace().toString());
            reason.append(EvaluatorUtil.formatMessage((Throw)e));
        } else {
            if (e instanceof StaticError) {
                reason.append(EvaluatorUtil.formatMessage((StaticError)e).replace('\n', ' '));
            } else {
                reason.append(e.getMessage());
            }
            e.printStackTrace(new PrintWriter(stackTrace));
        }
    }

    private static void createGithubIssue(Throwable e, String title, String stackTrace, LanguageClient client) {
        StringWriter body = new StringWriter();
        try (PrintWriter bodyWriter = new PrintWriter(body);){
            bodyWriter.println("Context: ***Please provide context***");
            bodyWriter.println();
            bodyWriter.println("Exception thrown:");
            bodyWriter.println("```");
            bodyWriter.println(e.getMessage());
            bodyWriter.println("```");
            bodyWriter.println("Stacktrace:");
            bodyWriter.println("```");
            bodyWriter.println(stackTrace);
            bodyWriter.println("```");
        }
        EvaluatorUtil.browse("https://github.com/usethesource/rascal-language-servers/issues/new?labels=bug&title=" + URLEncoder.encode(title, StandardCharsets.UTF_8) + "&body=" + URLEncoder.encode(body.toString(), StandardCharsets.UTF_8), client);
    }

    private static void copyToClipboard(String text, LanguageClient client) {
        StringSelection content = new StringSelection(text);
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit == null) {
                logger.error("Could not find toolkit");
                return;
            }
            toolkit.getSystemClipboard().setContents(content, content);
        }
        catch (AWTError | HeadlessException | IllegalStateException e) {
            client.showMessage(new MessageParams(MessageType.Error, "Cannot copy to clipboard: " + e.getMessage()));
            logger.catching(e);
        }
    }

    private static void reportInternalError(Throwable e, String task, LanguageClient client) {
        StringWriter reason = new StringWriter();
        StringWriter stackTrace = new StringWriter();
        EvaluatorUtil.extractReasonAndStackTrace(e, task, reason, stackTrace);
        String title = task + " crashed unexpectedly with: " + reason.toString();
        ShowMessageRequestParams msg = new ShowMessageRequestParams();
        msg.setMessage(title);
        msg.setType(MessageType.Error);
        msg.setActions(ErrorHandlingOption.getActionItems());
        client.showMessageRequest(msg).thenAccept(response -> {
            if (response != null) {
                switch (ErrorHandlingOption.valueOfLabel(response.getTitle())) {
                    case REPORT_ON_GITHUB: {
                        EvaluatorUtil.createGithubIssue(e, title, stackTrace.toString(), client);
                        break;
                    }
                    case COPY_STACK_TRACE: {
                        EvaluatorUtil.copyToClipboard(stackTrace.toString(), client);
                        break;
                    }
                }
            }
        });
    }

    private static void browse(String url, LanguageClient client) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException | RuntimeException | URISyntaxException e) {
            client.showMessage(new MessageParams(MessageType.Error, "Cannot open browser github automatically: " + e.getMessage()));
            logger.catching(e);
        }
    }

    private static String formatMessage(Throw e) {
        IConstructor exp;
        String message = "";
        IValue thrown = e.getException();
        message = thrown instanceof IConstructor ? ((exp = (IConstructor)thrown).has("message") ? EvaluatorUtil.asString(exp.get("message")) : exp.getName()) : EvaluatorUtil.asString(thrown);
        return message + "\nat: " + String.valueOf(e.getLocation());
    }

    private static String asString(IValue v) {
        if (v instanceof IString) {
            return ((IString)v).getValue();
        }
        LimitedResultWriter res = new LimitedResultWriter(512);
        try {
            new StandardTextWriter(false).write(v, (Writer)res);
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
        return res.toString();
    }

    private static String formatMessage(StaticError e) {
        return "Static error: " + e.getMessage();
    }

    public static PathConfig addLSPSources(PathConfig pcfg, boolean includingInternalModules) {
        try {
            ISourceLocation lspJar = JarURIResolver.jarify((ISourceLocation)PathConfig.resolveProjectOnClasspath((String)"rascal-lsp"));
            pcfg = pcfg.addSourceLoc(URIUtil.getChildLocation((ISourceLocation)lspJar, (String)"library"));
            if (includingInternalModules) {
                pcfg = pcfg.addSourceLoc(URIUtil.getChildLocation((ISourceLocation)lspJar, (String)"lsp"));
            }
            return pcfg;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not add rascal-lsp to the path config", ex);
        }
    }

    public static PathConfig addRascalCompilerSources(PathConfig pcfg) {
        try {
            ISourceLocation rascalJar = JarURIResolver.jarify((ISourceLocation)PathConfig.resolveCurrentRascalRuntimeJar());
            return pcfg.addSourceLoc(URIUtil.getChildLocation((ISourceLocation)rascalJar, (String)"org/rascalmpl/compiler")).addSourceLoc(URIUtil.getChildLocation((ISourceLocation)rascalJar, (String)"org/rascalmpl/typepal"));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not add rascal-compiler to the path config", ex);
        }
    }

    public static CompletableFuture<Evaluator> makeFutureEvaluator(LSPContext context, String label, IRascalMonitor monitor, PathConfig pcfg, String ... imports) {
        return CompletableFuture.supplyAsync(() -> {
            Logger customLog = LogManager.getLogger("Evaluator: " + label);
            LSPIDEServices services = new LSPIDEServices(context.client, context.docService, context.workspaceService, monitor);
            boolean jobSuccess = false;
            String jobName = "Loading " + label;
            try {
                services.jobStart(jobName, imports.length);
                Evaluator eval = ShellEvaluatorFactory.getDefaultEvaluatorForPathConfig((ISourceLocation)pcfg.getProjectRoot(), (PathConfig)pcfg, (Reader)Reader.nullReader(), (PrintWriter)EvaluatorUtil.logWriter(customLog, Level.INFO), (PrintWriter)EvaluatorUtil.logWriter(customLog, Level.ERROR), (IRascalMonitor)services);
                eval.addClassLoader(RascalLanguageServer.class.getClassLoader());
                eval.doImport((IRascalMonitor)services, imports);
                jobSuccess = true;
                Evaluator evaluator = eval;
                return evaluator;
            }
            finally {
                services.jobEnd(jobName, jobSuccess);
            }
        }, context.exec);
    }

    private static PrintWriter logWriter(Logger customLog, Level level) {
        return IoBuilder.forLogger(customLog).setLevel(level).buildPrintWriter();
    }

    public static class LSPContext {
        private final ExecutorService exec;
        private final IBaseTextDocumentService docService;
        private final BaseWorkspaceService workspaceService;
        private final IBaseLanguageClient client;

        public LSPContext(ExecutorService exec, IBaseTextDocumentService docService, BaseWorkspaceService workspaceService, IBaseLanguageClient client) {
            this.exec = exec;
            this.docService = docService;
            this.workspaceService = workspaceService;
            this.client = client;
        }
    }

    private static enum ErrorHandlingOption {
        REPORT_ON_GITHUB("Report on Rascal GitHub"),
        COPY_STACK_TRACE("Copy stack trace to clipboard"),
        IGNORE("Ignore");

        final String label;
        private static final Map<String, ErrorHandlingOption> BY_LABEL;

        private ErrorHandlingOption(String label) {
            this.label = label;
        }

        MessageActionItem getActionItem() {
            return new MessageActionItem(this.label);
        }

        static List<MessageActionItem> getActionItems() {
            return Stream.of(ErrorHandlingOption.values()).map(ErrorHandlingOption::getActionItem).collect(Collectors.toList());
        }

        public static ErrorHandlingOption valueOfLabel(String label) {
            ErrorHandlingOption result = BY_LABEL.get(label);
            if (result == null) {
                throw new IllegalArgumentException(label + " is not a handling option");
            }
            return result;
        }

        static {
            BY_LABEL = new HashMap<String, ErrorHandlingOption>();
            Stream.of(ErrorHandlingOption.values()).forEach(e -> BY_LABEL.put(e.label, (ErrorHandlingOption)((Object)e)));
        }
    }
}

