/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.FoldingRange;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;
import org.rascalmpl.values.parsetrees.visitors.TreeVisitor;

public class FoldingRanges {
    private FoldingRanges() {
    }

    public static List<FoldingRange> getFoldingRanges(ITree tree) {
        final ArrayList<FoldingRange> result = new ArrayList<FoldingRange>();
        tree.accept((TreeVisitor)new TreeVisitor<RuntimeException>(){

            public @Nullable ITree visitTreeAppl(ITree arg) throws RuntimeException {
                if (TreeAdapter.isComment((ITree)arg)) {
                    FoldingRanges.addFoldingRegion(result, TreeAdapter.getLocation((ITree)arg), "comment");
                } else if (arg.asWithKeywordParameters().getParameter("foldable") != null) {
                    FoldingRanges.addFoldingRegion(result, TreeAdapter.getLocation((ITree)arg), "region");
                } else {
                    IValueFactory vf = ValueFactoryFactory.getValueFactory();
                    if (ProductionAdapter.hasAttribute((IConstructor)TreeAdapter.getProduction((ITree)arg), (IValue)vf.constructor(RascalValueFactory.Attr_Tag, new IValue[]{vf.node("Foldable")}))) {
                        FoldingRanges.addFoldingRegion(result, TreeAdapter.getLocation((ITree)arg), "region");
                    }
                }
                for (IValue child : TreeAdapter.getArgs((ITree)arg)) {
                    child.accept((IValueVisitor)this);
                }
                return null;
            }

            public @Nullable ITree visitTreeAmb(ITree arg) throws RuntimeException {
                return null;
            }

            public @Nullable ITree visitTreeChar(ITree arg) throws RuntimeException {
                return null;
            }

            public @Nullable ITree visitTreeCycle(ITree arg) throws RuntimeException {
                return null;
            }
        });
        return result;
    }

    static void addFoldingRegion(List<FoldingRange> ranges, ISourceLocation src, String kind) {
        int beginLine = src.getBeginLine() - 1;
        int endLine = src.getEndLine() - (src.getEndColumn() == 0 ? 2 : 1);
        if (endLine > beginLine) {
            FoldingRange range = new FoldingRange();
            range.setStartLine(beginLine);
            range.setEndLine(endLine);
            range.setKind(kind);
            ranges.add(range);
        }
    }
}

