/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.SemanticTokenTypes;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensCapabilities;
import org.eclipse.lsp4j.SemanticTokensClientCapabilitiesRequests;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class SemanticTokenizer {
    private static final Logger logger = LogManager.getLogger(SemanticTokenizer.class);
    private final CategoryPatch patch;

    public SemanticTokenizer() {
        this(false);
    }

    public SemanticTokenizer(boolean rascal) {
        this.patch = rascal ? new RascalCategoryPatch() : new DefaultCategoryPatch();
    }

    public SemanticTokens semanticTokensFull(ITree tree, boolean specialCaseHighlighting) {
        TokenList tokens = new TokenList();
        new TokenCollector(tokens, specialCaseHighlighting, this.patch).collect(tree);
        return new SemanticTokens(tokens.getTheList());
    }

    public SemanticTokensWithRegistrationOptions options() {
        SemanticTokensWithRegistrationOptions result = new SemanticTokensWithRegistrationOptions();
        SemanticTokensLegend legend = new SemanticTokensLegend(TokenTypes.getTokenTypes(), TokenTypes.getTokenModifiers());
        result.setFull(true);
        result.setLegend(legend);
        return result;
    }

    public SemanticTokensCapabilities capabilities() {
        SemanticTokensClientCapabilitiesRequests requests = new SemanticTokensClientCapabilitiesRequests(true);
        SemanticTokensCapabilities cps = new SemanticTokensCapabilities(requests, TokenTypes.getTokenTypes(), Collections.emptyList(), Collections.emptyList());
        cps.setMultilineTokenSupport(true);
        cps.setAugmentsSyntaxTokens(false);
        return cps;
    }

    private static class RascalCategoryPatch
    implements CategoryPatch {
        private Cache<IConstructor, String> doPatch = RascalCategoryPatch.buildCache();
        private Cache<IConstructor, Boolean> doNotPatch = RascalCategoryPatch.buildCache();

        private RascalCategoryPatch() {
        }

        @Override
        public @Nullable String apply(IConstructor prod, @Nullable String defaultCategory) {
            String category = (String)this.doPatch.getIfPresent((Object)prod);
            if (category != null) {
                return category;
            }
            if (this.doNotPatch.getIfPresent((Object)prod) != null) {
                return defaultCategory;
            }
            IConstructor def = ProductionAdapter.getDefined((IConstructor)prod);
            if (this.isLabeledLiteral(def)) {
                switch (SymbolAdapter.getLabel((IConstructor)def)) {
                    case "integer": 
                    case "real": 
                    case "rational": {
                        return (String)this.doPatch.get((Object)prod, p -> "number");
                    }
                    case "location": {
                        return (String)this.doPatch.get((Object)prod, p -> "string");
                    }
                    case "regExp": {
                        return (String)this.doPatch.get((Object)prod, p -> "regexp");
                    }
                }
            }
            this.doNotPatch.put((Object)prod, (Object)Boolean.TRUE);
            return defaultCategory;
        }

        private boolean isLabeledLiteral(IConstructor def) {
            return SymbolAdapter.isLabel((IConstructor)def) && SymbolAdapter.getName((IConstructor)SymbolAdapter.getLabeledSymbol((IConstructor)def)).equals("Literal");
        }

        private static <V> Cache<IConstructor, V> buildCache() {
            return Caffeine.newBuilder().weakKeys().build();
        }
    }

    private static class DefaultCategoryPatch
    implements CategoryPatch {
        private DefaultCategoryPatch() {
        }

        @Override
        public @Nullable String apply(IConstructor prod, @Nullable String defaultCategory) {
            return defaultCategory;
        }
    }

    private static interface CategoryPatch
    extends BiFunction<IConstructor, String, String> {
    }

    private static class TokenCollector {
        private int line;
        private int column;
        private final boolean showAmb = false;
        private final TokenList tokens;
        private final boolean specialCaseHighlighting;
        private final CategoryPatch patch;

        public TokenCollector(TokenList tokens, boolean specialCaseHighlighting, CategoryPatch patch) {
            this.tokens = tokens;
            this.specialCaseHighlighting = specialCaseHighlighting;
            this.patch = patch;
            this.line = 0;
            this.column = 0;
        }

        public void collect(ITree tree) {
            this.collect(tree, null);
        }

        private void collect(ITree tree, @Nullable String parentCategory) {
            if (tree.isAppl()) {
                this.collectAppl(tree, parentCategory);
            } else if (tree.isAmb()) {
                this.collectAmb(tree, parentCategory);
            } else if (tree.isChar()) {
                this.collectChar(tree, parentCategory);
            }
        }

        private void collectAppl(ITree tree, @Nullable String parentCategory) {
            String category = null;
            if ("ambiguity".equals(parentCategory)) {
                category = "ambiguity";
            }
            IValue catParameter = tree.asWithKeywordParameters().getParameter("category");
            if (category == null && catParameter != null) {
                category = ((IString)catParameter).getValue();
            }
            IConstructor prod = TreeAdapter.getProduction((ITree)tree);
            if (category == null && ProductionAdapter.isDefault((IConstructor)prod)) {
                category = ProductionAdapter.getCategory((IConstructor)prod);
            }
            if (category == null && parentCategory == null && TokenCollector.isKeyword(tree)) {
                category = "keyword";
            }
            if (category == null) {
                category = parentCategory;
            }
            category = (String)this.patch.apply(prod, category);
            for (IValue child : TreeAdapter.getArgs((ITree)tree)) {
                boolean specialCase = this.specialCaseHighlighting && !TreeAdapter.isChar((ITree)((ITree)child)) && ProductionAdapter.isSort((IConstructor)prod) && ProductionAdapter.isSort((IConstructor)TreeAdapter.getProduction((ITree)((ITree)child)));
                this.collect((ITree)child, specialCase ? null : category);
            }
        }

        private void collectAmb(ITree tree, @Nullable String parentCategory) {
            String category = parentCategory;
            ITree child = (ITree)TreeAdapter.getAlternatives((ITree)tree).iterator().next();
            this.collect(child, category);
        }

        private void collectChar(ITree tree, @Nullable String parentCategory) {
            int ch = TreeAdapter.getCharacter((ITree)tree);
            int length = Character.isSupplementaryCodePoint(ch) ? 2 : 1;
            this.tokens.addToken(this.line, this.column, length, parentCategory);
            if (ch == 10) {
                ++this.line;
                this.column = 0;
            } else {
                this.column += length;
            }
        }

        private static boolean isKeyword(ITree tree) {
            IConstructor p = tree.getProduction();
            if (!ProductionAdapter.isLiteral((IConstructor)p) && !ProductionAdapter.isCILiteral((IConstructor)p)) {
                return false;
            }
            for (IValue child : TreeAdapter.getArgs((ITree)tree)) {
                int ch = TreeAdapter.getCharacter((ITree)((ITree)child));
                if (ch == 45 || Character.isJavaIdentifierPart(ch)) continue;
                return false;
            }
            return true;
        }
    }

    private static class TokenTypes {
        private static final Map<String, Integer> cache = new HashMap<String, Integer>();
        public static final String AMBIGUITY = "ambiguity";
        public static final String UNCATEGORIZED = "uncategorized";
        private static String[][] backwardsCompatibleTokenTypes = new String[][]{{"uncategorized", "uncategorized"}, {"Type", "type"}, {"Identifier", "variable"}, {"variable", "variable"}, {"constant", "string"}, {"comment", "comment"}, {"Todo", "comment"}, {"Quote", "string"}, {"MetaAmbiguity", "ambiguity"}, {"MetaVariable", "variable"}, {"MetaKeyword", "keyword"}, {"MetaSkipped", "string"}, {"NonterminalLabel", "variable"}, {"Result", "string"}, {"StdOut", "string"}, {"StdErr", "string"}, {"entity.name", "class"}, {"entity.other.inherited-class", "class"}, {"entity.name.section", "type"}, {"entity.name.tag", "decorator"}, {"entity.other.attribute-name", "decorator"}, {"variable.language", "variable"}, {"variable.parameter", "parameter"}, {"variable.function", "function"}, {"constant", "number"}, {"constant.numeric", "number"}, {"constant.language", "keyword"}, {"constant.character.escape", "string"}, {"storage.type", "keyword"}, {"storage.modifier", "modifier"}, {"support", "keyword"}, {"keyword.control", "keyword"}, {"keyword.operator", "operator"}, {"keyword.declaration", "keyword"}, {"comment", "comment"}, {"comment.block.documentation", "comment"}, {"comment.block", "comment"}, {"comment.single", "comment"}, {"comment", "comment"}, {"constant.character.escape", "string"}, {"constant.language", "keyword"}, {"constant.numeric.complex.imaginary", "number"}, {"constant.numeric.complex.real", "number"}, {"constant.numeric.complex", "number"}, {"constant.numeric.float.binary", "number"}, {"constant.numeric.float.decimal", "number"}, {"constant.numeric.float.hexadecimal", "number"}, {"constant.numeric.float.octal", "number"}, {"constant.numeric.float.other", "number"}, {"constant.numeric.float", "number"}, {"constant.numeric.integer.binary", "number"}, {"constant.numeric.integer.decimal", "number"}, {"constant.numeric.integer.hexadecimal", "number"}, {"constant.numeric.integer.octal", "number"}, {"constant.numeric.integer.other", "number"}, {"constant.numeric.integer", "number"}, {"constant.numeric", "number"}, {"constant.other.placeholder", "number"}, {"constant.other", "number"}, {"entity.name.class.forward-decl", "class"}, {"entity.name.class", "class"}, {"entity.name.constant", "property"}, {"entity.name.enum", "enum"}, {"entity.name.function.constructor", "function"}, {"entity.name.function.destructor", "function"}, {"entity.name.function", "function"}, {"entity.name.interface", "interface"}, {"entity.name.label", "variable"}, {"entity.name.namespace", "namespace"}, {"entity.name.section", "type"}, {"entity.name.struct", "struct"}, {"entity.name.tag", "decorator"}, {"entity.name.trait", "typeParameter"}, {"entity.name.type", "type"}, {"entity.name.union", "struct"}, {"entity.name", "type"}, {"entity.other.attribute-name", "decorator"}, {"entity.other.inherited-class", "class"}, {"entity", "type"}, {"keyword.control.conditional", "keyword"}, {"keyword.control.import", "keyword"}, {"keyword.control", "keyword"}, {"keyword.declaration.class", "modifier"}, {"keyword.declaration.enum", "modifier"}, {"keyword.declaration.function", "modifier"}, {"keyword.declaration.impl", "modifier"}, {"keyword.declaration.interface", "modifier"}, {"keyword.declaration.struct", "modifier"}, {"keyword.declaration.trait", "modifier"}, {"keyword.declaration.type", "modifier"}, {"keyword.declaration.union", "modifier"}, {"keyword.declaration", "modifier"}, {"keyword.operator.arithmetic", "operator"}, {"keyword.operator.assignment", "operator"}, {"keyword.operator.bitwise", "operator"}, {"keyword.operator.logical", "operator"}, {"keyword.operator.word", "operator"}, {"keyword.operator", "operator"}, {"keyword.other", "keyword"}, {"keyword", "keyword"}, {"storage.modifier", "modifier"}, {"storage.type.class", "keyword"}, {"storage.type.enum", "keyword"}, {"storage.type.function", "keyword"}, {"storage.type.impl", "keyword"}, {"storage.type.interface", "keyword"}, {"storage.type.struct", "keyword"}, {"storage.type.trait", "keyword"}, {"storage.type.union", "keyword"}, {"storage.type", "keyword"}, {"string.quoted.double", "string"}, {"string.quoted.other", "string"}, {"string.quoted.single", "string"}, {"string.quoted.triple", "string"}, {"string.regexp", "regexp"}, {"string.unquoted", "string"}, {"support.class", "class"}, {"support.constant", "keyword"}, {"support.function", "function"}, {"support.module", "namespace"}, {"support.type", "type"}, {"text.html", "string"}, {"text.xml", "string"}, {"text", "string"}, {"variable.annotation", "variable"}, {"variable.function", "variable"}, {"variable.language", "keyword"}, {"variable.other.constant", "variable"}, {"variable.other.member", "variable"}, {"variable.other.readwrite", "variable"}, {"variable.other", "variable"}, {"variable.parameter", "parameter"}};
        private static final String[] rascalExtensions = new String[]{"ambiguity", "uncategorized"};
        private static final List<String> actualTokenTypes = Stream.concat(TokenTypes.getPublicStaticFieldValues(SemanticTokenTypes.class), Arrays.stream(rascalExtensions)).collect(Collectors.toUnmodifiableList());

        private TokenTypes() {
        }

        private static Stream<String> getPublicStaticFieldValues(Class<?> cls) {
            return Arrays.stream(SemanticTokenTypes.class.getFields()).filter(f -> f.getType() == String.class && Modifier.isStatic(f.getModifiers()) && f.canAccess(null)).map(f -> {
                try {
                    return (String)f.get(null);
                }
                catch (ReflectiveOperationException | RuntimeException e) {
                    logger.error("We could not get field {} from {}", f, (Object)cls, (Object)e);
                    throw new IllegalStateException(e);
                }
            });
        }

        public static List<String> getTokenTypes() {
            return actualTokenTypes;
        }

        public static List<String> getTokenModifiers() {
            return Collections.emptyList();
        }

        public static int tokenTypeForName(@Nullable String category) {
            Integer result;
            if (category == null) {
                category = UNCATEGORIZED;
            }
            return (result = cache.get(category)) != null ? result : -1;
        }

        static {
            for (int i = 0; i < actualTokenTypes.size(); ++i) {
                cache.put(actualTokenTypes.get(i), i);
            }
            for (String[] mapped : backwardsCompatibleTokenTypes) {
                Integer ref = cache.get(mapped[1]);
                if (ref == null) {
                    logger.error("Invalid mapping of backwards compatible tokens: {} to {}", (Object)mapped[0], (Object)mapped[1]);
                    continue;
                }
                cache.put(mapped[0], ref);
            }
        }
    }

    private static class TokenList {
        private final List<Integer> theList = new ArrayList<Integer>(500);
        private int previousLineAbsolute = 0;
        private int previousStartAbsolute = 0;

        private TokenList() {
        }

        public List<Integer> getTheList() {
            return Collections.unmodifiableList(this.theList);
        }

        public void addToken(int lineAbsolute, int startAbsolute, int length, @Nullable String category) {
            boolean canGrowPreviousToken;
            int type = TokenTypes.tokenTypeForName(category);
            boolean bl = canGrowPreviousToken = !this.theList.isEmpty() && lineAbsolute == this.previousLineAbsolute && startAbsolute == this.previousStartAbsolute + this.previous(TokenField.LENGTH) && type == this.previous(TokenField.TYPE);
            if (canGrowPreviousToken) {
                this.growPreviousToken(length);
            } else {
                this.theList.add(lineAbsolute - this.previousLineAbsolute);
                this.theList.add(lineAbsolute == this.previousLineAbsolute ? startAbsolute - this.previousStartAbsolute : startAbsolute);
                this.theList.add(length);
                this.theList.add(type);
                this.theList.add(0);
                this.previousLineAbsolute = lineAbsolute;
                this.previousStartAbsolute = startAbsolute;
            }
        }

        private int previousIndexOf(TokenField field) {
            return this.theList.size() - (5 - field.ordinal());
        }

        private int previous(TokenField field) {
            return this.theList.get(this.previousIndexOf(field));
        }

        private void growPreviousToken(int length) {
            int i = this.previousIndexOf(TokenField.LENGTH);
            this.theList.set(i, this.theList.get(i) + length);
        }

        private static enum TokenField {
            LINE,
            START,
            LENGTH,
            TYPE,
            MODIFIER;

        }
    }
}

