/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util.concurrent;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Stream;

public class CompletableFutureUtils {
    private CompletableFutureUtils() {
    }

    public static <T> CompletableFuture<T> completedFuture(T value, Executor exec) {
        return CompletableFuture.supplyAsync(() -> value, exec);
    }

    public static <T> CompletableFuture<List<T>> reduce(List<CompletableFuture<T>> futures, Executor exec) {
        return CompletableFutureUtils.reduce(futures, CompletableFutureUtils.completedFuture(new LinkedList(), exec), Collections::singletonList, CompletableFutureUtils::concat);
    }

    public static <T> CompletableFuture<List<T>> reduce(Stream<CompletableFuture<T>> futures, Executor exec) {
        return CompletableFutureUtils.reduce(futures, CompletableFutureUtils.completedFuture(new LinkedList(), exec), Collections::singletonList, CompletableFutureUtils::concat);
    }

    public static <I extends Iterable<?>> CompletableFuture<I> flatten(Stream<CompletableFuture<I>> futures, CompletableFuture<I> identity, BinaryOperator<I> concat) {
        return CompletableFutureUtils.reduce(futures, identity, Function.identity(), concat);
    }

    public static <I, C> CompletableFuture<C> reduce(Stream<CompletableFuture<I>> futures, CompletableFuture<C> identity, Function<I, C> map, BinaryOperator<C> concat) {
        return futures.map(t -> t.thenApply(map)).reduce(identity, (lf, rf) -> lf.thenCombine((CompletionStage)rf, (BiFunction)concat));
    }

    public static <I, C> CompletableFuture<C> reduce(Iterable<CompletableFuture<I>> futures, CompletableFuture<C> identity, Function<I, C> map, BinaryOperator<C> concat) {
        CompletionStage<Object> result = identity;
        for (CompletableFuture<I> fut : futures) {
            result = result.thenCombine(fut, (acc, t) -> concat.apply(acc, map.apply(t)));
        }
        return result;
    }

    private static <T> List<T> concat(List<T> l, List<T> r) {
        if (r.isEmpty()) {
            return l;
        }
        if (l.isEmpty()) {
            return r;
        }
        LinkedList<T> ls = new LinkedList<T>(l);
        ls.addAll(r);
        return ls;
    }
}

