/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;

public class InterruptibleFuture<T> {
    private final CompletableFuture<T> future;
    private final Runnable interrupt;
    private volatile boolean interrupted = false;

    public InterruptibleFuture(CompletableFuture<T> future, Runnable interrupt) {
        this.future = future;
        this.interrupt = interrupt;
    }

    public CompletableFuture<T> get() {
        return this.future;
    }

    public void interrupt() {
        if (!this.future.isDone()) {
            this.interrupt.run();
            this.interrupted = true;
        }
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public <U> InterruptibleFuture<U> thenApply(Function<T, U> func) {
        return new InterruptibleFuture<T>(this.future.thenApply((Function)func), this.interrupt);
    }

    public <U> InterruptibleFuture<U> thenApplyAsync(Function<T, U> func, Executor exec) {
        return new InterruptibleFuture<T>(this.future.thenApplyAsync((Function)func, exec), this.interrupt);
    }

    public InterruptibleFuture<Void> thenAccept(Consumer<T> func) {
        return new InterruptibleFuture<Void>((CompletableFuture<Void>)this.future.thenAccept((Consumer)func), this.interrupt);
    }

    public CompletableFuture<Void> thenAcceptIfUninterrupted(Consumer<? super T> action) {
        return this.future.thenAccept(t -> {
            if (!this.interrupted) {
                action.accept(t);
            }
        });
    }

    public <U> CompletableFuture<Void> thenAcceptBothIfUninterrupted(InterruptibleFuture<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.future.thenAcceptBoth(other.future, (t, u) -> {
            if (!this.interrupted && !other.interrupted) {
                action.accept(t, u);
            }
        });
    }

    public <U, V> InterruptibleFuture<V> thenCombineAsync(CompletableFuture<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return new InterruptibleFuture<T>(this.future.thenCombineAsync(other, fn, executor), this.interrupt);
    }

    public static <T> InterruptibleFuture<T> completedFuture(T result, Executor exec) {
        return new InterruptibleFuture<T>(CompletableFutureUtils.completedFuture(result, exec), () -> {});
    }

    public static <T> InterruptibleFuture<@PolyNull T> flatten(CompletableFuture<InterruptibleFuture<@PolyNull T>> f, Executor exec) {
        return new InterruptibleFuture<T>(f.thenCompose(InterruptibleFuture::get), () -> f.thenAcceptAsync(InterruptibleFuture::interrupt, exec));
    }
}

