/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class LazyUpdateableReference<T> {
    private final Function<T, T> updater;
    private final AtomicBoolean valid;
    private final AtomicReference<T> value;

    public LazyUpdateableReference(T emptyValue, Function<T, T> updater) {
        this.updater = updater;
        this.value = new AtomicReference<T>(emptyValue);
        this.valid = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        T result = this.value.get();
        if (!this.valid.get()) {
            LazyUpdateableReference lazyUpdateableReference = this;
            synchronized (lazyUpdateableReference) {
                if (!this.valid.get()) {
                    result = this.updater.apply(this.value.get());
                    this.value.set(result);
                    this.valid.set(true);
                }
            }
        }
        return result;
    }

    public void invalidate() {
        this.valid.set(false);
    }
}

