/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;

public class ReplaceableFuture<T> {
    private final AtomicReference<Runnable> interrupt;
    private final AtomicReference<CompletableFuture<T>> actual;

    public ReplaceableFuture(InterruptibleFuture<T> start) {
        this(start.get());
        this.interrupt.set(start::interrupt);
    }

    public ReplaceableFuture(CompletableFuture<T> start) {
        AtomicReference<CompletableFuture<T>> actRef = new AtomicReference<CompletableFuture<T>>(start);
        actRef.set(ReplaceableFuture.wrap(start, actRef));
        this.actual = actRef;
        this.interrupt = new AtomicReference<Runnable>(() -> {});
    }

    private static <T> CompletableFuture<T> wrap(CompletableFuture<T> original, AtomicReference<CompletableFuture<T>> current) {
        AtomicReference<@Nullable CompletionStage> self = new AtomicReference<CompletionStage>();
        CompletionStage result = original.handle((r, t) -> {
            CompletableFuture activeFuture = (CompletableFuture)current.get();
            CompletableFuture actualSelf = (CompletableFuture)self.get();
            if (actualSelf != null && activeFuture != actualSelf) {
                try {
                    return activeFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CompletionException(e);
                }
                catch (ExecutionException e) {
                    throw new CompletionException(e.getCause());
                }
            }
            if (t != null) {
                throw new CompletionException((Throwable)t);
            }
            return r;
        });
        self.set(result);
        return result;
    }

    public CompletableFuture<T> get() {
        return this.actual.get();
    }

    public CompletableFuture<T> replace(CompletableFuture<T> with) {
        CompletableFuture<T> result = ReplaceableFuture.wrap(with, this.actual);
        Runnable oldInterrupt = this.interrupt.getAndSet(() -> {});
        this.actual.set(result);
        oldInterrupt.run();
        return result;
    }

    public InterruptibleFuture<T> replace(InterruptibleFuture<T> with) {
        CompletableFuture<T> result = this.replace(with.get());
        this.interrupt.set(with::interrupt);
        return new InterruptibleFuture<T>(result, with::interrupt);
    }

    public static <T> ReplaceableFuture<T> completedFuture(T result, Executor exec) {
        return new ReplaceableFuture<T>(CompletableFutureUtils.completedFuture(result, exec));
    }
}

