/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util.locations.impl;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.util.Ranges;
import org.rascalmpl.vscode.lsp.util.locations.IRangeMap;

public class TreeMapLookup<T>
implements IRangeMap<T> {
    private final NavigableMap<Range, T> data = new TreeMap<Range, T>(TreeMapLookup::compareRanges);

    private static int compareRanges(Range a, Range b) {
        if (a.equals(b)) {
            return 0;
        }
        if (Ranges.containsRange(a, b)) {
            return 1;
        }
        if (Ranges.containsRange(b, a)) {
            return -1;
        }
        Position aStart = a.getStart();
        Position aEnd = a.getEnd();
        Position bStart = b.getStart();
        Position bEnd = b.getEnd();
        if (aStart.getLine() != bStart.getLine()) {
            return Integer.compare(bStart.getLine(), aStart.getLine());
        }
        if (aEnd.getLine() != bEnd.getLine()) {
            return Integer.compare(bEnd.getLine(), aEnd.getLine());
        }
        return Integer.compare(bEnd.getCharacter(), aEnd.getCharacter());
    }

    @Override
    public @Nullable T lookup(Range from) {
        return this.data.tailMap(from, true).entrySet().stream().filter(e -> Ranges.containsRange((Range)e.getKey(), from)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    @Override
    public @Nullable T lookup(Position at) {
        return this.lookup(new Range(at, at));
    }

    @Override
    public void put(Range from, T to) {
        this.data.put(from, to);
    }

    public @Nullable T getExact(Range from) {
        return (T)this.data.get(from);
    }

    public T computeIfAbsent(Range exact, Function<Range, T> compute) {
        return this.data.computeIfAbsent(exact, compute);
    }

    public static <T> IRangeMap<T> emptyMap() {
        return new IRangeMap<T>(){

            @Override
            public void put(Range area, T value) {
                throw new UnsupportedOperationException("Empty class map is not mutable");
            }

            @Override
            public @Nullable T lookup(Range from) {
                return null;
            }

            @Override
            public @Nullable T lookup(Position at) {
                return null;
            }
        };
    }
}

