/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp;

import com.google.gson.GsonBuilder;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SetTraceParams;
import org.eclipse.lsp4j.WorkDoneProgressCancelParams;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.rascalmpl.ideservices.GsonUtils;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.vscode.lsp.BaseWorkspaceService;
import org.rascalmpl.vscode.lsp.IBaseLanguageClient;
import org.rascalmpl.vscode.lsp.IBaseLanguageServerExtensions;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.IDEServicesConfiguration;
import org.rascalmpl.vscode.lsp.log.LogRedirectConfiguration;
import org.rascalmpl.vscode.lsp.parametric.LanguageRegistry;
import org.rascalmpl.vscode.lsp.terminal.RemoteIDEServicesThread;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.impl.VSCodeVFSClient;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.PathConfigParameter;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.VFSRegister;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public abstract class BaseLanguageServer {
    private static final PrintStream capturedOut;
    private static final InputStream capturedIn;
    private static final boolean DEPLOY_MODE;
    private static final String LOG_CONFIGURATION_KEY = "log4j2.configurationFactory";
    private static final Logger logger;
    private static final String DEFAULT_VERSION = "unknown";

    protected BaseLanguageServer() {
    }

    private static Launcher<IBaseLanguageClient> constructLSPClient(Socket client, ActualLanguageServer server, ExecutorService threadPool) throws IOException {
        client.setTcpNoDelay(true);
        return BaseLanguageServer.constructLSPClient(client.getInputStream(), client.getOutputStream(), server, threadPool);
    }

    private static Launcher<IBaseLanguageClient> constructLSPClient(InputStream in, OutputStream out, ActualLanguageServer server, ExecutorService threadPool) {
        Launcher<IBaseLanguageClient> clientLauncher = new Launcher.Builder().setLocalService(server).setRemoteInterface(IBaseLanguageClient.class).setInput(in).setOutput(out).configureGson(b -> GsonUtils.configureGson((GsonBuilder)b, (GsonUtils.ComplexTypeMode)GsonUtils.ComplexTypeMode.ENCODE_AS_JSON_OBJECT)).setExecutorService(threadPool).create();
        server.connect(clientLauncher.getRemoteProxy());
        return clientLauncher;
    }

    private static void printClassPath() {
        logger.trace("Started with classpath: {}", () -> System.getProperty("java.class.path"));
    }

    public static void startLanguageServer(ExecutorService requestPool, ExecutorService workerPool, Function<ExecutorService, IBaseTextDocumentService> docServiceProvider, BiFunction<ExecutorService, IBaseTextDocumentService, BaseWorkspaceService> workspaceServiceProvider, int portNumber) {
        logger.info("Starting Rascal Language Server: {}", (Object)BaseLanguageServer.getVersion());
        BaseLanguageServer.printClassPath();
        if (DEPLOY_MODE) {
            IBaseTextDocumentService docService = docServiceProvider.apply(workerPool);
            BaseWorkspaceService wsService = workspaceServiceProvider.apply(workerPool, docService);
            docService.pair(wsService);
            BaseLanguageServer.startLSP(BaseLanguageServer.constructLSPClient(capturedIn, capturedOut, new ActualLanguageServer(() -> System.exit(0), workerPool, docService, wsService), requestPool));
        } else {
            try {
                ServerSocket serverSocket = new ServerSocket(portNumber, 0, InetAddress.getByName("127.0.0.1"));
                try {
                    logger.info("Rascal LSP server listens on port number: {}", (Object)portNumber);
                    while (true) {
                        IBaseTextDocumentService docService = docServiceProvider.apply(workerPool);
                        BaseWorkspaceService wsService = workspaceServiceProvider.apply(workerPool, docService);
                        docService.pair(wsService);
                        BaseLanguageServer.startLSP(BaseLanguageServer.constructLSPClient(serverSocket.accept(), new ActualLanguageServer(() -> {}, workerPool, docService, wsService), requestPool));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.fatal("Failure to start TCP server on port {}", (Object)portNumber, (Object)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersion() {
        try (InputStream prop = ActualLanguageServer.class.getClassLoader().getResourceAsStream("project.properties");){
            if (prop == null) {
                logger.error("Could not find project.properties file");
                String string2 = DEFAULT_VERSION;
                return string2;
            }
            Properties properties = new Properties();
            properties.load(prop);
            String string = properties.getProperty("rascal.lsp.version", DEFAULT_VERSION) + " at " + properties.getProperty("rascal.lsp.build.timestamp", DEFAULT_VERSION);
            return string;
        }
        catch (IOException e) {
            logger.debug("Cannot find lsp version", (Throwable)e);
            return DEFAULT_VERSION;
        }
    }

    private static void startLSP(Launcher<IBaseLanguageClient> server) {
        block5: {
            try {
                server.startListening().get();
            }
            catch (InterruptedException e) {
                logger.trace("Interrupted server", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                logger.fatal("Unexpected exception", e.getCause());
                if (DEPLOY_MODE) {
                    System.exit(1);
                }
            }
            catch (Throwable e) {
                logger.fatal("Unexpected exception", e);
                if (!DEPLOY_MODE) break block5;
                System.exit(1);
            }
        }
    }

    static {
        DEPLOY_MODE = System.getProperty("rascal.lsp.deploy", "false").equalsIgnoreCase("true");
        if (DEPLOY_MODE) {
            capturedIn = System.in;
            capturedOut = System.out;
            System.setIn(new ByteArrayInputStream(new byte[0]));
            System.setOut(new PrintStream(System.err, false));
        } else {
            capturedIn = InputStream.nullInputStream();
            capturedOut = new PrintStream(OutputStream.nullOutputStream());
        }
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        System.setProperty(LOG_CONFIGURATION_KEY, System.getProperty(LOG_CONFIGURATION_KEY, LogRedirectConfiguration.class.getName()));
        logger = LogManager.getLogger(BaseLanguageServer.class);
    }

    private static class ActualLanguageServer
    implements IBaseLanguageServerExtensions,
    LanguageClientAware {
        static final Logger logger = LogManager.getLogger(ActualLanguageServer.class);
        private final IBaseTextDocumentService lspDocumentService;
        private final BaseWorkspaceService lspWorkspaceService;
        private final Runnable onExit;
        private final ExecutorService executor;
        private @MonotonicNonNull IDEServicesConfiguration remoteIDEServicesConfiguration;

        private ActualLanguageServer(Runnable onExit, ExecutorService executor, IBaseTextDocumentService lspDocumentService, BaseWorkspaceService lspWorkspaceService) {
            this.onExit = onExit;
            this.executor = executor;
            this.lspDocumentService = lspDocumentService;
            this.lspWorkspaceService = lspWorkspaceService;
        }

        @Override
        public CompletableFuture<IDEServicesConfiguration> supplyRemoteIDEServicesConfiguration() {
            if (this.remoteIDEServicesConfiguration == null) {
                return CompletableFuture.failedFuture(new IllegalStateException("No RemoteIDEServices configuration is set"));
            }
            return CompletableFutureUtils.completedFuture(this.remoteIDEServicesConfiguration, this.executor);
        }

        private static URI[] toURIArray(IList src) {
            return (URI[])src.stream().map(ISourceLocation.class::cast).map(Locations::toUri).toArray(URI[]::new);
        }

        @Override
        public CompletableFuture<Tuple.Two<String, URI[]>[]> supplyPathConfig(PathConfigParameter projectFolder) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    PathConfig pcfg = PathConfig.fromSourceProjectMemberRascalManifest((ISourceLocation)projectFolder.getLocation(), (PathConfig.RascalConfigMode)projectFolder.getMode().mapConfigMode());
                    Tuple.Two[] result = new Tuple.Two[]{new Tuple.Two<String, URI[]>("Sources", ActualLanguageServer.toURIArray(pcfg.getSrcs())), new Tuple.Two<String, URI[]>("Libraries", ActualLanguageServer.toURIArray(pcfg.getLibs()))};
                    return result;
                }
                catch (URISyntaxException e) {
                    logger.catching(e);
                    throw new CompletionException(e);
                }
            }, this.executor);
        }

        @Override
        public CompletableFuture<Void> sendRegisterLanguage(LanguageRegistry.LanguageParameter lang) {
            return CompletableFuture.runAsync(() -> this.lspDocumentService.registerLanguage(lang), this.executor);
        }

        @Override
        public CompletableFuture<Void> sendUnregisterLanguage(LanguageRegistry.LanguageParameter lang) {
            return CompletableFuture.runAsync(() -> this.lspDocumentService.unregisterLanguage(lang), this.executor);
        }

        @Override
        public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
            return CompletableFuture.supplyAsync(() -> {
                logger.info("LSP connection started (connected to {} version {})", (Object)params.getClientInfo().getName(), (Object)params.getClientInfo().getVersion());
                logger.debug("LSP client capabilities: {}", (Object)params.getCapabilities());
                InitializeResult initializeResult = new InitializeResult(new ServerCapabilities());
                this.lspDocumentService.initializeServerCapabilities(initializeResult.getCapabilities());
                this.lspWorkspaceService.initialize(params.getCapabilities(), params.getWorkspaceFolders(), initializeResult.getCapabilities());
                logger.debug("Initialized LSP connection with capabilities: {}", (Object)initializeResult);
                return initializeResult;
            }, this.executor);
        }

        @Override
        public void initialized(InitializedParams params) {
            this.executor.submit(() -> {
                logger.debug("LSP connection initialized");
                this.lspWorkspaceService.initialized();
                this.lspDocumentService.initialized();
            });
        }

        @Override
        public CompletableFuture<Object> shutdown() {
            return CompletableFuture.supplyAsync(() -> {
                this.lspDocumentService.shutdown();
                return true;
            }, this.executor);
        }

        @Override
        public void exit() {
            this.onExit.run();
        }

        @Override
        public IBaseTextDocumentService getTextDocumentService() {
            return this.lspDocumentService;
        }

        @Override
        public BaseWorkspaceService getWorkspaceService() {
            return this.lspWorkspaceService;
        }

        @Override
        public void setTrace(SetTraceParams params) {
            logger.trace("Got trace request: {}", (Object)params);
        }

        @Override
        public void connect(LanguageClient client) {
            IBaseLanguageClient actualClient = (IBaseLanguageClient)client;
            this.lspDocumentService.connect(actualClient);
            this.lspWorkspaceService.connect(actualClient);
            this.remoteIDEServicesConfiguration = RemoteIDEServicesThread.startRemoteIDEServicesServer(client, this.lspDocumentService, this.executor);
            logger.debug("Remote IDE Services Port {}", (Object)this.remoteIDEServicesConfiguration);
        }

        @Override
        public void registerVFS(VFSRegister registration) {
            VSCodeVFSClient.buildAndRegister(registration.getPort());
        }

        @Override
        public void cancelProgress(WorkDoneProgressCancelParams params) {
            this.lspDocumentService.cancelProgress(params.getToken().getLeft());
        }

        @Override
        public void setMinimumLogLevel(String level) {
            Level l = Level.toLevel(level, Level.DEBUG);
            Configurator.setRootLevel(l);
        }
    }
}

