/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp;

import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CreateFilesParams;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FileDelete;
import org.eclipse.lsp4j.FileOperationFilter;
import org.eclipse.lsp4j.FileOperationOptions;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public abstract class BaseWorkspaceService
implements WorkspaceService,
LanguageClientAware {
    private static final Logger logger = LogManager.getLogger(BaseWorkspaceService.class);
    private @MonotonicNonNull LanguageClient client;
    public static final String RASCAL_LANGUAGE = "Rascal";
    public static final String RASCAL_META_COMMAND = "rascal-meta-command";
    public static final String RASCAL_COMMAND = "rascal-command";
    private final ExecutorService exec;
    private final IBaseTextDocumentService documentService;
    private final CopyOnWriteArrayList<WorkspaceFolder> workspaceFolders = new CopyOnWriteArrayList();
    private final List<FileOperationFilter> interestedInFiles;

    protected BaseWorkspaceService(ExecutorService exec, IBaseTextDocumentService documentService, List<FileOperationFilter> interestedInFiles) {
        this.documentService = documentService;
        this.exec = exec;
        this.interestedInFiles = interestedInFiles;
    }

    public void initialize(ClientCapabilities clientCap, @Nullable List<WorkspaceFolder> currentWorkspaceFolders, ServerCapabilities capabilities) {
        this.workspaceFolders.clear();
        if (currentWorkspaceFolders != null) {
            this.workspaceFolders.addAll(currentWorkspaceFolders);
        }
        WorkspaceClientCapabilities clientWorkspaceCap = clientCap.getWorkspace();
        WorkspaceServerCapabilities workspaceCapabilities = new WorkspaceServerCapabilities();
        if (clientWorkspaceCap != null) {
            if (clientWorkspaceCap.getWorkspaceFolders().booleanValue()) {
                WorkspaceFoldersOptions folderOptions = new WorkspaceFoldersOptions();
                folderOptions.setSupported(true);
                folderOptions.setChangeNotifications(true);
                workspaceCapabilities.setWorkspaceFolders(folderOptions);
            }
            FileOperationsServerCapabilities fileOperationCapabilities = new FileOperationsServerCapabilities();
            FileOperationOptions whichFiles = new FileOperationOptions(this.interestedInFiles);
            boolean watchesSet = false;
            if (clientWorkspaceCap.getFileOperations().getDidRename().booleanValue()) {
                fileOperationCapabilities.setDidRename(whichFiles);
                watchesSet = true;
            }
            if (clientWorkspaceCap.getFileOperations().getDidDelete().booleanValue()) {
                fileOperationCapabilities.setDidDelete(whichFiles);
                watchesSet = true;
            }
            if (watchesSet) {
                workspaceCapabilities.setFileOperations(fileOperationCapabilities);
            }
        }
        capabilities.setWorkspace(workspaceCapabilities);
    }

    public List<WorkspaceFolder> workspaceFolders() {
        return Collections.unmodifiableList(this.workspaceFolders);
    }

    @Override
    public void connect(LanguageClient client) {
        this.client = client;
    }

    void initialized() {
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
    }

    @Override
    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
    }

    @Override
    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        List<WorkspaceFolder> added;
        List<WorkspaceFolder> removed = params.getEvent().getRemoved();
        if (removed != null) {
            this.workspaceFolders.removeAll(removed);
            for (WorkspaceFolder folder : removed) {
                this.documentService.projectRemoved(folder.getName(), Locations.toLoc(folder.getUri()));
            }
        }
        if ((added = params.getEvent().getAdded()) != null) {
            this.workspaceFolders.addAll(added);
            for (WorkspaceFolder folder : added) {
                this.documentService.projectAdded(folder.getName(), Locations.toLoc(folder.getUri()));
            }
        }
    }

    @Override
    public void didCreateFiles(CreateFilesParams params) {
        logger.debug("workspace/didCreateFiles: {}", (Object)params.getFiles());
        this.exec.submit(() -> this.documentService.didCreateFiles(params));
    }

    @Override
    public void didRenameFiles(RenameFilesParams params) {
        logger.debug("workspace/didRenameFiles: {}", (Object)params.getFiles());
        this.exec.submit(() -> this.documentService.didRenameFiles(params, this.workspaceFolders()));
        this.exec.submit(() -> {
            List<FileDelete> oldFiles = params.getFiles().stream().map(f -> f.getOldUri()).map(FileDelete::new).collect(Collectors.toList());
            this.documentService.didDeleteFiles(new DeleteFilesParams(oldFiles));
        });
    }

    @Override
    public void didDeleteFiles(DeleteFilesParams params) {
        logger.debug("workspace/didDeleteFiles: {}", (Object)params.getFiles());
        this.exec.submit(() -> this.documentService.didDeleteFiles(params));
    }

    @Override
    public CompletableFuture<Object> executeCommand(ExecuteCommandParams commandParams) {
        logger.debug("workspace/executeCommand: {}", (Object)commandParams);
        return CompletableFutureUtils.completedFuture(commandParams, this.exec).thenCompose(params -> {
            if (params.getCommand().startsWith(RASCAL_META_COMMAND) || params.getCommand().startsWith(RASCAL_COMMAND)) {
                String languageName = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                String command = ((JsonPrimitive)params.getArguments().get(1)).getAsString();
                return this.documentService.executeCommand(languageName, command).thenApply(v -> v);
            }
            return CompletableFutureUtils.completedFuture(params.getCommand() + " was ignored.", this.exec);
        });
    }

    protected final ExecutorService getExecutor() {
        return this.exec;
    }
}

