/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.CreateFilesParams;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.util.locations.LineColumnOffsetMap;
import org.rascalmpl.vscode.lsp.BaseWorkspaceService;
import org.rascalmpl.vscode.lsp.TextDocumentState;
import org.rascalmpl.vscode.lsp.parametric.LanguageRegistry;

public interface IBaseTextDocumentService
extends TextDocumentService {
    public static final Duration NO_DEBOUNCE = Duration.ZERO;
    public static final Duration NORMAL_DEBOUNCE = Duration.ofMillis(800L);

    public void initializeServerCapabilities(ServerCapabilities var1);

    public void shutdown();

    public void connect(LanguageClient var1);

    public void pair(BaseWorkspaceService var1);

    public void initialized();

    public void registerLanguage(LanguageRegistry.LanguageParameter var1);

    public void unregisterLanguage(LanguageRegistry.LanguageParameter var1);

    public void projectAdded(String var1, ISourceLocation var2);

    public void projectRemoved(String var1, ISourceLocation var2);

    public CompletableFuture<IValue> executeCommand(String var1, String var2);

    public LineColumnOffsetMap getColumnMap(ISourceLocation var1);

    public ColumnMaps getColumnMaps();

    public @Nullable TextDocumentState getDocumentState(ISourceLocation var1);

    public boolean isManagingFile(ISourceLocation var1);

    public void didCreateFiles(CreateFilesParams var1);

    public void didRenameFiles(RenameFilesParams var1, List<WorkspaceFolder> var2);

    public void didDeleteFiles(DeleteFilesParams var1);

    public void cancelProgress(String var1);
}

