/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NotDirectoryException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.UnsupportedSchemeException;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.vscode.lsp.util.NamedThreadPool;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public interface IRascalFileSystemServices {
    public static final URIResolverRegistry reg = URIResolverRegistry.getInstance();
    public static final Logger IRascalFileSystemServices__logger = LogManager.getLogger(IRascalFileSystemServices.class);
    public static final ExecutorService executor = NamedThreadPool.cachedDaemon("rascal-vfs");

    @JsonRequest(value="rascal/filesystem/resolveLocation")
    default public CompletableFuture<SourceLocation> resolveLocation(SourceLocation loc) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ISourceLocation tmp = loc.toRascalLocation();
                ISourceLocation resolved = Locations.toClientLocation(tmp);
                if (resolved == null) {
                    return loc;
                }
                return SourceLocation.fromRascalLocation(resolved);
            }
            catch (Exception e) {
                IRascalFileSystemServices__logger.warn("Could not resolve location {}", (Object)loc, (Object)e);
                return loc;
            }
        }, executor);
    }

    @JsonRequest(value="rascal/filesystem/watch")
    default public CompletableFuture<Void> watch(WatchParameters params) {
        return CompletableFuture.runAsync(() -> {
            try {
                ISourceLocation loc = params.getLocation();
                URIResolverRegistry.getInstance().watch(loc, params.isRecursive(), changed -> {
                    try {
                        this.onDidChangeFile(IRascalFileSystemServices.convertChangeEvent(changed));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (IOException | RuntimeException | URISyntaxException e) {
                throw new VSCodeFSError(e);
            }
        }, executor);
    }

    public static FileChangeEvent convertChangeEvent(ISourceLocationWatcher.ISourceLocationChanged changed) throws IOException {
        return new FileChangeEvent(IRascalFileSystemServices.convertFileChangeType(changed.getChangeType()), Locations.toUri(changed.getLocation()).toASCIIString());
    }

    public static FileChangeType convertFileChangeType(ISourceLocationWatcher.ISourceLocationChangeType changeType) throws IOException {
        switch (changeType) {
            case CREATED: {
                return FileChangeType.Created;
            }
            case DELETED: {
                return FileChangeType.Deleted;
            }
            case MODIFIED: {
                return FileChangeType.Changed;
            }
        }
        throw new IOException("unknown change type: " + String.valueOf(changeType));
    }

    private static boolean readonly(ISourceLocation loc) throws IOException {
        if (reg.getRegisteredOutputSchemes().contains(loc.getScheme())) {
            return false;
        }
        if (reg.getRegisteredLogicalSchemes().contains(loc.getScheme())) {
            ISourceLocation resolved = Locations.toClientLocation(loc);
            if (resolved != null && resolved != loc) {
                return IRascalFileSystemServices.readonly(resolved);
            }
            return true;
        }
        return true;
    }

    @JsonRequest(value="rascal/filesystem/stat")
    default public CompletableFuture<FileStat> stat(URIParameter uri) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ISourceLocation loc = uri.getLocation();
                if (!reg.exists(loc)) {
                    throw new FileNotFoundException();
                }
                long created = reg.created(loc);
                long lastModified = reg.lastModified(loc);
                if (reg.isDirectory(loc)) {
                    return new FileStat(FileType.Directory, created, lastModified, 0L, null);
                }
                long size = 0L;
                if (reg.supportsReadableFileChannel(loc)) {
                    try (FileChannel c = reg.getReadableFileChannel(loc);){
                        size = c.size();
                    }
                } else {
                    size = Prelude.__getFileSize((IValueFactory)IRascalValueFactory.getInstance(), (ISourceLocation)loc).longValue();
                }
                return new FileStat(FileType.File, created, lastModified, size, IRascalFileSystemServices.readonly(loc) ? FilePermission.Readonly : null);
            }
            catch (IOException | RuntimeException | URISyntaxException e) {
                throw new VSCodeFSError(e);
            }
        }, executor);
    }

    @JsonRequest(value="rascal/filesystem/readDirectory")
    default public CompletableFuture<FileWithType[]> readDirectory(URIParameter uri) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ISourceLocation loc = uri.getLocation();
                if (!reg.isDirectory(loc)) {
                    throw VSCodeFSError.notADirectory(loc);
                }
                return (FileWithType[])Arrays.stream(reg.list(loc)).map(l -> new FileWithType(URIUtil.getLocationName((ISourceLocation)l), reg.isDirectory(l) ? FileType.Directory : FileType.File)).toArray(FileWithType[]::new);
            }
            catch (IOException | RuntimeException | URISyntaxException e) {
                throw new VSCodeFSError(e);
            }
        }, executor);
    }

    @JsonRequest(value="rascal/filesystem/createDirectory")
    default public CompletableFuture<Void> createDirectory(URIParameter uri) {
        return CompletableFuture.runAsync(() -> {
            try {
                reg.mkDirectory(uri.getLocation());
            }
            catch (IOException | RuntimeException | URISyntaxException e) {
                throw new VSCodeFSError(e);
            }
        }, executor);
    }

    @JsonRequest(value="rascal/filesystem/readFile")
    default public CompletableFuture<LocationContent> readFile(URIParameter uri) {
        return CompletableFuture.supplyAsync(() -> {
            LocationContent locationContent;
            Base64InputStream source = new Base64InputStream(reg.getInputStream(uri.getLocation()), true);
            try {
                locationContent = new LocationContent(new String(source.readAllBytes(), StandardCharsets.US_ASCII));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        source.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException | URISyntaxException e) {
                    throw new VSCodeFSError(e);
                }
            }
            source.close();
            return locationContent;
        }, executor);
    }

    @JsonRequest(value="rascal/filesystem/writeFile")
    default public CompletableFuture<Void> writeFile(WriteFileParameters params) {
        return CompletableFuture.runAsync(() -> {
            try {
                ISourceLocation loc = params.getLocation();
                boolean fileExists = reg.exists(loc);
                if (!fileExists && !params.isCreate()) {
                    throw new FileNotFoundException(loc.toString());
                }
                if (fileExists && reg.isDirectory(loc)) {
                    throw VSCodeFSError.isADirectory(loc);
                }
                ISourceLocation parentFolder = URIUtil.getParentLocation((ISourceLocation)loc);
                if (!reg.exists(parentFolder) && params.isCreate()) {
                    throw new FileNotFoundException(parentFolder.toString());
                }
                if (fileExists && params.isCreate() && !params.isOverwrite()) {
                    throw new FileAlreadyExistsException(loc.toString());
                }
                try (OutputStream target = reg.getOutputStream(loc, false);){
                    target.write(Base64.getDecoder().decode(params.getContent()));
                }
            }
            catch (IOException | RuntimeException | URISyntaxException e) {
                throw new VSCodeFSError(e);
            }
        }, executor);
    }

    @JsonRequest(value="rascal/filesystem/delete")
    default public CompletableFuture<Void> delete(DeleteParameters params) {
        return CompletableFuture.runAsync(() -> {
            try {
                ISourceLocation loc = params.getLocation();
                reg.remove(loc, params.isRecursive());
            }
            catch (IOException | URISyntaxException e) {
                throw new CompletionException(e);
            }
        }, executor);
    }

    @JsonRequest(value="rascal/filesystem/rename")
    default public CompletableFuture<Void> rename(RenameParameters params) {
        return CompletableFuture.runAsync(() -> {
            try {
                ISourceLocation oldLoc = params.getOldLocation();
                ISourceLocation newLoc = params.getNewLocation();
                reg.rename(oldLoc, newLoc, params.isOverwrite());
            }
            catch (IOException | URISyntaxException e) {
                throw new CompletionException(e);
            }
        }, executor);
    }

    @JsonRequest(value="rascal/filesystem/schemes")
    default public CompletableFuture<String[]> fileSystemSchemes() {
        Set inputs = reg.getRegisteredInputSchemes();
        Set logicals = reg.getRegisteredLogicalSchemes();
        return CompletableFuture.completedFuture((String[])Stream.concat(inputs.stream(), logicals.stream()).toArray(String[]::new));
    }

    @JsonNotification(value="rascal/filesystem/onDidChangeFile")
    default public void onDidChangeFile(FileChangeEvent event) {
    }

    public static class VSCodeFSError
    extends ResponseErrorException {
        public VSCodeFSError(Exception original) {
            super(VSCodeFSError.translate(original));
        }

        private static ResponseError fileExists(Object data) {
            return new ResponseError(-1, "File exists", data);
        }

        private static ResponseError fileIsADirectory(Object data) {
            return new ResponseError(-2, "File is a directory", data);
        }

        private static ResponseError fileNotADirectory(Object data) {
            return new ResponseError(-3, "File is not a directory", data);
        }

        private static ResponseError fileNotFound(Object data) {
            return new ResponseError(-4, "File is not found", data);
        }

        private static ResponseError noPermissions(Object data) {
            return new ResponseError(-5, "No permissions", data);
        }

        private static ResponseError unavailable(Object data) {
            return new ResponseError(-6, "Unavailable", data);
        }

        private static ResponseError generic(@Nullable String message, Object data) {
            return new ResponseError(-99, message == null ? "no error message was provided" : message, data);
        }

        public static ResponseErrorException notADirectory(Object data) {
            return new ResponseErrorException(VSCodeFSError.fileNotADirectory(data));
        }

        public static ResponseErrorException isADirectory(Object data) {
            return new ResponseErrorException(VSCodeFSError.fileIsADirectory(data));
        }

        private static ResponseError translate(Exception original) {
            if (original instanceof FileNotFoundException || original instanceof UnsupportedSchemeException || original instanceof URISyntaxException) {
                return VSCodeFSError.fileNotFound(original);
            }
            if (original instanceof FileAlreadyExistsException) {
                return VSCodeFSError.fileExists(original);
            }
            if (original instanceof NotDirectoryException) {
                return VSCodeFSError.fileNotADirectory(original);
            }
            if (original instanceof SecurityException) {
                return VSCodeFSError.noPermissions(original);
            }
            if (original instanceof ResponseErrorException) {
                return ((ResponseErrorException)original).getResponseError();
            }
            return VSCodeFSError.generic(original.getMessage(), original);
        }
    }

    public static class WriteFileParameters {
        @NonNull
        private final String uri;
        @NonNull
        private final String content;
        private final boolean create;
        private final boolean overwrite;

        public WriteFileParameters(@NonNull String uri, @NonNull String content, boolean create, boolean overwrite) {
            this.uri = uri;
            this.content = content;
            this.create = create;
            this.overwrite = overwrite;
        }

        public String getUri() {
            return this.uri;
        }

        public ISourceLocation getLocation() throws URISyntaxException {
            return new URIParameter(this.uri).getLocation();
        }

        public String getContent() {
            return this.content;
        }

        public boolean isCreate() {
            return this.create;
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }
    }

    public static class URIParameter {
        @NonNull
        private final String uri;

        public URIParameter(@NonNull String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }

        public ISourceLocation getLocation() throws URISyntaxException {
            return Locations.toCheckedLoc(this.uri);
        }
    }

    public static class LocationContent {
        @NonNull
        private final String content;

        public LocationContent(@NonNull String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }

    public static class FileWithType {
        @NonNull
        private final String name;
        @NonNull
        private final FileType type;

        public FileWithType(@NonNull String name, @NonNull FileType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public FileType getType() {
            return this.type;
        }
    }

    public static final class FilePermission
    extends Enum<FilePermission> {
        public static final /* enum */ FilePermission Readonly = new FilePermission(1);
        private final int value;
        private static final /* synthetic */ FilePermission[] $VALUES;

        public static FilePermission[] values() {
            return (FilePermission[])$VALUES.clone();
        }

        public static FilePermission valueOf(String name) {
            return Enum.valueOf(FilePermission.class, name);
        }

        private FilePermission(int val) {
            assert (val == 1);
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new FilePermission[]{Readonly};
        }
    }

    public static final class FileType
    extends Enum<FileType> {
        public static final /* enum */ FileType Unknown = new FileType(0);
        public static final /* enum */ FileType File = new FileType(1);
        public static final /* enum */ FileType Directory = new FileType(2);
        public static final /* enum */ FileType SymbolicLink = new FileType(64);
        private final int value;
        private static final /* synthetic */ FileType[] $VALUES;

        public static FileType[] values() {
            return (FileType[])$VALUES.clone();
        }

        public static FileType valueOf(String name) {
            return Enum.valueOf(FileType.class, name);
        }

        private FileType(int val) {
            assert (val == 0 || val == 1 || val == 2 || val == 64);
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new FileType[]{Unknown, File, Directory, SymbolicLink};
        }
    }

    public static class FileStat {
        private final FileType type;
        private final long ctime;
        private final long mtime;
        private final long size;
        private @Nullable FilePermission permissions;

        public FileStat(FileType type, long ctime, long mtime, long size, @Nullable FilePermission permissions) {
            this.type = type;
            this.ctime = ctime;
            this.mtime = mtime;
            this.size = size;
            this.permissions = permissions;
        }
    }

    public static final class FileChangeType
    extends Enum<FileChangeType> {
        public static final /* enum */ FileChangeType Changed = new FileChangeType(1);
        public static final /* enum */ FileChangeType Created = new FileChangeType(2);
        public static final /* enum */ FileChangeType Deleted = new FileChangeType(3);
        private final int value;
        private static final /* synthetic */ FileChangeType[] $VALUES;

        public static FileChangeType[] values() {
            return (FileChangeType[])$VALUES.clone();
        }

        public static FileChangeType valueOf(String name) {
            return Enum.valueOf(FileChangeType.class, name);
        }

        private FileChangeType(int val) {
            assert (val == 1 || val == 2 || val == 3);
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new FileChangeType[]{Changed, Created, Deleted};
        }
    }

    public static class FileChangeEvent {
        @NonNull
        private final FileChangeType type;
        @NonNull
        private final String uri;

        public FileChangeEvent(FileChangeType type, @NonNull String uri) {
            this.type = type;
            this.uri = uri;
        }

        public FileChangeType getType() {
            return this.type;
        }

        public ISourceLocation getLocation() throws URISyntaxException {
            return new URIParameter(this.uri).getLocation();
        }
    }

    public static class SourceLocation {
        @NonNull
        private final String uri;
        private final int @Nullable [] offsetLength;
        private final int @Nullable [] beginLineColumn;
        private final int @Nullable [] endLineColumn;

        public static SourceLocation fromRascalLocation(ISourceLocation loc) {
            if (loc.hasOffsetLength()) {
                if (loc.hasLineColumn()) {
                    return new SourceLocation(Locations.toUri(loc).toString(), loc.getOffset(), loc.getLength(), loc.getBeginLine(), loc.getBeginColumn(), loc.getEndLine(), loc.getEndColumn());
                }
                return new SourceLocation(Locations.toUri(loc).toString(), loc.getOffset(), loc.getLength());
            }
            return new SourceLocation(Locations.toUri(loc).toString());
        }

        public ISourceLocation toRascalLocation() throws URISyntaxException {
            IRascalValueFactory VF = IRascalValueFactory.getInstance();
            ISourceLocation tmp = Locations.toCheckedLoc(this.uri);
            if (this.hasOffsetLength()) {
                tmp = this.hasLineColumn() ? VF.sourceLocation(tmp, this.getOffset(), this.getLength(), this.getBeginLine(), this.getEndLine(), this.getBeginColumn(), this.getEndColumn()) : VF.sourceLocation(tmp, this.getOffset(), this.getLength());
            }
            return tmp;
        }

        private SourceLocation(String uri, int offset, int length, int beginLine, int beginColumn, int endLine, int endColumn) {
            this.uri = uri;
            this.offsetLength = new int[]{offset, length};
            this.beginLineColumn = new int[]{beginLine, beginColumn};
            this.endLineColumn = new int[]{endLine, endColumn};
        }

        private SourceLocation(String uri, int offset, int length) {
            this.uri = uri;
            this.offsetLength = new int[]{offset, length};
            this.beginLineColumn = null;
            this.endLineColumn = null;
        }

        private SourceLocation(String uri) {
            this.uri = uri;
            this.offsetLength = null;
            this.beginLineColumn = null;
            this.endLineColumn = null;
        }

        public String getUri() {
            return this.uri;
        }

        @EnsuresNonNullIf(expression={"this.offsetLength"}, result=true)
        public boolean hasOffsetLength() {
            return this.offsetLength != null;
        }

        @EnsuresNonNullIf.List(value={@EnsuresNonNullIf(expression={"this.endLineColumn"}, result=true), @EnsuresNonNullIf(expression={"this.beginLineColumn"}, result=true)})
        public boolean hasLineColumn() {
            return this.beginLineColumn != null && this.endLineColumn != null;
        }

        public int getOffset() {
            if (!this.hasOffsetLength()) {
                throw new IllegalStateException("This location has no offset");
            }
            return this.offsetLength[0];
        }

        public int getLength() {
            if (!this.hasOffsetLength()) {
                throw new IllegalStateException("This location has no length");
            }
            return this.offsetLength[1];
        }

        public int getBeginLine() {
            if (!this.hasLineColumn()) {
                throw new IllegalStateException("This location has no line and columns");
            }
            return this.beginLineColumn[0];
        }

        public int getBeginColumn() {
            if (!this.hasLineColumn()) {
                throw new IllegalStateException("This location has no line and columns");
            }
            return this.beginLineColumn[1];
        }

        public int getEndLine() {
            if (!this.hasLineColumn()) {
                throw new IllegalStateException("This location has no line and columns");
            }
            return this.endLineColumn[0];
        }

        public int getEndColumn() {
            if (!this.hasLineColumn()) {
                throw new IllegalStateException("This location has no line and columns");
            }
            return this.endLineColumn[1];
        }
    }

    public static class WatchParameters {
        private final String uri;
        private final boolean recursive;
        private final String[] excludes;

        public WatchParameters(String uri, boolean recursive, String[] excludes) {
            this.uri = uri;
            this.recursive = recursive;
            this.excludes = excludes;
        }

        public ISourceLocation getLocation() throws URISyntaxException {
            return new URIParameter(this.uri).getLocation();
        }

        public String[] getExcludes() {
            return this.excludes;
        }

        public boolean isRecursive() {
            return this.recursive;
        }
    }

    public static class RenameParameters {
        private final String oldUri;
        private final String newUri;
        private final boolean overwrite;

        public RenameParameters(String oldUri, String newUri, boolean overwrite) {
            this.oldUri = oldUri;
            this.newUri = newUri;
            this.overwrite = overwrite;
        }

        public ISourceLocation getOldLocation() throws URISyntaxException {
            return new URIParameter(this.oldUri).getLocation();
        }

        public ISourceLocation getNewLocation() throws URISyntaxException {
            return new URIParameter(this.newUri).getLocation();
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }
    }

    public static class DeleteParameters {
        private final String uri;
        private final boolean recursive;

        public DeleteParameters(String uri, boolean recursive) {
            this.uri = uri;
            this.recursive = recursive;
        }

        public ISourceLocation getLocation() throws URISyntaxException {
            return new URIParameter(this.uri).getLocation();
        }

        public boolean isRecursive() {
            return this.recursive;
        }
    }
}

