/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp;

import io.usethesource.vallang.ISourceLocation;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressNotification;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.vscode.lsp.IBaseLanguageClient;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;

public class RascalLSPMonitor
implements IRascalMonitor {
    private final Logger logger;
    private final IBaseLanguageClient languageClient;
    private final String progressPrefix;
    private final ThreadLocal<@Nullable LSPProgressBar> activeProgress = new ThreadLocal();
    private final Map<String, InterruptibleFuture<?>> activeFutures = new ConcurrentHashMap();

    public RascalLSPMonitor(IBaseLanguageClient languageClient, Logger logger) {
        this(languageClient, logger, "");
    }

    public RascalLSPMonitor(IBaseLanguageClient languageClient, Logger logger, String progressPrefix) {
        this.logger = logger;
        this.languageClient = languageClient;
        this.progressPrefix = progressPrefix;
    }

    public void registerActiveFuture(String name, InterruptibleFuture<? extends @PolyNull Object> future) {
        this.activeFutures.put(RascalLSPMonitor.generateProgressId(name), future);
    }

    public void unregisterActiveFuture(String name) {
        this.activeFutures.remove(RascalLSPMonitor.generateProgressId(name));
    }

    public void jobStart(String name, int workShare, int totalWork) {
        LSPProgressBar progress = this.activeProgress.get();
        if (progress != null) {
            if (progress.rootName.equals(name)) {
                ++progress.nested;
            }
            progress.progress(name);
        } else {
            progress = new LSPProgressBar(name, RascalLSPMonitor.generateProgressId(name));
            this.activeProgress.set(progress);
        }
    }

    private static String generateProgressId(String topLevelName) {
        Thread t = Thread.currentThread();
        return "T" + Integer.toHexString(t.hashCode()) + Long.toHexString(t.getId()) + Integer.toHexString(System.identityHashCode(topLevelName));
    }

    public void jobStep(String name, String message, int workShare) {
        LSPProgressBar progress = this.activeProgress.get();
        if (progress == null) {
            this.logger.warn("Got a job-step while we never started something. Name: {} - Message: {}", (Object)name, (Object)message);
            return;
        }
        progress.progress(message);
    }

    public int jobEnd(String name, boolean succeeded) {
        LSPProgressBar progress = this.activeProgress.get();
        if (progress == null) {
            this.logger.warn("Got a jobEnd while we never started something. Name: {}", (Object)name);
            return 1;
        }
        if (name != null && name.equals(progress.rootName)) {
            if (progress.nested > 0) {
                --progress.nested;
                return 1;
            }
            this.activeProgress.remove();
            progress.finish();
        }
        return 1;
    }

    public void endAllJobs() {
        LSPProgressBar progress = this.activeProgress.get();
        if (progress != null) {
            this.activeProgress.remove();
            progress.finish();
        }
    }

    public void jobTodo(String name, int work) {
    }

    public boolean jobIsCanceled(String name) {
        return false;
    }

    public void warning(String message, ISourceLocation src) {
        this.logger.warn("{} : {}", (Object)src, (Object)message);
    }

    public void cancelProgress(String progressId) {
        InterruptibleFuture<?> future = this.activeFutures.get(progressId);
        if (future != null) {
            future.interrupt();
        }
    }

    private final class LSPProgressBar {
        private final String rootName;
        private final String progressId;
        private final CompletableFuture<Void> created;
        private int nested = 0;

        public LSPProgressBar(String rootName, String progressId) {
            this.rootName = rootName;
            this.progressId = progressId;
            this.created = this.createProgressBar(progressId);
            WorkDoneProgressBegin msg = new WorkDoneProgressBegin();
            msg.setTitle(RascalLSPMonitor.this.progressPrefix + rootName);
            msg.setCancellable(RascalLSPMonitor.this.activeFutures.containsKey(progressId));
            this.notifyProgress(msg);
        }

        private void notifyProgress(WorkDoneProgressNotification value) {
            this.created.thenRun(() -> RascalLSPMonitor.this.languageClient.notifyProgress(new ProgressParams(Either.forLeft(this.progressId), Either.forLeft(value))));
        }

        public void progress(String message) {
            WorkDoneProgressReport msg = new WorkDoneProgressReport();
            msg.setMessage(message);
            msg.setCancellable(RascalLSPMonitor.this.activeFutures.containsKey(this.progressId));
            this.notifyProgress(msg);
        }

        public void finish() {
            this.notifyProgress(new WorkDoneProgressEnd());
        }

        private CompletableFuture<Void> createProgressBar(@UnderInitialization LSPProgressBar this, String id) {
            return ((CompletableFuture)((CompletableFuture)this.tryRegisterProgress(id).thenApply(CompletableFuture::completedFuture)).exceptionally(t -> this.retry((Throwable)t, 0, id))).thenCompose(Function.identity());
        }

        private CompletableFuture<Void> tryRegisterProgress(@UnderInitialization LSPProgressBar this, String id) {
            return RascalLSPMonitor.this.languageClient.createProgress(new WorkDoneProgressCreateParams(Either.forLeft(id)));
        }

        private CompletableFuture<Void> retry(@UnderInitialization LSPProgressBar this, Throwable first, int retry, String id) {
            if (retry >= 100) {
                return CompletableFuture.failedFuture(first);
            }
            return ((CompletableFuture)((CompletableFuture)this.tryRegisterProgress(id).thenApply(CompletableFuture::completedFuture)).exceptionally(t -> {
                first.addSuppressed((Throwable)t);
                return this.retry(first, retry + 1, id);
            })).thenCompose(Function.identity());
        }
    }
}

