/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.library.util.ParseErrorRecovery;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.vscode.lsp.parametric.NoContributions;
import org.rascalmpl.vscode.lsp.util.Diagnostics;
import org.rascalmpl.vscode.lsp.util.Versioned;

public class TextDocumentState {
    private static final Logger logger = LogManager.getLogger(TextDocumentState.class);
    private static final ParseErrorRecovery RECOVERY = new ParseErrorRecovery(IRascalValueFactory.getInstance());
    private final BiFunction<ISourceLocation, String, CompletableFuture<ITree>> parser;
    private final ISourceLocation location;
    private final AtomicReference<Versioned<Update>> current;
    private final AtomicReference<@Nullable Versioned<ITree>> lastWithoutErrors;
    private final AtomicReference<@Nullable Versioned<ITree>> last;

    public TextDocumentState(BiFunction<ISourceLocation, String, CompletableFuture<ITree>> parser, ISourceLocation location, int initialVersion, String initialContent, long initialTimestamp) {
        this.parser = parser;
        this.location = location;
        Update u = new Update(initialVersion, initialContent, initialTimestamp);
        this.current = new AtomicReference<Versioned<Update>>(new Versioned<Update>(initialVersion, u));
        this.lastWithoutErrors = new AtomicReference();
        this.last = new AtomicReference();
    }

    public ISourceLocation getLocation() {
        return this.location;
    }

    public CompletableFuture<Versioned<List<Diagnostics.Template>>> update(int version, String content, long timestamp) {
        Update u = new Update(version, content, timestamp);
        Versioned.replaceIfNewer(this.current, new Versioned<Update>(version, u));
        return u.getDiagnosticsAsync();
    }

    public Versioned<String> getCurrentContent() {
        return this.unpackCurrent().getContent();
    }

    private CompletableFuture<Versioned<ITree>> getCurrentTreeAsync() {
        return this.unpackCurrent().getTreeAsync();
    }

    public CompletableFuture<Versioned<List<Diagnostics.Template>>> getCurrentDiagnosticsAsync() {
        return this.unpackCurrent().getDiagnosticsAsync();
    }

    private Update unpackCurrent() {
        return this.current.get().get();
    }

    public @Nullable Versioned<ITree> getLastTreeWithoutErrors() {
        return this.lastWithoutErrors.get();
    }

    public CompletableFuture<Versioned<ITree>> getCurrentTreeAsync(boolean allowRecoveredErrors) {
        if (allowRecoveredErrors) {
            return this.getCurrentTreeAsync();
        }
        return this.getCurrentTreeAsync().thenApply(t -> {
            Versioned<ITree> withoutErrors = this.lastWithoutErrors.get();
            if (withoutErrors == null || withoutErrors.get() != t.get()) {
                throw new IllegalStateException("File has parse errors");
            }
            return t;
        });
    }

    public CompletableFuture<Versioned<ITree>> getLastTreeAsync(boolean allowRecoveredErrors) {
        CompletionStage result = this.getCurrentTreeAsync().handle((t, e) -> {
            if (t == null) {
                return this.last.get();
            }
            return t;
        });
        if (!allowRecoveredErrors) {
            result = ((CompletableFuture)result).thenApply(t -> this.lastWithoutErrors.get());
        }
        return ((CompletableFuture)result).handle((t, e) -> {
            if (t == null) {
                throw new IllegalStateException("No previous parse tree without errors for: " + String.valueOf(this.getLocation()));
            }
            return t;
        });
    }

    public long getLastModified() {
        return this.unpackCurrent().getTimestamp();
    }

    public TextDocumentState changeParser(BiFunction<ISourceLocation, String, CompletableFuture<ITree>> parsing) {
        Versioned<String> c = this.getCurrentContent();
        return new TextDocumentState(parsing, this.location, c.version(), c.get(), this.getLastModified());
    }

    private final class Update {
        private final int version;
        private final String content;
        private final long timestamp;
        private final CompletableFuture<Versioned<ITree>> treeAsync;
        private final CompletableFuture<Versioned<List<Diagnostics.Template>>> diagnosticsAsync;

        public Update(int version, String content, long timestamp) {
            this.version = version;
            this.content = content;
            this.timestamp = timestamp;
            this.treeAsync = new CompletableFuture();
            this.diagnosticsAsync = new CompletableFuture();
            this.parse();
        }

        public Versioned<String> getContent() {
            return new Versioned<String>(this.version, this.content, this.timestamp);
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public CompletableFuture<Versioned<ITree>> getTreeAsync() {
            return this.treeAsync;
        }

        public CompletableFuture<Versioned<List<Diagnostics.Template>>> getDiagnosticsAsync() {
            return this.diagnosticsAsync;
        }

        private void parse() {
            try {
                TextDocumentState.this.parser.apply(TextDocumentState.this.location, this.content).whenComplete((t, e) -> {
                    if (e instanceof CompletionException && e.getCause() != null) {
                        e = e.getCause();
                    }
                    List<Diagnostics.Template> diagnosticsList = this.toDiagnosticsList((ITree)t, (Throwable)e);
                    if (t == null) {
                        this.treeAsync.completeExceptionally((Throwable)e);
                    } else {
                        Versioned<ITree> tree = new Versioned<ITree>(this.version, (ITree)t, this.timestamp);
                        Versioned.replaceIfNewer(TextDocumentState.this.last, tree);
                        if (diagnosticsList.isEmpty()) {
                            Versioned.replaceIfNewer(TextDocumentState.this.lastWithoutErrors, tree);
                        }
                        this.treeAsync.complete(tree);
                    }
                    Versioned<List<Diagnostics.Template>> diagnostics = new Versioned<List<Diagnostics.Template>>(this.version, diagnosticsList);
                    this.diagnosticsAsync.complete(diagnostics);
                });
            }
            catch (NoContributions.NoContributionException e2) {
                logger.debug("Ignoring missing parser for {}", (Object)TextDocumentState.this.location, (Object)e2);
                this.treeAsync.completeOnTimeout(new Versioned<ITree>(this.version, IRascalValueFactory.getInstance().character(0), this.timestamp), 60L, TimeUnit.SECONDS);
            }
        }

        private List<Diagnostics.Template> toDiagnosticsList(@Nullable ITree tree, @Nullable Throwable excp) {
            ArrayList<Diagnostics.Template> diagnostics = new ArrayList<Diagnostics.Template>();
            if (excp != null) {
                if (excp instanceof CompletionException && excp.getCause() != null) {
                    excp = excp.getCause();
                }
                diagnostics.add(Diagnostics.generateParseErrorDiagnostic(excp));
            }
            if (tree != null) {
                for (IValue error : RECOVERY.findAllParseErrors((IConstructor)tree)) {
                    diagnostics.addAll(Diagnostics.generateParseErrorDiagnostics((ITree)error));
                }
            }
            return diagnostics;
        }
    }
}

