/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.parametric;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.vscode.lsp.parametric.ILanguageContributions;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;

public class LanguageContributionsMultiplexer
implements ILanguageContributions {
    private final ExecutorService exec;
    private final String name;
    private volatile @MonotonicNonNull ILanguageContributions parsing = null;
    private volatile CompletableFuture<ILanguageContributions> analysis = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> build = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> documentSymbol = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> codeLens = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> inlayHint = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> execution = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> hover = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> definition = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> references = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> implementation = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> codeAction = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> prepareRename = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> rename = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> didRenameFiles = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> selectionRange = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> prepareCallHierarchy = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions> incomingOutgoingCalls = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasAnalysis = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasBuild = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasDocumentSymbol = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasCodeLens = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasInlayHint = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasExecution = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasHover = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasDefinition = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasReferences = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasImplementation = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasCodeAction = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasRename = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasDidRenameFiles = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasSelectionRange = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> hasCallHierarchy = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<Boolean> specialCaseHighlighting = LanguageContributionsMultiplexer.failedInitialization();
    private volatile CompletableFuture<ILanguageContributions.SummaryConfig> analyzerSummaryConfig;
    private volatile CompletableFuture<ILanguageContributions.SummaryConfig> builderSummaryConfig;
    private volatile CompletableFuture<ILanguageContributions.SummaryConfig> ondemandSummaryConfig;
    private final CopyOnWriteArrayList<KeyedLanguageContribution> contributions = new CopyOnWriteArrayList();

    private static final <T> CompletableFuture<T> failedInitialization() {
        return CompletableFuture.failedFuture(new RuntimeException("No contributions registered"));
    }

    public LanguageContributionsMultiplexer(String name, ExecutorService ownService) {
        this.name = name;
        this.exec = ownService;
    }

    public void addContributor(String contribKey, ILanguageContributions contrib) {
        KeyedLanguageContribution newEntry = new KeyedLanguageContribution(contribKey, contrib);
        this.contributions.remove(newEntry);
        this.contributions.addIfAbsent(newEntry);
        this.calculateRouting();
    }

    public boolean removeContributor(String contribKey) {
        this.contributions.removeIf(e -> e.key.equals(contribKey) || e.key.equals(contribKey + "$parser"));
        if (this.contributions.isEmpty()) {
            return false;
        }
        this.calculateRouting();
        return true;
    }

    private synchronized void calculateRouting() {
        this.parsing = this.firstOrFail();
        this.analysis = this.findFirstOrDefault(ILanguageContributions::hasAnalysis);
        this.build = this.findFirstOrDefault(ILanguageContributions::hasBuild);
        this.documentSymbol = this.findFirstOrDefault(ILanguageContributions::hasDocumentSymbol);
        this.codeLens = this.findFirstOrDefault(ILanguageContributions::hasCodeLens);
        this.inlayHint = this.findFirstOrDefault(ILanguageContributions::hasInlayHint);
        this.execution = this.findFirstOrDefault(ILanguageContributions::hasExecution);
        this.hover = this.findFirstOrDefault(ILanguageContributions::hasHover);
        this.definition = this.findFirstOrDefault(ILanguageContributions::hasDefinition);
        this.references = this.findFirstOrDefault(ILanguageContributions::hasReferences);
        this.implementation = this.findFirstOrDefault(ILanguageContributions::hasImplementation);
        this.codeAction = this.findFirstOrDefault(ILanguageContributions::hasCodeAction);
        this.rename = this.findFirstOrDefault(ILanguageContributions::hasRename);
        this.prepareRename = this.findFirstOrDefault(ILanguageContributions::hasRename);
        this.didRenameFiles = this.findFirstOrDefault(ILanguageContributions::hasDidRenameFiles);
        this.selectionRange = this.findFirstOrDefault(ILanguageContributions::hasSelectionRange);
        this.prepareCallHierarchy = this.findFirstOrDefault(ILanguageContributions::hasCallHierarchy);
        this.incomingOutgoingCalls = this.findFirstOrDefault(ILanguageContributions::hasCallHierarchy);
        this.hasAnalysis = this.anyTrue(ILanguageContributions::hasAnalysis);
        this.hasBuild = this.anyTrue(ILanguageContributions::hasBuild);
        this.hasDocumentSymbol = this.anyTrue(ILanguageContributions::hasDocumentSymbol);
        this.hasCodeLens = this.anyTrue(ILanguageContributions::hasCodeLens);
        this.hasInlayHint = this.anyTrue(ILanguageContributions::hasInlayHint);
        this.hasExecution = this.anyTrue(ILanguageContributions::hasExecution);
        this.hasHover = this.anyTrue(ILanguageContributions::hasHover);
        this.hasDefinition = this.anyTrue(ILanguageContributions::hasDefinition);
        this.hasReferences = this.anyTrue(ILanguageContributions::hasReferences);
        this.hasImplementation = this.anyTrue(ILanguageContributions::hasImplementation);
        this.hasCodeAction = this.anyTrue(ILanguageContributions::hasCodeAction);
        this.hasRename = this.anyTrue(ILanguageContributions::hasRename);
        this.hasDidRenameFiles = this.anyTrue(ILanguageContributions::hasDidRenameFiles);
        this.hasSelectionRange = this.anyTrue(ILanguageContributions::hasSelectionRange);
        this.hasCallHierarchy = this.anyTrue(ILanguageContributions::hasCallHierarchy);
        this.specialCaseHighlighting = this.firstOrFail().specialCaseHighlighting();
        this.analyzerSummaryConfig = this.anyTrue(ILanguageContributions::getAnalyzerSummaryConfig, ILanguageContributions.SummaryConfig.FALSY, ILanguageContributions.SummaryConfig::or);
        this.builderSummaryConfig = this.anyTrue(ILanguageContributions::getBuilderSummaryConfig, ILanguageContributions.SummaryConfig.FALSY, ILanguageContributions.SummaryConfig::or);
        this.ondemandSummaryConfig = this.anyTrue(ILanguageContributions::getOndemandSummaryConfig, ILanguageContributions.SummaryConfig.FALSY, ILanguageContributions.SummaryConfig::or);
    }

    private ILanguageContributions firstOrFail() {
        Iterator<KeyedLanguageContribution> it = this.contributions.iterator();
        if (!it.hasNext()) {
            throw new RuntimeException("No more language contributions registered for " + this.name);
        }
        return it.next().contrib;
    }

    private CompletableFuture<ILanguageContributions> findFirstOrDefault(Function<ILanguageContributions, CompletableFuture<Boolean>> filter) {
        return CompletableFuture.supplyAsync(() -> {
            for (KeyedLanguageContribution c : this.contributions) {
                try {
                    if (!((Boolean)((CompletableFuture)filter.apply(c.contrib)).get()).booleanValue()) continue;
                    return c.contrib;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception ignored) {
                }
            }
            return this.firstOrFail();
        }, this.exec);
    }

    private CompletableFuture<Boolean> anyTrue(Function<ILanguageContributions, CompletableFuture<Boolean>> predicate) {
        return this.anyTrue(predicate, false, Boolean::logicalOr);
    }

    private <T> CompletableFuture<T> anyTrue(Function<ILanguageContributions, CompletableFuture<T>> predicate, T falsy, BinaryOperator<T> or) {
        CompletionStage<T> result = CompletableFutureUtils.completedFuture(falsy, this.exec);
        for (KeyedLanguageContribution c : this.contributions) {
            CompletionStage checkCurrent = predicate.apply(c.contrib).exceptionally(e -> falsy);
            result = result.thenCombine(checkCurrent, or);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CompletableFuture<ITree> parsing(ISourceLocation loc, String input) {
        ILanguageContributions p = this.parsing;
        if (p == null) {
            return LanguageContributionsMultiplexer.failedInitialization();
        }
        return p.parsing(loc, input);
    }

    private <T> InterruptibleFuture<T> flatten(CompletableFuture<ILanguageContributions> target, Function<ILanguageContributions, InterruptibleFuture<T>> call) {
        return InterruptibleFuture.flatten(target.thenApply(call), this.exec);
    }

    @Override
    public InterruptibleFuture<IList> documentSymbol(ITree input) {
        return this.flatten(this.documentSymbol, c -> c.documentSymbol(input));
    }

    @Override
    public InterruptibleFuture<IConstructor> analysis(ISourceLocation loc, ITree input) {
        return this.flatten(this.analysis, c -> c.analysis(loc, input));
    }

    @Override
    public InterruptibleFuture<IConstructor> build(ISourceLocation loc, ITree input) {
        return this.flatten(this.build, c -> c.build(loc, input));
    }

    @Override
    public InterruptibleFuture<IList> codeLens(ITree input) {
        return this.flatten(this.codeLens, c -> c.codeLens(input));
    }

    @Override
    public InterruptibleFuture<IValue> execution(String command) {
        return this.flatten(this.execution, c -> c.execution(command));
    }

    @Override
    public CompletableFuture<IList> parseCodeActions(String command) {
        return ((CompletableFuture)this.execution.thenApply(c -> c.parseCodeActions(command))).thenCompose(Function.identity());
    }

    @Override
    public CompletableFuture<IConstructor> parseCallHierarchyData(String data) {
        return ((CompletableFuture)this.incomingOutgoingCalls.thenApply(c -> c.parseCallHierarchyData(data))).thenCompose(Function.identity());
    }

    @Override
    public InterruptibleFuture<IList> inlayHint(ITree input) {
        return this.flatten(this.inlayHint, c -> c.inlayHint(input));
    }

    @Override
    public InterruptibleFuture<ISourceLocation> prepareRename(IList focus) {
        return this.flatten(this.prepareRename, c -> c.prepareRename(focus));
    }

    @Override
    public InterruptibleFuture<ITuple> rename(IList focus, String name) {
        return this.flatten(this.rename, c -> c.rename(focus, name));
    }

    @Override
    public InterruptibleFuture<ITuple> didRenameFiles(IList oldToNew) {
        return this.flatten(this.didRenameFiles, c -> c.didRenameFiles(oldToNew));
    }

    @Override
    public InterruptibleFuture<ISet> hover(IList focus) {
        return this.flatten(this.hover, c -> c.hover(focus));
    }

    @Override
    public InterruptibleFuture<ISet> definition(IList focus) {
        return this.flatten(this.definition, c -> c.definition(focus));
    }

    @Override
    public InterruptibleFuture<ISet> references(IList focus) {
        return this.flatten(this.references, c -> c.references(focus));
    }

    @Override
    public InterruptibleFuture<ISet> implementation(IList focus) {
        return this.flatten(this.implementation, c -> c.implementation(focus));
    }

    @Override
    public InterruptibleFuture<IList> codeAction(IList focus) {
        return this.flatten(this.codeAction, c -> c.codeAction(focus));
    }

    @Override
    public CompletableFuture<Boolean> hasSelectionRange() {
        return this.hasSelectionRange;
    }

    @Override
    public InterruptibleFuture<IList> selectionRange(IList focus) {
        return this.flatten(this.selectionRange, c -> c.selectionRange(focus));
    }

    @Override
    public InterruptibleFuture<IList> prepareCallHierarchy(IList focus) {
        return this.flatten(this.prepareCallHierarchy, c -> c.prepareCallHierarchy(focus));
    }

    @Override
    public InterruptibleFuture<IList> incomingOutgoingCalls(IConstructor hierarchyItem, IConstructor direction) {
        return this.flatten(this.incomingOutgoingCalls, c -> c.incomingOutgoingCalls(hierarchyItem, direction));
    }

    @Override
    public CompletableFuture<Boolean> hasCodeAction() {
        return this.hasCodeAction;
    }

    @Override
    public CompletableFuture<Boolean> hasHover() {
        return this.hasHover;
    }

    @Override
    public CompletableFuture<Boolean> hasDefinition() {
        return this.hasDefinition;
    }

    @Override
    public CompletableFuture<Boolean> hasReferences() {
        return this.hasReferences;
    }

    @Override
    public CompletableFuture<Boolean> hasImplementation() {
        return this.hasImplementation;
    }

    @Override
    public CompletableFuture<Boolean> hasDocumentSymbol() {
        return this.hasDocumentSymbol;
    }

    @Override
    public CompletableFuture<Boolean> hasAnalysis() {
        return this.hasAnalysis;
    }

    @Override
    public CompletableFuture<Boolean> hasBuild() {
        return this.hasBuild;
    }

    @Override
    public CompletableFuture<Boolean> hasCodeLens() {
        return this.hasCodeLens;
    }

    @Override
    public CompletableFuture<Boolean> hasExecution() {
        return this.hasExecution;
    }

    @Override
    public CompletableFuture<Boolean> hasInlayHint() {
        return this.hasInlayHint;
    }

    @Override
    public CompletableFuture<Boolean> hasRename() {
        return this.hasRename;
    }

    @Override
    public CompletableFuture<Boolean> hasDidRenameFiles() {
        return this.hasDidRenameFiles;
    }

    @Override
    public CompletableFuture<Boolean> hasCallHierarchy() {
        return this.hasCallHierarchy;
    }

    @Override
    public CompletableFuture<Boolean> specialCaseHighlighting() {
        return this.specialCaseHighlighting;
    }

    @Override
    public CompletableFuture<ILanguageContributions.SummaryConfig> getAnalyzerSummaryConfig() {
        return this.analyzerSummaryConfig;
    }

    @Override
    public CompletableFuture<ILanguageContributions.SummaryConfig> getBuilderSummaryConfig() {
        return this.builderSummaryConfig;
    }

    @Override
    public CompletableFuture<ILanguageContributions.SummaryConfig> getOndemandSummaryConfig() {
        return this.ondemandSummaryConfig;
    }

    @Override
    public void cancelProgress(String progressId) {
        this.contributions.forEach(klc -> klc.contrib.cancelProgress(progressId));
    }

    private static final class KeyedLanguageContribution {
        public final String key;
        public final ILanguageContributions contrib;

        public KeyedLanguageContribution(String key, ILanguageContributions contrib) {
            this.key = key;
            this.contrib = contrib;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof KeyedLanguageContribution) {
                return this.key.equals(((KeyedLanguageContribution)obj).key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

