/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.parametric;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.TypeFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.rascalmpl.values.IRascalValueFactory;

public interface LanguageRegistry {
    @JsonRequest(value="rascal/receiveRegisterLanguage")
    public CompletableFuture<Void> registerLanguage(LanguageParameter var1);

    @JsonRequest(value="rascal/receiveUnregisterLanguage")
    public CompletableFuture<Void> unregisterLanguage(LanguageParameter var1);

    public static class ParserSpecification {
        private final String parserLocation;
        private final String nonTerminalName;
        private final @Nullable Boolean nonTerminalIsStart;
        private final @Nullable Boolean allowAmbiguity;
        private final @Nullable Integer maxAmbDepth;
        private final @Nullable Boolean allowRecovery;
        private final @Nullable Integer maxRecoveryAttempts;
        private final @Nullable Integer maxRecoveryTokens;
        private final @Nullable Boolean specialCaseHighlighting;

        public ParserSpecification(String parserLocation, String nonTerminalName, @Nullable Boolean nonTerminalIsStart, @Nullable Boolean allowAmbiguity, @Nullable Integer maxAmbDepth, @Nullable Boolean allowRecovery, @Nullable Integer maxRecoveryAttempts, @Nullable Integer maxRecoveryTokens, @Nullable Boolean specialCaseHighlighting) {
            this.parserLocation = parserLocation;
            this.nonTerminalName = nonTerminalName;
            this.nonTerminalIsStart = nonTerminalIsStart;
            this.allowAmbiguity = allowAmbiguity;
            this.maxAmbDepth = maxAmbDepth;
            this.allowRecovery = allowRecovery;
            this.maxRecoveryAttempts = maxRecoveryAttempts;
            this.maxRecoveryTokens = maxRecoveryTokens;
            this.specialCaseHighlighting = specialCaseHighlighting;
        }

        public ISourceLocation getParserLocation() throws FactTypeUseException {
            return ParserSpecification.buildLocation(this.parserLocation);
        }

        public String getNonTerminalName() {
            return this.nonTerminalName;
        }

        public boolean getNonTerminalIsStart() {
            return this.nonTerminalIsStart == null || this.nonTerminalIsStart != false;
        }

        public boolean getAllowAmbiguity() {
            return this.allowAmbiguity != null && this.allowAmbiguity != false;
        }

        public int getMaxAmbDepth() {
            return this.maxAmbDepth != null ? this.maxAmbDepth : 2;
        }

        public boolean getAllowRecovery() {
            return this.allowRecovery != null && this.allowRecovery != false;
        }

        public int getMaxRecoveryAttempts() {
            return this.maxRecoveryAttempts != null ? this.maxRecoveryAttempts : 50;
        }

        public int getMaxRecoveryTokens() {
            return this.maxRecoveryTokens != null ? this.maxRecoveryTokens : 3;
        }

        public boolean getSpecialCaseHighlighting() {
            return this.specialCaseHighlighting == null || this.specialCaseHighlighting != false;
        }

        public String toString() {
            return "ParserSpecification [parserLocation=" + this.parserLocation + ", nonTerminalName=" + this.nonTerminalName + ", nonTerminalIsStart=" + this.nonTerminalIsStart + ", allowAmbiguity=" + this.allowAmbiguity + "]";
        }

        private static ISourceLocation buildLocation(String location) throws FactTypeUseException {
            try {
                return (ISourceLocation)new StandardTextReader().read((IValueFactory)IRascalValueFactory.getInstance(), TypeFactory.getInstance().sourceLocationType(), (Reader)new StringReader(location));
            }
            catch (IOException e) {
                throw new RuntimeException("this should never happen:", e);
            }
        }
    }

    public static class LanguageParameter {
        private final String pathConfig;
        private final String name;
        private final String[] extensions;
        private final String mainModule;
        private final String mainFunction;
        private final @Nullable ParserSpecification precompiledParser;

        public LanguageParameter(String pathConfig, String name, String[] extensions, String mainModule, String mainFunction, @Nullable ParserSpecification precompiledParser) {
            this.pathConfig = pathConfig;
            this.name = name;
            this.extensions = extensions;
            this.mainModule = mainModule;
            this.mainFunction = mainFunction;
            this.precompiledParser = precompiledParser;
        }

        public String getPathConfig() {
            return this.pathConfig;
        }

        public String getName() {
            return this.name;
        }

        public String[] getExtensions() {
            return this.extensions;
        }

        public String getMainFunction() {
            return this.mainFunction;
        }

        public String getMainModule() {
            return this.mainModule;
        }

        public @Nullable ParserSpecification getPrecompiledParser() {
            return this.precompiledParser;
        }

        public String toString() {
            return "LanguageParameter(pathConfig=" + this.pathConfig + ", name=" + this.name + ", extensions=" + Arrays.toString(this.extensions) + ", mainModule=" + this.mainModule + ", mainFunction=" + this.mainFunction + ", precompiledParser=" + String.valueOf(this.precompiledParser) + ")";
        }

        public static LanguageParameter fromRascalValue(IConstructor language) {
            return new LanguageParameter(language.get(0).toString(), LanguageParameter.getString(language, 1), LanguageParameter.getArray(language, 2), LanguageParameter.getString(language, 3), LanguageParameter.getString(language, 4), null);
        }

        private static String[] getArray(IConstructor language, int position) {
            return (String[])((ISet)language.get(position)).stream().map(v -> ((IString)v).getValue()).toArray(String[]::new);
        }

        private static String getString(IConstructor language, int position) {
            return ((IString)language.get(position)).getValue();
        }
    }
}

