/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.parametric;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.NullRascalMonitor;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalFunctionValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.vscode.lsp.parametric.LanguageRegistry;
import org.rascalmpl.vscode.lsp.parametric.NoContributions;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;

public class ParserOnlyContribution
extends NoContributions {
    private static final Logger logger = LogManager.getLogger(ParserOnlyContribution.class);
    private static final IValueFactory VF = IRascalValueFactory.getInstance();
    private final @Nullable Exception loadingParserError;
    private final @Nullable IFunction parser;
    private final CompletableFuture<Boolean> specialCaseHighlighting;
    private final ExecutorService exec;

    public ParserOnlyContribution(String name, LanguageRegistry.ParserSpecification spec, ExecutorService exec) {
        super(name, exec);
        this.exec = exec;
        Either<IFunction, Exception> result = ParserOnlyContribution.loadParser(spec);
        this.parser = result.getLeft();
        this.loadingParserError = result.getRight();
        this.specialCaseHighlighting = CompletableFutureUtils.completedFuture(spec.getSpecialCaseHighlighting(), exec);
    }

    @Override
    public CompletableFuture<ITree> parsing(ISourceLocation loc, String input) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.loadingParserError != null || this.parser == null) {
                throw new IllegalStateException("Parser function did not load", this.loadingParserError);
            }
            return (ITree)this.parser.call(new IValue[]{VF.string(input), loc});
        }, this.exec);
    }

    private static Either<IFunction, Exception> loadParser(LanguageRegistry.ParserSpecification spec) {
        Evaluator unusedEvaluator = ShellEvaluatorFactory.getBasicEvaluator((Reader)Reader.nullReader(), (PrintWriter)new PrintWriter(Writer.nullWriter()), (PrintWriter)new PrintWriter(Writer.nullWriter()), (IRascalMonitor)new NullRascalMonitor(), (String)"***unused***");
        RascalFunctionValueFactory vf = new RascalFunctionValueFactory((IEvaluatorContext)unusedEvaluator);
        IConstructor reifiedType = ParserOnlyContribution.makeReifiedType(spec, (IRascalValueFactory)vf);
        try {
            logger.debug("Loading parser {} at {}", (Object)reifiedType, (Object)spec.getParserLocation());
            IFunction parser = vf.loadParser((IValue)reifiedType, spec.getParserLocation(), VF.bool(spec.getAllowAmbiguity()), VF.integer(spec.getMaxAmbDepth()), VF.bool(spec.getAllowRecovery()), VF.integer(spec.getMaxRecoveryAttempts()), VF.integer(spec.getMaxRecoveryTokens()), VF.bool(false), VF.bool(false), vf.set(new IValue[0]));
            logger.debug("Got parser: {}", (Object)parser);
            return Either.forLeft(parser);
        }
        catch (FactTypeUseException | IOException | ClassNotFoundException e) {
            logger.catching(e);
            return Either.forRight(e);
        }
    }

    private static IConstructor makeReifiedType(LanguageRegistry.ParserSpecification spec, IRascalValueFactory vf) {
        String nt = spec.getNonTerminalName();
        IConstructor symbol = vf.constructor(RascalValueFactory.Symbol_Sort, new IValue[]{VF.string(nt)});
        symbol = spec.getNonTerminalIsStart() ? vf.constructor(RascalValueFactory.Symbol_Start, new IValue[]{symbol}) : symbol;
        return vf.reifiedType(symbol, vf.map());
    }

    @Override
    public CompletableFuture<Boolean> specialCaseHighlighting() {
        return this.specialCaseHighlighting;
    }
}

