/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.parametric.model;

import io.usethesource.vallang.ISourceLocation;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.vscode.lsp.parametric.ILanguageContributions;
import org.rascalmpl.vscode.lsp.parametric.model.NullSummary;
import org.rascalmpl.vscode.lsp.parametric.model.OndemandSummaryFactory;
import org.rascalmpl.vscode.lsp.parametric.model.ParametricSummary;
import org.rascalmpl.vscode.lsp.parametric.model.ScheduledSummaryFactory;
import org.rascalmpl.vscode.lsp.util.Lists;
import org.rascalmpl.vscode.lsp.util.Versioned;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class ParametricFileFacts {
    private static final Logger logger = LogManager.getLogger(ParametricFileFacts.class);
    private final Executor exec;
    private final ColumnMaps columns;
    private final ILanguageContributions contrib;
    private final ParametricSummary nullSummary;
    private final Map<ISourceLocation, FileFact> files = new ConcurrentHashMap<ISourceLocation, FileFact>();
    private volatile @MonotonicNonNull LanguageClient client;
    private volatile CompletableFuture<ScheduledSummaryFactory> analyzerSummaryFactory;
    private volatile CompletableFuture<ScheduledSummaryFactory> builderSummaryFactory;
    private volatile CompletableFuture<OndemandSummaryFactory> ondemandSummaryFactory;

    public ParametricFileFacts(Executor exec, ColumnMaps columns, ILanguageContributions contrib) {
        this.exec = exec;
        this.columns = columns;
        this.contrib = contrib;
        this.nullSummary = new NullSummary(exec);
    }

    public void setClient(LanguageClient client) {
        this.client = client;
    }

    public void reportParseErrors(ISourceLocation file, int version, List<Diagnostic> msgs) {
        this.getFile(file).reportParseErrors(version, msgs);
    }

    private FileFact getFile(ISourceLocation file) {
        FileFact fact = this.files.get(file);
        if (fact == null) {
            if (URIResolverRegistry.getInstance().exists(file)) {
                fact = new ActualFileFact(file);
                FileFact existing = this.files.putIfAbsent(file, fact);
                if (existing != null) {
                    fact = existing;
                }
            } else {
                fact = new NopFileFact();
            }
        }
        return fact;
    }

    public void reloadContributions() {
        this.analyzerSummaryFactory = this.contrib.getAnalyzerSummaryConfig().thenApply(config -> new ScheduledSummaryFactory((ILanguageContributions.SummaryConfig)config, this.exec, this.columns, this.contrib::analysis));
        this.builderSummaryFactory = this.contrib.getBuilderSummaryConfig().thenApply(config -> new ScheduledSummaryFactory((ILanguageContributions.SummaryConfig)config, this.exec, this.columns, this.contrib::build));
        this.ondemandSummaryFactory = this.contrib.getOndemandSummaryConfig().thenApply(config -> new OndemandSummaryFactory((ILanguageContributions.SummaryConfig)config, this.exec, this.columns, this.contrib));
    }

    public void invalidateAnalyzer(ISourceLocation file) {
        this.getFile(file).invalidateAnalyzer(false);
    }

    public void invalidateBuilder(ISourceLocation file) {
        this.getFile(file).invalidateBuilder(false);
    }

    public void calculateAnalyzer(ISourceLocation file, CompletableFuture<Versioned<ITree>> tree, int version, Duration delay) {
        this.getFile(file).calculateAnalyzer(tree, version, delay);
    }

    public void calculateBuilder(ISourceLocation file, CompletableFuture<Versioned<ITree>> tree) {
        this.getFile(file).calculateBuilder(tree);
    }

    public <T> CompletableFuture<List<T>> lookupInSummaries(ParametricSummary.SummaryLookup<T> lookup, ISourceLocation file, Versioned<ITree> tree, Position cursor) {
        return this.getFile(file).lookupInSummaries(lookup, tree, cursor);
    }

    public void close(ISourceLocation file) {
        this.getFile(file).close();
    }

    class NopFileFact
    implements FileFact {
        NopFileFact() {
        }

        @Override
        public void invalidateAnalyzer(boolean isClosing) {
        }

        @Override
        public void invalidateBuilder(boolean isClosing) {
        }

        @Override
        public void close() {
        }

        @Override
        public void calculateAnalyzer(CompletableFuture<Versioned<ITree>> tree, int version, Duration delay) {
        }

        @Override
        public void calculateBuilder(CompletableFuture<Versioned<ITree>> tree) {
        }

        @Override
        public void reportParseErrors(int version, List<Diagnostic> messages) {
        }

        @Override
        public void clearDiagnostics() {
        }

        @Override
        public <T> CompletableFuture<List<T>> lookupInSummaries(ParametricSummary.SummaryLookup<T> lookup, Versioned<ITree> tree, Position cursor) {
            return CompletableFuture.completedFuture(List.of());
        }
    }

    private class ActualFileFact
    implements FileFact {
        private final ISourceLocation file;
        private final AtomicReference<Versioned<List<Diagnostic>>> parserDiagnostics = Versioned.atomic(-1, Collections.emptyList());
        private final AtomicReference<Versioned<List<Diagnostic>>> analyzerDiagnostics = Versioned.atomic(-1, Collections.emptyList());
        private final AtomicReference<Versioned<List<Diagnostic>>> builderDiagnostics = Versioned.atomic(-1, Collections.emptyList());
        private final AtomicInteger latestVersionCalculateAnalyzer = new AtomicInteger(-1);
        private volatile CompletableFuture<Versioned<ParametricSummary>> latestAnalyzerAnalysis;
        private volatile CompletableFuture<Versioned<ParametricSummary>> latestBuilderBuild;
        private volatile CompletableFuture<Versioned<ParametricSummary>> latestBuilderAnalysis;

        public ActualFileFact(ISourceLocation file) {
            this.latestAnalyzerAnalysis = CompletableFutureUtils.completedFuture(new Versioned<ParametricSummary>(-1, ParametricFileFacts.this.nullSummary), ParametricFileFacts.this.exec);
            this.latestBuilderBuild = CompletableFutureUtils.completedFuture(new Versioned<ParametricSummary>(-1, ParametricFileFacts.this.nullSummary), ParametricFileFacts.this.exec);
            this.latestBuilderAnalysis = CompletableFutureUtils.completedFuture(new Versioned<ParametricSummary>(-1, ParametricFileFacts.this.nullSummary), ParametricFileFacts.this.exec);
            this.file = file;
        }

        private <T> void reportDiagnostics(AtomicReference<Versioned<T>> current, int version, T messages) {
            Versioned<T> maybeNewer = new Versioned<T>(version, messages);
            if (Versioned.replaceIfNewer(current, maybeNewer)) {
                this.sendDiagnostics();
            }
        }

        @Override
        public void invalidateAnalyzer(boolean isClosing) {
            this.invalidate(this.latestAnalyzerAnalysis, isClosing);
        }

        @Override
        public void invalidateBuilder(boolean isClosing) {
            this.invalidate(this.latestBuilderAnalysis, isClosing);
            this.invalidate(this.latestBuilderBuild, isClosing);
        }

        private void invalidate(@Nullable CompletableFuture<Versioned<ParametricSummary>> summary, boolean isClosing) {
            if (summary != null && !isClosing) {
                ((CompletableFuture)summary.thenApply(Versioned::get)).thenAccept(ParametricSummary::invalidate);
            }
        }

        @Override
        public void close() {
            this.invalidateAnalyzer(true);
            this.invalidateBuilder(true);
            CompletableFuture<List<Diagnostic>> analyzerMessages = ParametricSummary.getMessages(this.latestAnalyzerAnalysis, ParametricFileFacts.this.exec).get();
            CompletableFuture<List<Diagnostic>> builderMessages = ParametricSummary.getMessages(this.latestBuilderBuild, ParametricFileFacts.this.exec).get();
            analyzerMessages.thenAcceptBothAsync(builderMessages, (aMessages, bMessages) -> {
                if (aMessages.isEmpty() && bMessages.isEmpty() || !URIResolverRegistry.getInstance().exists(this.file)) {
                    this.remove(this.file);
                }
            });
        }

        private @Nullable FileFact remove(ISourceLocation file) {
            FileFact removed = ParametricFileFacts.this.files.remove(file.top());
            if (removed != null) {
                removed.clearDiagnostics();
            }
            return removed;
        }

        private CompletableFuture<Versioned<ParametricSummary>> debounce(int version, AtomicInteger latestVersion, Duration delay, Supplier<CompletableFuture<Versioned<ParametricSummary>>> calculation) {
            latestVersion.set(version);
            Executor delayed = CompletableFuture.delayedExecutor(delay.toMillis(), TimeUnit.MILLISECONDS, ParametricFileFacts.this.exec);
            CompletableFuture<CompletableFuture> summary = CompletableFuture.supplyAsync(() -> {
                if (latestVersion.get() == version) {
                    return (CompletableFuture)calculation.get();
                }
                return CompletableFutureUtils.completedFuture(new Versioned<ParametricSummary>(version, ParametricFileFacts.this.nullSummary), ParametricFileFacts.this.exec);
            }, delayed);
            return summary.thenCompose(Function.identity());
        }

        @Override
        public void calculateAnalyzer(CompletableFuture<Versioned<ITree>> tree, int version, Duration delay) {
            this.latestAnalyzerAnalysis = this.debounce(version, this.latestVersionCalculateAnalyzer, delay, () -> {
                CompletionStage summary = ((CompletableFuture)ParametricFileFacts.this.analyzerSummaryFactory.thenApply(f -> f.createFullSummary(this.file, tree))).thenCompose(Function.identity());
                ParametricSummary.getMessages((CompletableFuture<Versioned<ParametricSummary>>)summary, ParametricFileFacts.this.exec).thenAcceptIfUninterrupted(ms -> this.reportDiagnostics(this.analyzerDiagnostics, version, ms));
                return summary;
            });
        }

        @Override
        public void calculateBuilder(CompletableFuture<Versioned<ITree>> tree) {
            this.latestBuilderAnalysis = ((CompletableFuture)ParametricFileFacts.this.analyzerSummaryFactory.thenApply(f -> f.createMessagesOnlySummary(this.file, tree))).thenCompose(Function.identity());
            this.latestBuilderBuild = ((CompletableFuture)ParametricFileFacts.this.builderSummaryFactory.thenApply(f -> f.createFullSummary(this.file, tree))).thenCompose(Function.identity());
            InterruptibleFuture<List<Diagnostic>> analyzerMessages = ParametricSummary.getMessages(this.latestBuilderAnalysis, ParametricFileFacts.this.exec);
            InterruptibleFuture<List<Diagnostic>> builderMessages = ParametricSummary.getMessages(this.latestBuilderBuild, ParametricFileFacts.this.exec);
            analyzerMessages.thenAcceptBothIfUninterrupted(builderMessages, (aMessages, bMessages) -> {
                bMessages.removeAll((Collection<?>)aMessages);
                tree.thenAccept(t -> this.reportDiagnostics(this.builderDiagnostics, t.version(), bMessages));
            });
        }

        @Override
        public void reportParseErrors(int version, List<Diagnostic> messages) {
            this.reportDiagnostics(this.parserDiagnostics, version, messages);
        }

        @Override
        public void clearDiagnostics() {
            Versioned emptyDiagnostics = new Versioned(this.latestVersionCalculateAnalyzer.get(), Collections.emptyList());
            this.parserDiagnostics.set(emptyDiagnostics);
            this.analyzerDiagnostics.set(emptyDiagnostics);
            this.builderDiagnostics.set(emptyDiagnostics);
            if (ParametricFileFacts.this.client != null) {
                ParametricFileFacts.this.client.publishDiagnostics(new PublishDiagnosticsParams(Locations.toUri(this.file).toString(), Collections.emptyList()));
            }
        }

        private void sendDiagnostics() {
            if (ParametricFileFacts.this.client == null) {
                logger.debug("Cannot send diagnostics since the client hasn't been registered yet");
                return;
            }
            Versioned<List<Diagnostic>> fromParser = this.parserDiagnostics.get();
            Versioned<List<Diagnostic>> fromAnalyzer = this.analyzerDiagnostics.get();
            Versioned<List<Diagnostic>> fromBuilder = this.builderDiagnostics.get();
            List<Diagnostic> diagnostics = Lists.union(fromParser.get(), fromAnalyzer.get(), fromBuilder.get());
            logger.trace("Sending {} diagnostic(s) for {} (parser: v{}; analyzer: v{}; builder: v{})", (Object)diagnostics.size(), (Object)this.file, (Object)fromParser.version(), (Object)fromAnalyzer.version(), (Object)fromBuilder.version());
            ParametricFileFacts.this.client.publishDiagnostics(new PublishDiagnosticsParams(Locations.toUri(this.file).toString(), diagnostics));
        }

        @Override
        public <T> CompletableFuture<List<T>> lookupInSummaries(ParametricSummary.SummaryLookup<T> lookup, Versioned<ITree> tree, Position cursor) {
            return ((CompletableFuture)this.latestAnalyzerAnalysis.thenCombine(this.latestBuilderBuild, (a, b) -> this.lookupInSummaries(lookup, tree, cursor, (Versioned<ParametricSummary>)a, (Versioned<ParametricSummary>)b))).thenCompose(Function.identity());
        }

        private <T> CompletableFuture<List<T>> lookupInSummaries(ParametricSummary.SummaryLookup<T> lookup, Versioned<ITree> tree, Position cursor, Versioned<ParametricSummary> analyzerSummary, Versioned<ParametricSummary> builderSummary) {
            InterruptibleFuture result;
            if (builderSummary.version() == tree.version() && (result = (InterruptibleFuture)lookup.apply(builderSummary.get(), cursor)) != null) {
                logger.trace("Look-up in builder summary succeeded");
                return result.get();
            }
            if (analyzerSummary.version() == tree.version() && (result = (InterruptibleFuture)lookup.apply(analyzerSummary.get(), cursor)) != null) {
                logger.trace("Look-up in analyzer summary succeeded");
                return result.get();
            }
            return ParametricFileFacts.this.ondemandSummaryFactory.thenCompose(f -> {
                InterruptibleFuture result = f.createSummaryThenLookup(this.file, tree, cursor, lookup);
                if (result != null) {
                    logger.trace("Look-up in on-demand summary succeeded");
                    return result.get();
                }
                logger.trace("Look-up failed");
                return CompletableFutureUtils.completedFuture(Collections.emptyList(), ParametricFileFacts.this.exec);
            });
        }
    }

    private static interface FileFact {
        public void invalidateAnalyzer(boolean var1);

        public void invalidateBuilder(boolean var1);

        public void close();

        public void calculateAnalyzer(CompletableFuture<Versioned<ITree>> var1, int var2, Duration var3);

        public void calculateBuilder(CompletableFuture<Versioned<ITree>> var1);

        public void reportParseErrors(int var1, List<Diagnostic> var2);

        public void clearDiagnostics();

        public <T> CompletableFuture<List<T>> lookupInSummaries(ParametricSummary.SummaryLookup<T> var1, Versioned<ITree> var2, Position var3);
    }
}

