/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.rascal;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.staticErrors.SyntaxError;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;
import org.rascalmpl.vscode.lsp.BaseWorkspaceService;
import org.rascalmpl.vscode.lsp.IBaseLanguageClient;
import org.rascalmpl.vscode.lsp.RascalLSPMonitor;
import org.rascalmpl.vscode.lsp.rascal.RascalTextDocumentService;
import org.rascalmpl.vscode.lsp.util.EvaluatorUtil;
import org.rascalmpl.vscode.lsp.util.RascalServices;
import org.rascalmpl.vscode.lsp.util.Versioned;
import org.rascalmpl.vscode.lsp.util.concurrent.InterruptibleFuture;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class RascalLanguageServices {
    private static final IValueFactory VF = IRascalValueFactory.getInstance();
    private static final Logger logger = LogManager.getLogger(RascalLanguageServices.class);
    private final CompletableFuture<Evaluator> shortRunningTaskEvaluator;
    private final CompletableFuture<Evaluator> semanticEvaluator;
    private final CompletableFuture<Evaluator> compilerEvaluator;
    private final CompletableFuture<TypeStore> actionStore;
    private final TypeFactory tf = TypeFactory.getInstance();
    private final TypeStore store = new TypeStore(new TypeStore[0]);
    private final Type getPathConfigType = this.tf.functionType(this.tf.abstractDataType(this.store, "PathConfig", new Type[0]), this.tf.tupleType(new Type[]{this.tf.sourceLocationType()}), this.tf.tupleEmpty());
    private final IConstructor startModuleConstructor = VF.constructor(RascalValueFactory.Symbol_Start, new IValue[]{VF.constructor(RascalValueFactory.Symbol_Sort, new IValue[]{VF.string("Module")})});
    private final Type startModuleType = RascalTypeFactory.getInstance().nonTerminalType(this.startModuleConstructor);
    private final Type getParseTreeType = this.tf.functionType(this.startModuleType, this.tf.tupleType(new Type[]{this.tf.sourceLocationType()}), this.tf.tupleEmpty());
    private final ExecutorService exec;
    private final IBaseLanguageClient client;
    private final RascalTextDocumentService rascalTextDocumentService;
    private final BaseWorkspaceService workspaceService;
    private final RascalLSPMonitor monitor;

    public RascalLanguageServices(RascalTextDocumentService docService, BaseWorkspaceService workspaceService, IBaseLanguageClient client, ExecutorService exec) {
        this.client = client;
        this.exec = exec;
        this.monitor = new RascalLSPMonitor(client, logger);
        PathConfig pcfg = EvaluatorUtil.addLSPSources(new PathConfig(URIUtil.rootLocation((String)"cwd")), true);
        PathConfig compilerPcfg = EvaluatorUtil.addRascalCompilerSources(pcfg);
        EvaluatorUtil.LSPContext context = new EvaluatorUtil.LSPContext(exec, docService, workspaceService, client);
        this.shortRunningTaskEvaluator = EvaluatorUtil.makeFutureEvaluator(context, "Rascal tasks", this.monitor, pcfg, "lang::rascal::lsp::DocumentSymbols", "lang::rascal::lsp::Templates");
        this.semanticEvaluator = EvaluatorUtil.makeFutureEvaluator(context, "Rascal semantics", this.monitor, compilerPcfg, "lang::rascalcore::check::Summary", "lang::rascal::lsp::refactor::Rename", "lang::rascal::lsp::Actions");
        this.compilerEvaluator = EvaluatorUtil.makeFutureEvaluator(context, "Rascal compiler", this.monitor, compilerPcfg, "lang::rascal::lsp::IDECheckerWrapper");
        this.actionStore = this.semanticEvaluator.thenApply(e -> ((ModuleEnvironment)e.getModule("lang::rascal::lsp::Actions")).getStore());
        this.rascalTextDocumentService = docService;
        this.workspaceService = workspaceService;
    }

    public InterruptibleFuture<@Nullable IConstructor> getSummary(ISourceLocation occ, PathConfig pcfg) {
        try {
            IString moduleName = VF.string(pcfg.getModuleName(occ));
            return EvaluatorUtil.runEvaluator("Rascal makeSummary", this.semanticEvaluator, eval -> {
                IConstructor result = (IConstructor)eval.call("makeSummary", new IValue[]{moduleName, pcfg.asConstructor()});
                return result != null && result.asWithKeywordParameters().hasParameters() ? result : null;
            }, null, this.exec, false, this.client);
        }
        catch (IOException e) {
            logger.error("Error looking up module name from source location {}", (Object)occ, (Object)e);
            return InterruptibleFuture.completedFuture(null, this.exec);
        }
    }

    private static Map<ISourceLocation, ISet> translateCheckResults(IMap messages) {
        logger.trace("Translating messages: {}", (Object)messages);
        return messages.stream().map(ITuple.class::cast).collect(Collectors.toMap(c -> (ISourceLocation)c.get(0), c -> (ISet)c.get(1)));
    }

    IFunction makePathConfigGetter(Evaluator e) {
        return e.getFunctionValueFactory().function(this.getPathConfigType, (t, u) -> this.rascalTextDocumentService.getFileFacts().getPathConfig((ISourceLocation)t[0]).asConstructor());
    }

    IFunction makeParseTreeGetter(Evaluator e) {
        return e.getFunctionValueFactory().function(this.getParseTreeType, (t, u) -> {
            ITree iTree;
            block14: {
                ISourceLocation resolvedLocation = Locations.toClientLocation((ISourceLocation)t[0]);
                try {
                    Versioned<ITree> tree = this.rascalTextDocumentService.getFile(resolvedLocation).getCurrentTreeAsync(true).get();
                    if (tree != null) {
                        return (IValue)tree.get();
                    }
                }
                catch (ExecutionException | ResponseErrorException tree) {
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                Reader reader = URIResolverRegistry.getInstance().getCharacterReader(resolvedLocation);
                try {
                    iTree = RascalServices.parseRascalModule(resolvedLocation, Prelude.consumeInputStream((Reader)reader).toCharArray());
                    if (reader == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e1) {
                        throw RuntimeExceptionFactory.io((String)("Could not open " + String.valueOf(t[0]) + " for reading"));
                    }
                    catch (ParseError pe) {
                        throw RuntimeExceptionFactory.parseError((ISourceLocation)pe.getLocation());
                    }
                    catch (SyntaxError se) {
                        throw RuntimeExceptionFactory.parseError((ISourceLocation)se.getLocation());
                    }
                }
                reader.close();
            }
            return iTree;
        });
    }

    public InterruptibleFuture<Map<ISourceLocation, ISet>> compileFile(ISourceLocation file, PathConfig pcfg, Executor exec) {
        logger.debug("Running Rascal check for: {} with {}", (Object)file, (Object)pcfg);
        ISet workspaceFolders = (ISet)this.workspaceService.workspaceFolders().stream().map(f -> Locations.toLoc(f.getUri())).collect(VF.setWriter());
        String shortModuleName = URIUtil.getLocationName((ISourceLocation)URIUtil.removeExtension((ISourceLocation)file));
        return EvaluatorUtil.runEvaluator("Rascal check (" + shortModuleName + ")", this.compilerEvaluator, e -> RascalLanguageServices.translateCheckResults((IMap)e.call("checkFile", new IValue[]{file, workspaceFolders, this.makeParseTreeGetter((Evaluator)e), this.makePathConfigGetter((Evaluator)e)})), Map.of(file, VF.set(new IValue[0])), exec, false, this.client);
    }

    private @Nullable ISourceLocation getFileLoc(ITree moduleTree) {
        try {
            ISourceLocation loc;
            if (TreeAdapter.isTop((ITree)moduleTree)) {
                moduleTree = TreeAdapter.getStartTop((ITree)moduleTree);
            }
            if ((loc = TreeAdapter.getLocation((ITree)moduleTree)) != null) {
                return loc.top();
            }
            return null;
        }
        catch (Exception t) {
            logger.trace("Failure to get file loc from tree: {}", (Object)moduleTree, (Object)t);
            return null;
        }
    }

    public InterruptibleFuture<IList> getDocumentSymbols(IConstructor module) {
        ISourceLocation loc = this.getFileLoc((ITree)module);
        if (loc == null) {
            return InterruptibleFuture.completedFuture(VF.list(new IValue[0]), this.exec);
        }
        return EvaluatorUtil.runEvaluator("Rascal Document Symbols", this.shortRunningTaskEvaluator, eval -> (IList)eval.call("documentRascalSymbols", new IValue[]{module}), VF.list(new IValue[0]), this.exec, false, this.client);
    }

    public InterruptibleFuture<ITuple> getRename(ISourceLocation cursorLoc, IList focus, Set<ISourceLocation> workspaceFolders, String newName) {
        return EvaluatorUtil.runEvaluator("Rascal rename", this.semanticEvaluator, eval -> {
            try {
                return (ITuple)eval.call("rascalRenameSymbol", new IValue[]{cursorLoc, focus, VF.string(newName), (IValue)workspaceFolders.stream().collect(VF.setWriter()), this.makePathConfigGetter((Evaluator)eval)});
            }
            catch (Throw e) {
                IConstructor exception;
                if (e.getException() instanceof IConstructor && (exception = (IConstructor)e.getException()).getType().getAbstractDataType().getName().equals("RenameException")) {
                    Object message = exception.has("message") ? ((IString)exception.get("message")).getValue() : "Rename failed: " + exception.getName();
                    throw new ResponseErrorException(new ResponseError(ResponseErrorCode.RequestFailed, (String)message, null));
                }
                throw e;
            }
        }, VF.tuple(new IValue[]{VF.list(new IValue[0]), VF.map()}), this.exec, false, this.client);
    }

    public InterruptibleFuture<ITuple> getModuleRenames(IList fileRenames, Set<ISourceLocation> workspaceFolders) {
        ITuple emptyResult = VF.tuple(new IValue[]{VF.list(new IValue[0]), VF.map()});
        if (fileRenames.isEmpty()) {
            return InterruptibleFuture.completedFuture(emptyResult, this.exec);
        }
        return EvaluatorUtil.runEvaluator("Rascal module rename", this.semanticEvaluator, eval -> (ITuple)eval.call("rascalRenameModule", new IValue[]{fileRenames, (IValue)workspaceFolders.stream().collect(VF.setWriter()), this.makePathConfigGetter((Evaluator)eval)}), emptyResult, this.exec, false, this.client);
    }

    public InterruptibleFuture<IList> newModuleTemplates(IList newFiles) {
        return EvaluatorUtil.runEvaluator("Rascal new module", this.shortRunningTaskEvaluator, eval -> (IList)eval.call("newModuleTemplates", new IValue[]{newFiles, this.makePathConfigGetter((Evaluator)eval)}), VF.list(new IValue[0]), this.exec, false, this.client);
    }

    public CompletableFuture<ITree> parseSourceFile(ISourceLocation loc, String input) {
        return CompletableFuture.supplyAsync(() -> RascalServices.parseRascalModule(loc, input.toCharArray()), this.exec);
    }

    public List<CodeLensSuggestion> locateCodeLenses(ITree tree) {
        tree = TreeAdapter.getStartTop((ITree)tree);
        ITree module = TreeAdapter.getArg((ITree)TreeAdapter.getArg((ITree)tree, (String)"header"), (String)"name");
        String moduleName = TreeAdapter.yield((IConstructor)module);
        ArrayList<CodeLensSuggestion> result = new ArrayList<CodeLensSuggestion>(2);
        result.add(new CodeLensSuggestion(module, "Import in new Rascal terminal", "rascalmpl.importModule", moduleName));
        ITree body = TreeAdapter.getArg((ITree)tree, (String)"body");
        ITree toplevels = TreeAdapter.getArg((ITree)body, (String)"toplevels");
        for (IValue topLevel : TreeAdapter.getListASTArgs((ITree)toplevels)) {
            try {
                ITree signature;
                ITree name;
                ITree decl = TreeAdapter.getArg((ITree)((ITree)topLevel), (String)"declaration");
                if (!"function".equals(TreeAdapter.getConstructorName((ITree)decl)) || !"main".equals(TreeAdapter.yield((IConstructor)(name = TreeAdapter.getArg((ITree)(signature = TreeAdapter.getArg((ITree)TreeAdapter.getArg((ITree)decl, (String)"functionDeclaration"), (String)"signature")), (String)"name"))))) continue;
                result.add(new CodeLensSuggestion(name, "Run in new Rascal terminal", "rascalmpl.runMain", moduleName));
            }
            catch (Exception e) {
                logger.warn("Failed to process top-level tree, it probably contains a parse error: {}", (Object)topLevel, (Object)e);
            }
        }
        return result;
    }

    public CompletableFuture<IList> parseCodeActions(String command) {
        return this.actionStore.thenApply(commandStore -> {
            try {
                Type codeActionADT = commandStore.lookupAbstractDataType("CodeAction");
                if (codeActionADT == null) {
                    throw new IllegalStateException("Type store is missing CodeAction ADT");
                }
                return (IList)new StandardTextReader().read(VF, commandStore, TypeFactory.getInstance().listType(codeActionADT), (Reader)new StringReader(command));
            }
            catch (FactTypeUseException | IOException e) {
                throw new IllegalArgumentException("The command could not be parsed", e);
            }
        });
    }

    public InterruptibleFuture<IValue> executeCommand(String command) {
        logger.debug("executeCommand({}...) (full command value in TRACE level)", () -> command.substring(0, Math.min(10, command.length())));
        logger.trace("Full command: {}", (Object)command);
        IMapWriter defaultMap = VF.mapWriter();
        defaultMap.put((IValue)VF.string("result"), (IValue)VF.bool(false));
        return InterruptibleFuture.flatten(this.parseCommand(command).thenApply(cons -> EvaluatorUtil.runEvaluator("executeCommand", this.semanticEvaluator, ev -> ev.call("evaluateRascalCommand", new IValue[]{cons}), defaultMap.done(), this.exec, true, this.client)), this.exec);
    }

    private CompletableFuture<IConstructor> parseCommand(String command) {
        return this.actionStore.thenApply(commandStore -> {
            try {
                Type commandADT = commandStore.lookupAbstractDataType("Command");
                if (commandADT == null) {
                    throw new IllegalStateException("Type store is missing Command ADT");
                }
                return (IConstructor)new StandardTextReader().read(VF, commandStore, commandADT, (Reader)new StringReader(command));
            }
            catch (FactTypeUseException | IOException e) {
                logger.catching(e);
                throw new IllegalArgumentException("The command could not be parsed", e);
            }
        });
    }

    public InterruptibleFuture<IList> codeActions(IList focus, PathConfig pcfg) {
        return EvaluatorUtil.runEvaluator("Rascal codeActions", this.semanticEvaluator, eval -> {
            Map<String, IConstructor> kws = Map.of("pcfg", pcfg.asConstructor());
            return (IList)eval.call("rascalCodeActions", "lang::rascal::lsp::Actions", kws, new IValue[]{focus});
        }, VF.list(new IValue[0]), this.exec, false, this.client);
    }

    public void cancelProgress(String progressId) {
        this.monitor.cancelProgress(progressId);
    }

    public static final class CodeLensSuggestion {
        private final ISourceLocation line;
        private final String commandName;
        private final List<Object> arguments;
        private final String shortName;

        public CodeLensSuggestion(ITree line, String shortName, String commandName, Object ... arguments) {
            this.line = TreeAdapter.getLocation((ITree)line);
            this.arguments = Arrays.asList(arguments);
            this.commandName = commandName;
            this.shortName = shortName;
        }

        public List<Object> getArguments() {
            return this.arguments;
        }

        public ISourceLocation getLine() {
            return this.line;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public String getShortName() {
            return this.shortName;
        }
    }
}

