/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.rascal;

import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFilesParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FileCreate;
import org.eclipse.lsp4j.FileDelete;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensDelta;
import org.eclipse.lsp4j.SemanticTokensDeltaParams;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SemanticTokensRangeParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.util.locations.LineColumnOffsetMap;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;
import org.rascalmpl.vscode.lsp.BaseWorkspaceService;
import org.rascalmpl.vscode.lsp.IBaseLanguageClient;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.TextDocumentState;
import org.rascalmpl.vscode.lsp.parametric.LanguageRegistry;
import org.rascalmpl.vscode.lsp.rascal.RascalLanguageServices;
import org.rascalmpl.vscode.lsp.rascal.model.FileFacts;
import org.rascalmpl.vscode.lsp.rascal.model.SummaryBridge;
import org.rascalmpl.vscode.lsp.uri.FallbackResolver;
import org.rascalmpl.vscode.lsp.util.CodeActions;
import org.rascalmpl.vscode.lsp.util.Diagnostics;
import org.rascalmpl.vscode.lsp.util.DocumentChanges;
import org.rascalmpl.vscode.lsp.util.DocumentSymbols;
import org.rascalmpl.vscode.lsp.util.FoldingRanges;
import org.rascalmpl.vscode.lsp.util.SelectionRanges;
import org.rascalmpl.vscode.lsp.util.SemanticTokenizer;
import org.rascalmpl.vscode.lsp.util.Versioned;
import org.rascalmpl.vscode.lsp.util.concurrent.CompletableFutureUtils;
import org.rascalmpl.vscode.lsp.util.locations.Locations;
import org.rascalmpl.vscode.lsp.util.locations.impl.TreeSearch;

public class RascalTextDocumentService
implements IBaseTextDocumentService,
LanguageClientAware {
    private static final IValueFactory VF = IRascalValueFactory.getInstance();
    private static final Logger logger = LogManager.getLogger(RascalTextDocumentService.class);
    private final ExecutorService exec;
    private @MonotonicNonNull RascalLanguageServices rascalServices;
    private final SemanticTokenizer tokenizer = new SemanticTokenizer(true);
    private @MonotonicNonNull LanguageClient client;
    private final Map<ISourceLocation, TextDocumentState> documents;
    private final ColumnMaps columns;
    private @MonotonicNonNull FileFacts facts;
    private @MonotonicNonNull BaseWorkspaceService workspaceService;

    public RascalTextDocumentService(ExecutorService exec) {
        URIResolverRegistry.getInstance();
        this.exec = exec;
        this.documents = new ConcurrentHashMap<ISourceLocation, TextDocumentState>();
        this.columns = new ColumnMaps(this::getContents);
        FallbackResolver.getInstance().registerTextDocumentService(this);
    }

    private LanguageClient availableClient() {
        if (this.client == null) {
            throw new IllegalStateException("Client has not been connected yet");
        }
        return this.client;
    }

    private RascalLanguageServices availableRascalServices() {
        if (this.rascalServices == null) {
            throw new IllegalStateException("Rascal Services has not been constructed yet");
        }
        return this.rascalServices;
    }

    private FileFacts availableFacts() {
        if (this.facts == null) {
            throw new IllegalStateException("Facts has not been constructed yet");
        }
        return this.facts;
    }

    private BaseWorkspaceService availableWorkspaceServices() {
        if (this.workspaceService == null) {
            throw new IllegalStateException("WorkspaceServices has not been constructed yet");
        }
        return this.workspaceService;
    }

    @Override
    public ColumnMaps getColumnMaps() {
        return this.columns;
    }

    @Override
    public LineColumnOffsetMap getColumnMap(ISourceLocation file) {
        return this.columns.get(file);
    }

    public String getContents(ISourceLocation file) {
        String string;
        block10: {
            TextDocumentState ideState = this.documents.get(file = file.top());
            if (ideState != null) {
                return ideState.getCurrentContent().get();
            }
            if (!URIResolverRegistry.getInstance().isFile(file)) {
                logger.error("Trying to get the contents of a directory: {}", (Object)file);
                return "";
            }
            Reader src = URIResolverRegistry.getInstance().getCharacterReader(file);
            try {
                string = Prelude.consumeInputStream((Reader)src);
                if (src == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (src != null) {
                        try {
                            src.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error opening file {} to get contents", (Object)file, (Object)e);
                    return "";
                }
            }
            src.close();
        }
        return string;
    }

    @Override
    public void initializeServerCapabilities(ServerCapabilities result) {
        result.setDefinitionProvider(true);
        result.setTextDocumentSync(TextDocumentSyncKind.Full);
        result.setDocumentSymbolProvider(true);
        result.setHoverProvider(true);
        result.setSemanticTokensProvider(this.tokenizer.options());
        result.setCodeLensProvider(new CodeLensOptions(false));
        result.setFoldingRangeProvider(true);
        result.setRenameProvider(new RenameOptions(true));
        result.setCodeActionProvider(true);
        result.setExecuteCommandProvider(new ExecuteCommandOptions(Collections.singletonList("rascal-command")));
        result.setSelectionRangeProvider(true);
    }

    @Override
    public void pair(BaseWorkspaceService workspaceService) {
        this.workspaceService = workspaceService;
    }

    @Override
    public void connect(LanguageClient client) {
        this.client = client;
        this.rascalServices = new RascalLanguageServices(this, this.availableWorkspaceServices(), (IBaseLanguageClient)client, this.exec);
        this.facts = new FileFacts(this.exec, this.rascalServices, client, this.columns);
    }

    @Override
    public void initialized() {
    }

    @Override
    public void didOpen(DidOpenTextDocumentParams params) {
        long timestamp = System.currentTimeMillis();
        logger.debug("Open: {}", (Object)params.getTextDocument());
        TextDocumentState file = this.open(params.getTextDocument(), timestamp);
        this.handleParsingErrors(file, file.getCurrentDiagnosticsAsync());
    }

    @Override
    public void didChange(DidChangeTextDocumentParams params) {
        long timestamp = System.currentTimeMillis();
        logger.trace("Change: {}", (Object)params.getTextDocument());
        this.updateContents(params.getTextDocument(), RascalTextDocumentService.last(params.getContentChanges()).getText(), timestamp);
    }

    @Override
    public void didClose(DidCloseTextDocumentParams params) {
        logger.debug("Close: {}", (Object)params.getTextDocument());
        ISourceLocation loc = Locations.toLoc(params.getTextDocument());
        if (this.documents.remove(loc) == null) {
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, "Unknown file: " + String.valueOf(loc), (Object)params));
        }
        if (this.facts != null) {
            this.facts.close(loc);
        }
        if (!URIResolverRegistry.getInstance().exists(loc)) {
            this.didDeleteFiles(new DeleteFilesParams(List.of(new FileDelete(params.getTextDocument().getUri()))));
        }
    }

    @Override
    public void didDeleteFiles(DeleteFilesParams params) {
        this.exec.submit(() -> {
            for (FileDelete f : params.getFiles()) {
                this.availableClient().publishDiagnostics(new PublishDiagnosticsParams(f.getUri(), List.of()));
            }
        });
    }

    @Override
    public void didSave(DidSaveTextDocumentParams params) {
        logger.debug("Save: {}", (Object)params.getTextDocument());
        if (this.facts != null) {
            this.facts.invalidate(Locations.toLoc(params.getTextDocument()));
        }
    }

    private TextDocumentState updateContents(VersionedTextDocumentIdentifier doc, String newContents, long timestamp) {
        TextDocumentState file = this.getFile(doc);
        logger.trace("New contents for {}", (Object)doc);
        this.columns.clear(file.getLocation());
        this.handleParsingErrors(file, file.update(doc.getVersion(), newContents, timestamp));
        return file;
    }

    private void handleParsingErrors(TextDocumentState file, CompletableFuture<Versioned<List<Diagnostics.Template>>> diagnosticsAsync) {
        diagnosticsAsync.thenAccept(diagnostics -> {
            List<Diagnostic> parseErrors = ((List)diagnostics.get()).stream().map(diagnostic -> diagnostic.instantiate(this.columns)).collect(Collectors.toList());
            logger.trace("Finished parsing tree, reporting new parse errors: {} for: {}", (Object)parseErrors, (Object)file.getLocation());
            if (this.facts != null) {
                this.facts.reportParseErrors(file.getLocation(), parseErrors);
            }
        });
    }

    @Override
    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        logger.debug("textDocument/definition: {} at {}", (Object)params.getTextDocument(), (Object)params.getPosition());
        if (this.facts != null) {
            return RascalTextDocumentService.recoverExceptions(((CompletableFuture)this.facts.getSummary(Locations.toLoc(params.getTextDocument())).thenApply(s -> s == null ? Collections.emptyList() : s.getDefinition(params.getPosition()))).thenApply(Either::forLeft), () -> Either.forLeft(Collections.emptyList()));
        }
        return CompletableFutureUtils.completedFuture(Either.forLeft(Collections.emptyList()), this.exec);
    }

    @Override
    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        logger.debug("textDocument/documentSymbol: {}", (Object)params.getTextDocument());
        TextDocumentState file = this.getFile(params.getTextDocument());
        return RascalTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)file.getLastTreeAsync(true).thenApply(Versioned::get)).thenCompose(tr -> this.availableRascalServices().getDocumentSymbols((IConstructor)tr).get())).thenApply(documentSymbols -> DocumentSymbols.toLSP(documentSymbols, this.columns.get(file.getLocation()))));
    }

    private ITree findQualifiedNameUnderCursor(IList focusList) {
        List sortNames = focusList.stream().map(ITree.class::cast).map(TreeAdapter::getProduction).map(ProductionAdapter::getSortName).collect(Collectors.toList());
        int qNameIdx = sortNames.indexOf("QualifiedName");
        if (qNameIdx != -1) {
            ITree qualifiedName = (ITree)focusList.get(qNameIdx);
            if (sortNames.contains("Header") && !sortNames.contains("ModuleParameters") && !sortNames.contains("SyntaxDefinition")) {
                return qualifiedName;
            }
            IList names = TreeAdapter.getListASTArgs((ITree)TreeAdapter.getArg((ITree)qualifiedName, (String)"names"));
            return (ITree)names.get(names.size() - 1);
        }
        switch ((String)sortNames.get(0)) {
            case "Name": 
            case "Nonterminal": 
            case "NonterminalLabel": {
                return (ITree)focusList.get(0);
            }
        }
        throw new ResponseErrorException(new ResponseError(ResponseErrorCode.RequestFailed, "No qualified name under cursor", null));
    }

    @Override
    public CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(PrepareRenameParams params) {
        logger.debug("textDocument/prepareRename: {} at {}", (Object)params.getTextDocument(), (Object)params.getPosition());
        TextDocumentState file = this.getFile(params.getTextDocument());
        return RascalTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)((CompletableFuture)file.getCurrentTreeAsync(false).thenApply(Versioned::get)).thenApply(tr -> {
            Position rascalCursorPos = Locations.toRascalPosition(file.getLocation(), params.getPosition(), this.columns);
            IList focus = TreeSearch.computeFocusList(tr, rascalCursorPos.getLine(), rascalCursorPos.getCharacter());
            return this.findQualifiedNameUnderCursor(focus);
        })).thenApply(cur -> Locations.toRange(TreeAdapter.getLocation((ITree)cur), this.columns))).thenApply(Either3::forFirst), () -> null);
    }

    @Override
    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        logger.debug("textDocument/rename: {} at {} to {}", (Object)params.getTextDocument(), (Object)params.getPosition(), (Object)params.getNewName());
        TextDocumentState file = this.getFile(params.getTextDocument());
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)file.getCurrentTreeAsync(false).thenApply(Versioned::get)).handle((t, e) -> {
            if (e != null) {
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.RequestFailed, "We cannot rename in a file with parse errors.", null));
            }
            return t;
        })).thenCompose(tr -> {
            Position rascalCursorPos = Locations.toRascalPosition(file.getLocation(), params.getPosition(), this.columns);
            IList focus = TreeSearch.computeFocusList(tr, rascalCursorPos.getLine(), rascalCursorPos.getCharacter());
            ITree cursorTree = this.findQualifiedNameUnderCursor(focus);
            Set<ISourceLocation> workspaceFolders = this.availableWorkspaceServices().workspaceFolders().stream().map(f -> Locations.toLoc(f.getUri())).collect(Collectors.toSet());
            return this.availableRascalServices().getRename(TreeAdapter.getLocation((ITree)cursorTree), focus, workspaceFolders, params.getNewName()).get();
        })).thenApply(t -> {
            this.showMessages((ISet)t.get(1));
            return DocumentChanges.translateDocumentChanges((IList)t.get(0), this.columns);
        });
    }

    private void showMessages(ISet messages) {
        this.exec.submit(() -> {
            for (IValue msg : messages) {
                this.availableClient().showMessage(this.setMessageParams((IConstructor)msg));
            }
        });
    }

    private MessageParams setMessageParams(IConstructor message) {
        MessageParams params = new MessageParams();
        switch (message.getName()) {
            case "error": {
                params.setType(MessageType.Error);
                break;
            }
            case "warning": {
                params.setType(MessageType.Warning);
                break;
            }
            case "info": {
                params.setType(MessageType.Info);
                break;
            }
            default: {
                params.setType(MessageType.Log);
            }
        }
        String msgText = ((IString)message.get("msg")).getValue();
        if (message.has("at")) {
            URI at = Locations.toUri((ISourceLocation)message.get("at"));
            params.setMessage(String.format("%s (at %s)", msgText, at));
        } else {
            params.setMessage(msgText);
        }
        return params;
    }

    @Override
    public CompletableFuture<@Nullable Hover> hover(HoverParams params) {
        logger.debug("textDocument/hover: {} at {}", (Object)params.getTextDocument(), (Object)params.getPosition());
        if (this.facts != null) {
            return RascalTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)this.facts.getSummary(Locations.toLoc(params.getTextDocument())).handle((t, r) -> t == null ? new SummaryBridge() : t)).thenApply(s -> s.getTypeName(params.getPosition()))).thenApply(n -> new Hover(new MarkupContent("plaintext", (String)n))), () -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        logger.debug("textDocument/foldingRange: {}", (Object)params.getTextDocument());
        TextDocumentState file = this.getFile(params.getTextDocument());
        return RascalTextDocumentService.recoverExceptions(((CompletableFuture)file.getCurrentTreeAsync(true).thenApply(Versioned::get)).thenApply(FoldingRanges::getFoldingRanges)).whenComplete((r, e) -> logger.trace("Folding regions success, reporting {} regions back", (Object)(r == null ? 0 : r.size())));
    }

    @Override
    public void didCreateFiles(CreateFilesParams params) {
        IList newFiles = (IList)params.getFiles().stream().map(FileCreate::getUri).map(Locations::toLoc).collect(VF.listWriter());
        CompletableFuture<IList> edits = this.availableRascalServices().newModuleTemplates(newFiles).get();
        this.applyDocumentEdits("Auto-insert module headers", edits, res -> logger.error("Applying new module template failed{}", (Object)this.failureReason((ApplyWorkspaceEditResponse)res)));
    }

    @Override
    public void didRenameFiles(RenameFilesParams params, List<WorkspaceFolder> workspaceFolders) {
        this.exec.submit(() -> {
            Set<ISourceLocation> folders = workspaceFolders.stream().map(f -> Locations.toLoc(f.getUri())).collect(Collectors.toSet());
            IList renames = (IList)params.getFiles().stream().map(r -> VF.tuple(new IValue[]{Locations.toLoc(r.getOldUri()), Locations.toLoc(r.getNewUri())})).collect(VF.listWriter());
            CompletionStage rascalEdits = this.availableRascalServices().getModuleRenames(renames, folders).get().thenApply(res -> {
                IList edits = (IList)res.get(0);
                ISet messages = (ISet)res.get(1);
                this.showMessages(messages);
                return edits;
            });
            this.applyDocumentEdits("Module rename", (CompletableFuture<IList>)rascalEdits, res -> {
                throw new RuntimeException("Applying module rename failed" + this.failureReason((ApplyWorkspaceEditResponse)res));
            });
        });
    }

    private String failureReason(ApplyWorkspaceEditResponse res) {
        return res.getFailureReason() != null ? ": " + res.getFailureReason() : "";
    }

    private static <T> T last(List<T> l) {
        return l.get(l.size() - 1);
    }

    private TextDocumentState open(TextDocumentItem doc, long timestamp) {
        return this.documents.computeIfAbsent(Locations.toLoc(doc), l -> new TextDocumentState(this.availableRascalServices()::parseSourceFile, (ISourceLocation)l, doc.getVersion(), doc.getText(), timestamp));
    }

    private TextDocumentState getFile(TextDocumentIdentifier doc) {
        return this.getFile(Locations.toLoc(doc));
    }

    protected TextDocumentState getFile(ISourceLocation loc) {
        TextDocumentState file = this.documents.get(loc);
        if (file == null) {
            throw new ResponseErrorException(new ResponseError(-1, "Unknown file: " + String.valueOf(loc), (Object)loc));
        }
        return file;
    }

    @Override
    public void shutdown() {
        this.exec.shutdown();
    }

    private CompletableFuture<SemanticTokens> getSemanticTokens(TextDocumentIdentifier doc) {
        return RascalTextDocumentService.recoverExceptions(((CompletableFuture)this.getFile(doc).getCurrentTreeAsync(true).thenApply(Versioned::get)).thenApply(t -> this.tokenizer.semanticTokensFull((ITree)t, false)), SemanticTokens::new).whenComplete((r, e) -> logger.trace("Semantic tokens success, reporting {} tokens back", (Object)(r == null ? 0 : r.getData().size())));
    }

    @Override
    public CompletableFuture<SemanticTokens> semanticTokensFull(SemanticTokensParams params) {
        logger.debug("semanticTokensFull: {}", (Object)params.getTextDocument());
        return this.getSemanticTokens(params.getTextDocument());
    }

    @Override
    public CompletableFuture<Either<SemanticTokens, SemanticTokensDelta>> semanticTokensFullDelta(SemanticTokensDeltaParams params) {
        logger.debug("semanticTokensFullDelta: {}", (Object)params.getTextDocument());
        return this.getSemanticTokens(params.getTextDocument()).thenApply(Either::forLeft);
    }

    @Override
    public CompletableFuture<SemanticTokens> semanticTokensRange(SemanticTokensRangeParams params) {
        logger.debug("semanticTokensRange: {}", (Object)params.getTextDocument());
        return this.getSemanticTokens(params.getTextDocument());
    }

    @Override
    public CompletableFuture<List<SelectionRange>> selectionRange(SelectionRangeParams params) {
        logger.debug("textDocument/selectionRange: {}", (Object)params);
        TextDocumentState file = this.getFile(params.getTextDocument());
        return RascalTextDocumentService.recoverExceptions(((CompletableFuture)file.getCurrentTreeAsync(true).thenApply(Versioned::get)).thenApply(tr -> params.getPositions().stream().map(p -> Locations.toRascalPosition(file.getLocation(), p, this.columns)).map(p -> {
            IList focus = TreeSearch.computeFocusList(tr, p.getLine(), p.getCharacter());
            IList locs = SelectionRanges.uniqueTreeLocations(focus);
            return SelectionRanges.toSelectionRange(p, locs, this.columns);
        }).collect(Collectors.toList())));
    }

    private CompletableFuture<Void> applyDocumentEdits(String task, CompletableFuture<IList> rascalEdits, Consumer<ApplyWorkspaceEditResponse> notApplied) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)rascalEdits.thenApply(edits -> !edits.isEmpty() ? Optional.of(DocumentChanges.translateDocumentChanges(edits, this.getColumnMaps())) : Optional.empty())).thenApply(e -> e.map(edits -> this.availableClient().applyEdit(new ApplyWorkspaceEditParams((WorkspaceEdit)edits, task))))).thenCompose(o -> o.orElse(CompletableFuture.supplyAsync(() -> new ApplyWorkspaceEditResponse(true), this.exec)))).thenAccept(res -> {
            if (!res.isApplied()) {
                logger.trace("Could not apply workspace edits: {}", (Object)res.getFailureReason());
                notApplied.accept((ApplyWorkspaceEditResponse)res);
            }
        })).exceptionally(e -> {
            Throwable cause = e.getCause();
            logger.catching(Level.ERROR, cause);
            String message = "unkown error";
            if (cause != null && cause.getMessage() != null) {
                message = cause.getMessage();
            }
            this.availableClient().showMessage(new MessageParams(MessageType.Error, String.format("Error during '%s': %s", task, message)));
            return null;
        });
    }

    @Override
    public void registerLanguage(LanguageRegistry.LanguageParameter lang) {
        throw new UnsupportedOperationException("registering language is a feature of the language parametric server, not of the Rascal server");
    }

    @Override
    public void unregisterLanguage(LanguageRegistry.LanguageParameter lang) {
        throw new UnsupportedOperationException("registering language is a feature of the language parametric server, not of the Rascal server");
    }

    @Override
    public void projectAdded(String name, ISourceLocation projectRoot) {
    }

    @Override
    public void projectRemoved(String name, ISourceLocation projectRoot) {
        if (this.facts != null) {
            this.facts.projectRemoved(projectRoot);
        }
    }

    @Override
    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        TextDocumentState f = this.getFile(params.getTextDocument());
        return RascalTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)f.getLastTreeAsync(false).thenApply(Versioned::get)).thenApplyAsync(this.availableRascalServices()::locateCodeLenses, (Executor)this.exec)).thenApply(Collection::stream)).thenApply(res -> res.map(this::makeRunCodeLens))).thenApply(s -> s.collect(Collectors.toList())), () -> null);
    }

    @Override
    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        logger.debug("textDocument/codeAction: {}", (Object)params);
        CompletableFuture<Stream<IValue>> quickfixes = CodeActions.extractActionsFromDiagnostics(params, this.availableRascalServices()::parseCodeActions, this.exec);
        CompletableFuture<Stream<IValue>> codeActions = RascalTextDocumentService.recoverExceptions(((CompletableFuture)((CompletableFuture)this.getFile(params.getTextDocument()).getCurrentTreeAsync(true).thenApply(Versioned::get)).thenCompose(tree -> {
            TextDocumentIdentifier doc = params.getTextDocument();
            Range range = Locations.toRascalRange(doc, params.getRange(), this.columns);
            return this.computeCodeActions(range.getStart().getLine(), range.getStart().getCharacter(), (ITree)tree, this.availableFacts().getPathConfig(Locations.toLoc(doc)));
        })).thenApply(ICollection::stream), Stream::empty);
        return CodeActions.mergeAndConvertCodeActions(this, "", "Rascal", quickfixes, codeActions);
    }

    private CompletableFuture<IList> computeCodeActions(int startLine, int startColumn, ITree tree, PathConfig pcfg) {
        return CompletableFuture.supplyAsync(() -> TreeSearch.computeFocusList(tree, startLine, startColumn), this.exec).thenCompose(focus -> focus.isEmpty() ? CompletableFuture.completedFuture(focus) : this.availableRascalServices().codeActions((IList)focus, pcfg).get());
    }

    private CodeLens makeRunCodeLens(RascalLanguageServices.CodeLensSuggestion detected) {
        return new CodeLens(Locations.toRange(detected.getLine(), this.columns), new Command(detected.getShortName(), detected.getCommandName(), detected.getArguments()), null);
    }

    @Override
    public CompletableFuture<IValue> executeCommand(String extension, String command) {
        return this.availableRascalServices().executeCommand(command).get();
    }

    private static <T, S extends T> CompletableFuture<T> recoverExceptions(CompletableFuture<T> future, Supplier<S> defaultValue) {
        return future.exceptionally(e -> {
            if (e instanceof ResponseErrorException) {
                throw (ResponseErrorException)e;
            }
            logger.error("Operation failed with", (Throwable)e);
            return defaultValue.get();
        });
    }

    private static <T> CompletableFuture<List<T>> recoverExceptions(CompletableFuture<List<T>> future) {
        return RascalTextDocumentService.recoverExceptions(future, Collections::emptyList);
    }

    @Override
    public boolean isManagingFile(ISourceLocation file) {
        return this.documents.containsKey(file.top());
    }

    @Override
    public @Nullable TextDocumentState getDocumentState(ISourceLocation file) {
        return this.documents.get(file.top());
    }

    public FileFacts getFileFacts() {
        return this.availableFacts();
    }

    @Override
    public void cancelProgress(String progressId) {
        this.exec.submit(() -> this.availableRascalServices().cancelProgress(progressId));
    }
}

