/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.rascal.model;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.usethesource.vallang.ISourceLocation;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.vscode.lsp.rascal.model.PathConfigDiagnostics;

public class PathConfigs {
    private static final Logger logger = LogManager.getLogger(PathConfigs.class);
    private static final long UPDATE_DELAY = TimeUnit.SECONDS.toNanos(5L);
    private static final URIResolverRegistry reg = URIResolverRegistry.getInstance();
    private final Map<ISourceLocation, PathConfig> currentPathConfigs = new ConcurrentHashMap<ISourceLocation, PathConfig>();
    private final PathConfigUpdater updater = new PathConfigUpdater(this.currentPathConfigs);
    private final LoadingCache<ISourceLocation, ISourceLocation> translatedRoots = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(20L)).build(PathConfigs::inferProjectRoot);
    private final Executor executor;
    private final PathConfigDiagnostics diagnostics;
    private static final Pattern detectParent = Pattern.compile("<\\s*parent\\s*>");

    public PathConfigs(Executor executor, PathConfigDiagnostics diagnostics) {
        this.diagnostics = diagnostics;
        this.executor = executor;
        this.updater.start();
    }

    public void expungePathConfig(ISourceLocation project) {
        ISourceLocation projectRoot = PathConfigs.inferProjectRoot(project);
        try {
            this.updater.unregisterProject(project);
        }
        catch (IOException e) {
            logger.warn("Unregistration of meta files for project {} failed.", (Object)project, (Object)e);
        }
        this.currentPathConfigs.remove(projectRoot);
    }

    public PathConfig lookupConfig(ISourceLocation forFile) {
        ISourceLocation projectRoot = (ISourceLocation)this.translatedRoots.get((Object)forFile);
        return this.currentPathConfigs.computeIfAbsent(projectRoot, this::buildPathConfig);
    }

    private static long safeLastModified(ISourceLocation uri) {
        try {
            return reg.lastModified(uri);
        }
        catch (IOException e) {
            logger.debug("Cannot get last modified time of {}", (Object)uri, (Object)e);
            return Long.MAX_VALUE;
        }
    }

    private PathConfig buildPathConfig(ISourceLocation projectRoot) {
        try {
            logger.debug("Building pcfg from: {}", (Object)projectRoot);
            ISourceLocation manifest = URIUtil.getChildLocation((ISourceLocation)projectRoot, (String)"META-INF/RASCAL.MF");
            if (reg.exists(manifest)) {
                this.updater.watchFile(projectRoot, manifest);
            }
            this.registerMavenWatches(reg, projectRoot);
            PathConfig result = this.updater.actualBuild(projectRoot);
            logger.debug("New path config: {}", (Object)result);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not build pathconfig", e);
        }
    }

    private void registerMavenWatches(URIResolverRegistry reg, ISourceLocation projectRoot) throws IOException {
        ISourceLocation mainPom = URIUtil.getChildLocation((ISourceLocation)projectRoot, (String)"pom.xml");
        if (reg.exists(mainPom)) {
            ISourceLocation parentPom;
            this.updater.watchFile(projectRoot, mainPom);
            if (PathConfigs.hasParentSection(reg, mainPom) && !mainPom.equals(parentPom = URIUtil.getChildLocation((ISourceLocation)URIUtil.getParentLocation((ISourceLocation)projectRoot), (String)"pom.xml")) && reg.exists(parentPom)) {
                this.updater.watchFile(projectRoot, parentPom);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasParentSection(URIResolverRegistry reg, ISourceLocation mainPom) {
        try (BufferedReader pom = new BufferedReader(reg.getCharacterReader(mainPom));){
            String line;
            while ((line = pom.readLine()) != null) {
                if (!detectParent.matcher(line).matches()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static ISourceLocation inferProjectRoot(ISourceLocation member) {
        ISourceLocation current = member;
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        if (!reg.isDirectory(current)) {
            current = URIUtil.getParentLocation((ISourceLocation)current);
        }
        while (current != null && reg.exists(current) && reg.isDirectory(current)) {
            if (reg.exists(URIUtil.getChildLocation((ISourceLocation)current, (String)"META-INF/RASCAL.MF"))) {
                return current;
            }
            if (URIUtil.getParentLocation((ISourceLocation)current).equals(current)) {
                return reg.isDirectory(member) ? member : URIUtil.getParentLocation((ISourceLocation)member);
            }
            current = URIUtil.getParentLocation((ISourceLocation)current);
        }
        return current;
    }

    private class PathConfigUpdater {
        private final Map<ISourceLocation, PathConfig> currentPathConfigs;
        private final Map<ISourceLocation, List<WatchRegistration>> projectWatches;
        private final Map<ISourceLocation, Long> changedRoots = new ConcurrentHashMap<ISourceLocation, Long>();

        public PathConfigUpdater(Map<ISourceLocation, PathConfig> currentPathConfigs) {
            this.currentPathConfigs = currentPathConfigs;
            this.projectWatches = new ConcurrentHashMap<ISourceLocation, List<WatchRegistration>>();
        }

        public void start() {
            this.scheduleRun();
        }

        public void watchFile(ISourceLocation projectRoot, ISourceLocation sourceFile) throws IOException {
            Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback = ignored -> this.changedRoots.put(projectRoot, PathConfigs.safeLastModified(sourceFile));
            reg.watch(sourceFile, false, callback);
            List watchList = this.projectWatches.computeIfAbsent(projectRoot, root -> new CopyOnWriteArrayList());
            watchList.add(new WatchRegistration(sourceFile, callback));
        }

        public void unregisterProject(ISourceLocation projectRoot) throws IOException {
            List<WatchRegistration> registrations = this.projectWatches.remove(projectRoot);
            if (registrations != null) {
                for (WatchRegistration registration : registrations) {
                    reg.unwatch(registration.file, false, registration.callback);
                }
            }
            PathConfigs.this.diagnostics.clearDiagnostics(projectRoot);
        }

        private void scheduleRun() {
            CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS, PathConfigs.this.executor).execute(this::run);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            try {
                List stabilizedRoots = this.changedRoots.entrySet().stream().filter(e -> FileTime.from(Instant.now()).to(TimeUnit.NANOSECONDS) - (Long)e.getValue() >= UPDATE_DELAY).map(Map.Entry::getKey).collect(Collectors.toList());
                try {
                    for (ISourceLocation root : stabilizedRoots) {
                        this.changedRoots.remove(root);
                        this.currentPathConfigs.replace(root, this.actualBuild(root));
                    }
                }
                catch (Exception e2) {
                    logger.error("Unexpected error while building PathConfigs", (Throwable)e2);
                }
            }
            finally {
                this.scheduleRun();
            }
        }

        private PathConfig actualBuild(ISourceLocation projectRoot) {
            PathConfig pathConfig = PathConfig.fromSourceProjectRascalManifest((ISourceLocation)projectRoot, (PathConfig.RascalConfigMode)PathConfig.RascalConfigMode.COMPILER, (boolean)true);
            PathConfigs.this.executor.execute(() -> PathConfigs.this.diagnostics.publishDiagnostics(projectRoot, pathConfig.getMessages()));
            return pathConfig;
        }
    }

    private static class WatchRegistration {
        final ISourceLocation file;
        final Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback;

        WatchRegistration(ISourceLocation file, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback) {
            this.file = file;
            this.callback = callback;
        }
    }
}

