/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.terminal;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.services.LanguageClient;
import org.rascalmpl.ideservices.GsonUtils;
import org.rascalmpl.ideservices.IRemoteIDEServices;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.IDEServicesConfiguration;
import org.rascalmpl.vscode.lsp.terminal.RemoteIDEServicesServer;

public class RemoteIDEServicesThread
extends Thread {
    private final ServerSocket serverSocket;
    private final LanguageClient languageClient;
    private final IBaseTextDocumentService docService;
    private final ExecutorService exec;
    public static final Logger logger = LogManager.getLogger(RemoteIDEServicesThread.class);

    public RemoteIDEServicesThread(ServerSocket serverSocket, LanguageClient languageClient, IBaseTextDocumentService docService, ExecutorService exec) {
        super("Remote IDE Services Thread");
        this.serverSocket = serverSocket;
        this.languageClient = languageClient;
        this.docService = docService;
        this.exec = exec;
    }

    @Override
    public void run() {
        try {
            while (true) {
                try {
                    while (true) {
                        Socket connection = this.serverSocket.accept();
                        connection.setTcpNoDelay(true);
                        Launcher<IRemoteIDEServices> remoteIDEServicesLauncher = new Launcher.Builder().setLocalService(new RemoteIDEServicesServer(this.languageClient, this.docService, this.exec)).setRemoteInterface(IRemoteIDEServices.class).setInput(connection.getInputStream()).setOutput(connection.getOutputStream()).configureGson(GsonUtils::configureGson).setExecutorService(this.exec).setExceptionHandler(e -> {
                            logger.error(e);
                            return new ResponseError(ResponseErrorCode.InternalError, e.getMessage() == null ? "unknown" : e.getMessage(), e);
                        }).create();
                        logger.trace("Remote IDE services thread started");
                        remoteIDEServicesLauncher.startListening();
                    }
                }
                catch (Throwable e2) {
                    logger.error("Failed to start Remote IDE services thread");
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e3) {
                logger.error(e3);
            }
            throw throwable;
        }
    }

    public static IDEServicesConfiguration startRemoteIDEServicesServer(LanguageClient languageClient, IBaseTextDocumentService docService, ExecutorService threadPool) {
        try {
            ServerSocket socket = new ServerSocket(0);
            new RemoteIDEServicesThread(socket, languageClient, docService, threadPool).start();
            return new IDEServicesConfiguration(socket.getLocalPort());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

