/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.uri;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.gson.JsonPrimitive;
import io.usethesource.vallang.ISourceLocation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.rascalmpl.uri.FileAttributes;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.ISourceLocationInputOutput;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.vscode.lsp.IBaseTextDocumentService;
import org.rascalmpl.vscode.lsp.TextDocumentState;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.VSCodeUriResolverClient;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.VSCodeUriResolverServer;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.VSCodeVFS;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.BooleanResult;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.DirectoryListingResult;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.FileAttributesResult;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.ISourceLocationRequest;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.NumberResult;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.ReadFileResult;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.TimestampResult;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.WriteFileRequest;
import org.rascalmpl.vscode.lsp.util.Lazy;

public class FallbackResolver
implements ISourceLocationInputOutput,
ISourceLocationWatcher,
ILogicalSourceLocationResolver {
    private static @MonotonicNonNull FallbackResolver instance = null;
    private final Cache<ISourceLocation, Lazy<Map<String, Boolean>>> cachedDirectoryListing = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(5L)).maximumSize(1000L).build();
    private final List<IBaseTextDocumentService> textDocumentServices = new CopyOnWriteArrayList<IBaseTextDocumentService>();

    public static FallbackResolver getInstance() {
        if (instance == null) {
            throw new IllegalStateException("FallbackResolver accessed before initialization");
        }
        return instance;
    }

    public FallbackResolver() {
        instance = this;
    }

    private static VSCodeUriResolverServer getServer() throws IOException {
        VSCodeUriResolverServer result = VSCodeVFS.INSTANCE.getServer();
        if (result == null) {
            throw new IOException("Missing VFS file server");
        }
        return result;
    }

    private static VSCodeUriResolverClient getClient() throws IOException {
        VSCodeUriResolverClient result = VSCodeVFS.INSTANCE.getClient();
        if (result == null) {
            throw new IOException("Missing VFS file client");
        }
        return result;
    }

    private static <T> T call(Function<VSCodeUriResolverServer, CompletableFuture<T>> target) throws IOException {
        try {
            return target.apply(FallbackResolver.getServer()).get(5L, TimeUnit.MINUTES);
        }
        catch (TimeoutException te) {
            throw new IOException("VSCode took too long to reply, interruption to avoid deadlocks");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException("Thread should have been interrupted");
        }
        catch (CompletionException | ExecutionException ce) {
            Throwable cause = ce.getCause();
            if (cause != null) {
                if (cause instanceof ResponseErrorException) {
                    throw FallbackResolver.translateException((ResponseErrorException)cause);
                }
                throw new IOException(cause);
            }
            throw new IOException(ce);
        }
    }

    private ISourceLocationRequest param(ISourceLocation uri) {
        return new ISourceLocationRequest(uri);
    }

    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        String fileBody = ((ReadFileResult)FallbackResolver.call(s -> s.readFile(this.param(uri)))).getContents();
        return Base64.getDecoder().wrap(new ByteArrayInputStream(fileBody.getBytes(StandardCharsets.ISO_8859_1)));
    }

    public boolean exists(ISourceLocation uri) {
        try {
            return ((BooleanResult)FallbackResolver.call(s -> s.exists(this.param(uri)))).getResult();
        }
        catch (IOException e) {
            return false;
        }
    }

    public long lastModified(ISourceLocation uri) throws IOException {
        return TimeUnit.SECONDS.toMillis(((TimestampResult)FallbackResolver.call(s -> s.lastModified(this.param(uri)))).getTimestamp());
    }

    public long created(ISourceLocation uri) throws IOException {
        return TimeUnit.SECONDS.toMillis(((TimestampResult)FallbackResolver.call(s -> s.created(this.param(uri)))).getTimestamp());
    }

    public boolean isDirectory(ISourceLocation uri) {
        try {
            Boolean result;
            Lazy cached = (Lazy)this.cachedDirectoryListing.getIfPresent((Object)URIUtil.getParentLocation((ISourceLocation)uri));
            if (cached != null && (result = (Boolean)((Map)cached.get()).get(URIUtil.getLocationName((ISourceLocation)uri))) != null) {
                return result;
            }
            return ((BooleanResult)FallbackResolver.call(s -> s.isDirectory(this.param(uri)))).getResult();
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isFile(ISourceLocation uri) {
        try {
            Boolean result;
            Lazy cached = (Lazy)this.cachedDirectoryListing.getIfPresent((Object)URIUtil.getParentLocation((ISourceLocation)uri));
            if (cached != null && (result = (Boolean)((Map)cached.get()).get(URIUtil.getLocationName((ISourceLocation)uri))) != null) {
                return result == false;
            }
            return ((BooleanResult)FallbackResolver.call(s -> s.isFile(this.param(uri)))).getResult();
        }
        catch (IOException e) {
            return false;
        }
    }

    public String[] list(ISourceLocation uri) throws IOException {
        DirectoryListingResult result = (DirectoryListingResult)FallbackResolver.call(s -> s.list(this.param(uri)));
        this.cachedDirectoryListing.put((Object)uri, Lazy.defer(() -> {
            String[] entries = result.getEntries();
            boolean[] areDirs = result.getAreDirectory();
            HashMap<String, Boolean> lookup = new HashMap<String, Boolean>(entries.length);
            assert (entries.length == areDirs.length);
            for (int i = 0; i < entries.length; ++i) {
                lookup.put(entries[i], areDirs[i]);
            }
            return lookup;
        }));
        return result.getEntries();
    }

    public String scheme() {
        throw new UnsupportedOperationException("Scheme not supported on fallback resolver");
    }

    public boolean supportsHost() {
        return false;
    }

    public OutputStream getOutputStream(final ISourceLocation uri, final boolean append) throws IOException {
        return new ByteArrayOutputStream(){
            private boolean closed = false;

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                String contents = Base64.getEncoder().encodeToString(this.toByteArray());
                FallbackResolver.call(s -> s.writeFile(new WriteFileRequest(uri, contents, append)));
                FallbackResolver.this.cachedDirectoryListing.invalidate((Object)URIUtil.getParentLocation((ISourceLocation)uri));
            }
        };
    }

    public void mkDirectory(ISourceLocation uri) throws IOException {
        FallbackResolver.call(s -> s.mkDirectory(this.param(uri)));
        this.cachedDirectoryListing.invalidate((Object)URIUtil.getParentLocation((ISourceLocation)uri));
    }

    public void remove(ISourceLocation uri) throws IOException {
        FallbackResolver.call(s -> s.remove(this.param(uri)));
        this.cachedDirectoryListing.invalidate((Object)uri);
        this.cachedDirectoryListing.invalidate((Object)URIUtil.getParentLocation((ISourceLocation)uri));
    }

    public void setLastModified(ISourceLocation uri, long timestamp) throws IOException {
        throw new IOException("setLastModified not supported by vscode");
    }

    public void watch(ISourceLocation root, Consumer<ISourceLocationWatcher.ISourceLocationChanged> watcher, boolean recursive) throws IOException {
        FallbackResolver.getClient().addWatcher(root, recursive, watcher, FallbackResolver.getServer());
    }

    public void unwatch(ISourceLocation root, Consumer<ISourceLocationWatcher.ISourceLocationChanged> watcher, boolean recursive) throws IOException {
        FallbackResolver.getClient().removeWatcher(root, recursive, watcher, FallbackResolver.getServer());
    }

    public boolean supportsRecursiveWatch() {
        return true;
    }

    public boolean isFileManaged(ISourceLocation file) {
        for (IBaseTextDocumentService service : this.textDocumentServices) {
            if (!service.isManagingFile(file)) continue;
            return true;
        }
        return false;
    }

    public ISourceLocation resolve(ISourceLocation input) throws IOException {
        if (this.isFileManaged(input)) {
            try {
                return URIUtil.changeScheme((ISourceLocation)input.top(), (String)("lsp+" + input.getScheme()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return input;
    }

    public String authority() {
        throw new UnsupportedOperationException("'authority' not supported by fallback resolver");
    }

    public void registerTextDocumentService(@UnderInitialization IBaseTextDocumentService service) {
        this.textDocumentServices.add(service);
    }

    public TextDocumentState getDocumentState(ISourceLocation file) throws IOException {
        for (IBaseTextDocumentService service : this.textDocumentServices) {
            TextDocumentState state = service.getDocumentState(file);
            if (state == null) continue;
            return state;
        }
        throw new IOException("File is not managed by lsp");
    }

    public long size(ISourceLocation uri) throws IOException {
        return ((NumberResult)FallbackResolver.call(s -> s.size(this.param(uri)))).getResult();
    }

    public boolean isReadable(ISourceLocation uri) throws IOException {
        return ((BooleanResult)FallbackResolver.call(s -> s.isReadable(this.param(uri)))).getResult();
    }

    public boolean isWritable(ISourceLocation uri) throws IOException {
        return ((BooleanResult)FallbackResolver.call(s -> s.isWritable(this.param(uri)))).getResult();
    }

    public FileAttributes stat(ISourceLocation uri) throws IOException {
        return ((FileAttributesResult)FallbackResolver.call(s -> s.stat(this.param(uri)))).getFileAttributes();
    }

    private static IOException translateException(ResponseErrorException cause) {
        ResponseError error = cause.getResponseError();
        switch (error.getCode()) {
            case -1: {
                return new IOException("Generic error: " + error.getMessage());
            }
            case -2: {
                JsonPrimitive data;
                if (error.getData() instanceof JsonPrimitive && (data = (JsonPrimitive)error.getData()).isString()) {
                    switch (data.getAsString()) {
                        case "FileExists": 
                        case "EntryExists": {
                            return new FileAlreadyExistsException(error.getMessage());
                        }
                        case "FileNotFound": 
                        case "EntryNotFound": {
                            return new NoSuchFileException(error.getMessage());
                        }
                        case "FileNotADirectory": 
                        case "EntryNotADirectory": {
                            return new NotDirectoryException(error.getMessage());
                        }
                        case "FileIsADirectory": 
                        case "EntryIsADirectory": {
                            return new IOException("File is a directory: " + error.getMessage());
                        }
                        case "NoPermissions": {
                            return new AccessDeniedException(error.getMessage());
                        }
                    }
                }
                return new IOException("File system error: " + error.getMessage() + " data: " + String.valueOf(error.getData()));
            }
            case -3: {
                return new IOException("Rascal native scheme's should not be forwarded to VS Code");
            }
        }
        return new IOException("Missing case for: " + String.valueOf(error));
    }
}

