/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.uri;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

class StringByteUtils {
    private static final int BUFFER_SIZE = 8192;

    private StringByteUtils() {
    }

    private static int estimateBufferSize(String s, CharsetEncoder enc) {
        float size = (float)s.length() * enc.averageBytesPerChar();
        if (size >= 8192.0f) {
            return 8192;
        }
        if (size < 16.0f) {
            return 16;
        }
        return (int)Math.ceil(size);
    }

    static InputStream streamingBytes(String s, Charset cs) {
        if (s.isEmpty()) {
            return InputStream.nullInputStream();
        }
        final CharsetEncoder enc = cs.newEncoder();
        final CharBuffer cb = CharBuffer.wrap(s);
        final ByteBuffer bb = ByteBuffer.allocate(StringByteUtils.estimateBufferSize(s, enc));
        bb.limit(0);
        return new InputStream(){

            private boolean checkAvailable() {
                if (!bb.hasRemaining()) {
                    bb.clear();
                    enc.encode(cb, bb, true);
                    bb.flip();
                    return bb.hasRemaining();
                }
                return true;
            }

            @Override
            public int read() throws IOException {
                if (!this.checkAvailable()) {
                    return -1;
                }
                return bb.get() & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int remaining;
                int chunk;
                if (len == 0) {
                    return 0;
                }
                if (!this.checkAvailable()) {
                    return -1;
                }
                Objects.checkFromIndexSize(off, len, b.length);
                for (remaining = len; remaining > 0 && this.checkAvailable(); remaining -= chunk) {
                    chunk = Math.min(remaining, bb.remaining());
                    bb.get(b, off, chunk);
                    off += chunk;
                }
                return len - remaining;
            }
        };
    }

    static int byteCount(String s, Charset cs) {
        if (s.isEmpty()) {
            return 0;
        }
        if (cs.equals(StandardCharsets.UTF_8)) {
            return StringByteUtils.bytesUTF8(s);
        }
        if (cs.equals(StandardCharsets.UTF_16)) {
            return StringByteUtils.bytesUTF16(s);
        }
        CharsetEncoder enc = cs.newEncoder();
        CharBuffer cb = CharBuffer.wrap(s);
        ByteBuffer bb = ByteBuffer.allocate(StringByteUtils.estimateBufferSize(s, enc));
        int size = 0;
        CoderResult state = CoderResult.OVERFLOW;
        while (state == CoderResult.OVERFLOW) {
            bb.clear();
            state = enc.encode(cb, bb, true);
            size += bb.position();
        }
        return size;
    }

    private static int bytesUTF8(String s) {
        return s.codePoints().map(c -> {
            if ((c >>>= 7) == 0) {
                return 1;
            }
            if ((c >>>= 4) == 0) {
                return 2;
            }
            if ((c >>>= 5) == 0) {
                return 3;
            }
            return 4;
        }).sum();
    }

    private static int bytesUTF16(String s) {
        return 2 + s.codePoints().map(c -> Character.isBmpCodePoint(c) ? 2 : 4).sum();
    }
}

