/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.uri.jsonrpc.messages;

import io.usethesource.vallang.ISourceLocation;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.vscode.lsp.uri.jsonrpc.messages.ISourceLocationChangeType;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class ISourceLocationChanged {
    @NonNull
    private String watchId;
    @NonNull
    private String location;
    @NonNull
    private ISourceLocationChangeType changeType;

    public ISourceLocationChanged(@NonNull String watchId, @NonNull String location, @NonNull ISourceLocationChangeType changeType) {
        this.watchId = watchId;
        this.location = location;
        this.changeType = changeType;
    }

    public ISourceLocationChangeType getChangeType() {
        return this.changeType;
    }

    public String getLocation() {
        return this.location;
    }

    public ISourceLocation getSourceLocation() {
        return Locations.toLoc(this.location);
    }

    public String getWatchId() {
        return this.watchId;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof ISourceLocationChanged) {
            ISourceLocationChanged other = (ISourceLocationChanged)obj;
            return Objects.equals(this.watchId, other.watchId) && Objects.equals(this.location, other.location) && Objects.equals((Object)this.changeType, (Object)other.changeType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.watchId, this.location, this.changeType});
    }

    public ISourceLocationWatcher.ISourceLocationChanged translate() {
        return ISourceLocationWatcher.makeChange((ISourceLocation)this.getSourceLocation(), (ISourceLocationWatcher.ISourceLocationChangeType)ISourceLocationChangeType.translate(this.changeType));
    }

    public String toString() {
        return "ISourceLocationChanged [changeType=" + String.valueOf((Object)this.changeType) + ", location=" + this.location + ", watchId=" + this.watchId + "]";
    }
}

