/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.uri.jsonrpc.messages;

import io.usethesource.vallang.ISourceLocation;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class RenameRequest {
    @NonNull
    private String from;
    @NonNull
    private String to;
    private boolean overwrite;

    public RenameRequest() {
    }

    public RenameRequest(String from, String to, boolean overwrite) {
        this.from = from;
        this.to = to;
        this.overwrite = overwrite;
    }

    public RenameRequest(ISourceLocation from, ISourceLocation to, boolean overwrite) {
        this.from = Locations.toUri(from).toString();
        this.to = Locations.toUri(to).toString();
        this.overwrite = overwrite;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RenameRequest) {
            RenameRequest other = (RenameRequest)obj;
            return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && this.overwrite == other.overwrite;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.overwrite);
    }
}

