/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class Diagnostics {
    private static final String PARSER_DIAGNOSTICS_SOURCE = "parser";
    private static final String PARSE_ERROR_MESSAGE = "The parser couldn't fully understand this code.";
    private static final Logger logger = LogManager.getLogger(Diagnostics.class);
    private static final Map<String, DiagnosticSeverity> severityMap = new HashMap<String, DiagnosticSeverity>();

    private Diagnostics() {
    }

    public static <K, V> Map<K, List<V>> groupByKey(Stream<Map.Entry<K, V>> diagnostics) {
        return diagnostics.collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toCollection(ArrayList::new))));
    }

    public static Template generateParseErrorDiagnostic(Throwable t) {
        IConstructor error;
        IValue e;
        if (t instanceof ParseError) {
            return Diagnostics.generateParseErrorDiagnostic((ParseError)t);
        }
        if (t instanceof Throw && (e = ((Throw)t).getException()) instanceof IConstructor && (error = (IConstructor)e).getName().equals(RuntimeExceptionFactory.ParseError.getName())) {
            ISourceLocation loc = (ISourceLocation)error.get(0);
            return cm -> new Diagnostic(Locations.toRange(loc, cm), PARSE_ERROR_MESSAGE, DiagnosticSeverity.Error, PARSER_DIAGNOSTICS_SOURCE);
        }
        logger.error("Parsing crashed", t);
        return cm -> new Diagnostic(new Range(new Position(0, 0), new Position(0, 1)), "Parsing failed: " + t.getMessage(), DiagnosticSeverity.Error, PARSER_DIAGNOSTICS_SOURCE);
    }

    private static Template generateParseErrorDiagnostic(ParseError e) {
        return cm -> new Diagnostic(Diagnostics.toRange(e, cm), PARSE_ERROR_MESSAGE, DiagnosticSeverity.Error, PARSER_DIAGNOSTICS_SOURCE);
    }

    public static List<Template> generateParseErrorDiagnostics(ITree errorTree) {
        IValueFactory factory = ValueFactoryFactory.getValueFactory();
        IList args = TreeAdapter.getArgs((ITree)errorTree);
        ITree skipped = (ITree)args.get(args.size() - 1);
        ISourceLocation completeErrorTreeLoc = TreeAdapter.getLocation((ITree)errorTree);
        ISourceLocation exactErrorLocation = (ISourceLocation)errorTree.asWithKeywordParameters().getParameter("parseError");
        ISourceLocation skippedLoc = TreeAdapter.getLocation((ITree)skipped);
        ISourceLocation stuckLoc = factory.sourceLocation(skippedLoc.top(), skippedLoc.getOffset(), 1, skippedLoc.getBeginLine(), skippedLoc.getBeginLine(), skippedLoc.getBeginColumn(), skippedLoc.getBeginColumn() + 1);
        ISourceLocation prefixLoc = factory.sourceLocation(completeErrorTreeLoc.top(), completeErrorTreeLoc.getOffset(), skippedLoc.getOffset() - completeErrorTreeLoc.getOffset(), completeErrorTreeLoc.getBeginLine(), skippedLoc.getBeginLine(), completeErrorTreeLoc.getBeginColumn(), skippedLoc.getBeginColumn());
        ArrayList<Template> diagnostics = new ArrayList<Template>();
        diagnostics.add(cm -> {
            Diagnostic d = new Diagnostic(Diagnostics.toRange(exactErrorLocation != null ? exactErrorLocation : stuckLoc, cm), PARSE_ERROR_MESSAGE, DiagnosticSeverity.Error, PARSER_DIAGNOSTICS_SOURCE);
            ArrayList<DiagnosticRelatedInformation> related = new ArrayList<DiagnosticRelatedInformation>();
            related.add(Diagnostics.related(cm, stuckLoc, "It is likely something is extra or missing here, or around this position."));
            related.add(Diagnostics.related(cm, skippedLoc, "This part was skipped to recover and continue parsing."));
            related.add(Diagnostics.related(cm, prefixLoc, "This part was still partially recognized."));
            d.setRelatedInformation(related);
            return d;
        });
        return diagnostics;
    }

    private static DiagnosticRelatedInformation related(ColumnMaps cm, ISourceLocation loc, String message) {
        return new DiagnosticRelatedInformation(Locations.toLSPLocation(loc, cm), message);
    }

    private static void storeFixCommands(IConstructor d, Diagnostic result) {
        IWithKeywordParameters dKW = d.asWithKeywordParameters();
        if (dKW.hasParameter("fixes")) {
            result.setData(dKW.getParameter("fixes").toString());
        }
    }

    public static Diagnostic translateDiagnostic(IConstructor d, ColumnMaps cm) {
        return Diagnostics.translateDiagnostic(d, Locations.toRange(Diagnostics.getMessageLocation(d), cm), cm);
    }

    private static DiagnosticSeverity translateSeverity(IConstructor d) {
        DiagnosticSeverity result = severityMap.get(d.getName());
        if (result == null) {
            throw new IllegalArgumentException(d.getName() + " is not a valid severity");
        }
        return result;
    }

    public static Diagnostic translateDiagnostic(IConstructor d, Range range, ColumnMaps otherFiles) {
        Diagnostic result = new Diagnostic();
        result.setSeverity(Diagnostics.translateSeverity(d));
        result.setMessage(Diagnostics.getMessageString(d));
        result.setRange(range);
        IWithKeywordParameters dKW = d.asWithKeywordParameters();
        if (dKW.hasParameter("causes")) {
            result.setRelatedInformation(((IList)dKW.getParameter("causes")).stream().map(IConstructor.class::cast).map(c -> new DiagnosticRelatedInformation(Locations.toLSPLocation(Diagnostics.getMessageLocation(c), otherFiles), Diagnostics.getMessageString(c))).collect(Collectors.toList()));
        }
        Diagnostics.storeFixCommands(d, result);
        return result;
    }

    private static Range toRange(ParseError pe, ColumnMaps cm) {
        return Diagnostics.toRange(pe.getLocation(), cm);
    }

    private static Range toRange(ISourceLocation loc, ColumnMaps cm) {
        if (loc.getBeginLine() == loc.getEndLine() && loc.getBeginColumn() == loc.getEndColumn()) {
            loc = ValueFactoryFactory.getValueFactory().sourceLocation(loc, loc.getOffset(), loc.getLength() + 1, loc.getBeginLine(), loc.getEndLine(), loc.getBeginColumn(), loc.getEndColumn() + 1);
        }
        return Locations.toRange(loc, cm);
    }

    public static Map<ISourceLocation, List<Diagnostic>> translateMessages(Map<ISourceLocation, ISet> messagesPerModule, ColumnMaps cm) {
        return messagesPerModule.entrySet().stream().filter(kv -> Diagnostics.isValidLocation((ISourceLocation)kv.getKey(), (IValue)kv.getValue())).collect(Collectors.toMap(Map.Entry::getKey, kv -> Diagnostics.translateDiagnostics((ICollection)kv.getValue(), cm)));
    }

    private static List<Diagnostic> translateDiagnostics(ICollection<?> messages, ColumnMaps cm) {
        return messages.stream().filter(IConstructor.class::isInstance).map(IConstructor.class::cast).map(d -> Diagnostics.translateDiagnostic(d, cm)).collect(Collectors.toList());
    }

    public static Map<ISourceLocation, List<Diagnostic>> translateMessages(ICollection<?> messages, ColumnMaps cm) {
        return messages.stream().filter(IConstructor.class::isInstance).map(IConstructor.class::cast).filter(Diagnostics::hasValidLocation).map(d -> Pair.of((Object)Diagnostics.getMessageLocation(d), (Object)Diagnostics.translateDiagnostic(d, cm))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
    }

    private static ISourceLocation getMessageLocation(IConstructor message) {
        return Locations.toClientLocation((ISourceLocation)message.get("at"));
    }

    private static String getMessageString(IConstructor msg) {
        return ((IString)msg.get("msg")).getValue();
    }

    private static boolean hasValidLocation(IConstructor d) {
        return Diagnostics.isValidLocation(Diagnostics.getMessageLocation(d), (IValue)d);
    }

    private static boolean isValidLocation(ISourceLocation loc, IValue m) {
        if (loc == null || loc.getScheme().equals("unknown")) {
            logger.trace("Dropping diagnostic due to incorrect location on message: {}", (Object)m);
            return false;
        }
        if (loc.getPath().endsWith(".rsc")) {
            return true;
        }
        if (loc.getPath().endsWith("/RASCAL.MF")) {
            return true;
        }
        if (loc.getPath().endsWith("/pom.xml")) {
            return true;
        }
        logger.error("Filtering diagnostic as it's an unsupported file to report diagnostics on: {}", (Object)m);
        return false;
    }

    static {
        severityMap.put("error", DiagnosticSeverity.Error);
        severityMap.put("warning", DiagnosticSeverity.Warning);
        severityMap.put("info", DiagnosticSeverity.Information);
    }

    @FunctionalInterface
    public static interface Template {
        public Diagnostic instantiate(ColumnMaps var1);
    }
}

