/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.AnnotatedTextEdit;
import org.eclipse.lsp4j.ChangeAnnotation;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class DocumentChanges {
    private DocumentChanges() {
    }

    public static WorkspaceEdit translateDocumentChanges(IList list, ColumnMaps columns) {
        ArrayList<Either<TextDocumentEdit, ResourceOperation>> result = new ArrayList<Either<TextDocumentEdit, ResourceOperation>>(list.size());
        HashMap<String, ChangeAnnotation> changeAnnotations = new HashMap<String, ChangeAnnotation>();
        for (IValue elem : list) {
            IConstructor edit = (IConstructor)elem;
            String anno = DocumentChanges.extractAnnotation(edit, changeAnnotations);
            switch (edit.getName()) {
                case "removed": {
                    DeleteFile delete = new DeleteFile(DocumentChanges.getFileURI(edit, "file"));
                    delete.setAnnotationId(anno);
                    result.add(Either.forRight(delete));
                    break;
                }
                case "created": {
                    CreateFile create = new CreateFile(DocumentChanges.getFileURI(edit, "file"));
                    create.setAnnotationId(anno);
                    result.add(Either.forRight(create));
                    break;
                }
                case "renamed": {
                    RenameFile rename = new RenameFile(DocumentChanges.getFileURI(edit, "from"), DocumentChanges.getFileURI(edit, "to"));
                    rename.setAnnotationId(anno);
                    result.add(Either.forRight(rename));
                    break;
                }
                case "changed": {
                    result.add(Either.forLeft(new TextDocumentEdit(new VersionedTextDocumentIdentifier(DocumentChanges.getFileURI(edit, "file"), null), DocumentChanges.translateTextEdits((IList)edit.get("edits"), anno, columns, changeAnnotations))));
                }
            }
        }
        WorkspaceEdit wsEdit = new WorkspaceEdit(result);
        wsEdit.setChangeAnnotations(changeAnnotations);
        return wsEdit;
    }

    private static boolean hasAnnotation(IWithKeywordParameters<? extends IConstructor> cons) {
        return cons.hasParameter("label") || cons.hasParameter("description") || cons.hasParameter("needsConfirmation");
    }

    private static @Nullable String extractAnnotation(IConstructor cons, Map<String, ChangeAnnotation> changeAnnotations) {
        IWithKeywordParameters kws = cons.asWithKeywordParameters();
        if (!DocumentChanges.hasAnnotation((IWithKeywordParameters<? extends IConstructor>)kws)) {
            return null;
        }
        String label = kws.hasParameter("label") ? ((IString)kws.getParameter("label")).getValue() : "";
        String description = kws.hasParameter("description") ? ((IString)kws.getParameter("description")).getValue() : label;
        boolean needsConfirmation = kws.hasParameter("needsConfirmation") && ((IBool)kws.getParameter("needsConfirmation")).getValue();
        String key = String.format("%s_%s_%b", label, description, needsConfirmation);
        changeAnnotations.computeIfAbsent(key, k -> {
            ChangeAnnotation anno = new ChangeAnnotation(label);
            anno.setDescription(description);
            anno.setNeedsConfirmation(needsConfirmation);
            return anno;
        });
        return key;
    }

    private static List<TextEdit> translateTextEdits(IList edits, @Nullable String parentAnno, ColumnMaps columns, Map<String, ChangeAnnotation> changeAnnotations) {
        return edits.stream().map(IConstructor.class::cast).map(c -> {
            Range range = Locations.toRange((ISourceLocation)c.get("range"), columns);
            String replacement = ((IString)c.get("replacement")).getValue();
            String anno = DocumentChanges.extractAnnotation(c, changeAnnotations);
            if (anno == null) {
                anno = parentAnno;
            }
            if (anno != null) {
                return new AnnotatedTextEdit(range, replacement, anno);
            }
            return new TextEdit(range, replacement);
        }).collect(Collectors.toList());
    }

    private static String getFileURI(IConstructor edit, String label) {
        return Locations.toUri(Locations.toClientLocation((ISourceLocation)edit.get(label))).toString();
    }
}

