/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.rascalmpl.util.locations.LineColumnOffsetMap;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class DocumentSymbols {
    private static final IRascalValueFactory VF = IRascalValueFactory.getInstance();
    private static final TypeFactory TF = TypeFactory.getInstance();
    private static final TypeStore store = new TypeStore(new TypeStore[0]);
    private static final Type symbolKindAdt = TF.abstractDataType(store, "DocumentSymbolKind", new Type[0]);
    private static final Type symbolTagAdt = TF.abstractDataType(store, "DocumentSymbolTag", new Type[0]);

    private DocumentSymbols() {
    }

    private static String capitalize(String kindName) {
        return kindName.substring(0, 1).toUpperCase() + kindName.substring(1);
    }

    public static List<Either<SymbolInformation, DocumentSymbol>> toLSP(IList symbols, LineColumnOffsetMap om) {
        return symbols.stream().map(s -> DocumentSymbols.toLSP((IConstructor)s, om)).map(Either::forRight).collect(Collectors.toList());
    }

    public static DocumentSymbol toLSP(IConstructor symbol, LineColumnOffsetMap om) {
        IWithKeywordParameters kwp = symbol.asWithKeywordParameters();
        List<DocumentSymbol> children = kwp.hasParameter("children") ? ((IList)kwp.getParameter("children")).stream().map(c -> DocumentSymbols.toLSP((IConstructor)c, om)).collect(Collectors.toList()) : Collections.emptyList();
        SymbolKind kind = DocumentSymbols.symbolKindToLSP((IConstructor)symbol.get("kind"));
        String symbolName = ((IString)symbol.get("name")).getValue();
        Range range = Locations.toRange((ISourceLocation)symbol.get("range"), om);
        Range selection = kwp.hasParameter("selection") ? Locations.toRange((ISourceLocation)kwp.getParameter("selection"), om) : range;
        String detail = kwp.hasParameter("detail") ? ((IString)kwp.getParameter("detail")).getValue() : null;
        List<SymbolTag> tags = kwp.hasParameter("tags") ? DocumentSymbols.symbolTagsToLSP((ISet)kwp.getParameter("tags")) : Collections.emptyList();
        DocumentSymbol lspSymbol = new DocumentSymbol(symbolName, kind, range, selection, detail, children);
        lspSymbol.setTags(tags);
        return lspSymbol;
    }

    public static SymbolKind symbolKindToLSP(IConstructor kind) {
        return SymbolKind.valueOf(DocumentSymbols.capitalize(kind.getName()));
    }

    public static IConstructor symbolKindToRascal(SymbolKind kind) {
        return VF.constructor(TF.constructor(store, symbolKindAdt, kind.name().toLowerCase(), new Type[0]));
    }

    public static List<SymbolTag> symbolTagsToLSP(@Nullable ISet tags) {
        if (tags == null) {
            return Collections.emptyList();
        }
        return tags.stream().map(IConstructor.class::cast).map(INode::getName).map(DocumentSymbols::capitalize).map(SymbolTag::valueOf).collect(Collectors.toList());
    }

    public static ISet symbolTagsToRascal(@Nullable List<SymbolTag> tags) {
        if (tags == null) {
            return VF.set(new IValue[0]);
        }
        return (ISet)tags.stream().map(t -> VF.constructor(TF.constructor(store, symbolTagAdt, t.name().toLowerCase(), new Type[0]))).collect(VF.setWriter());
    }

    public static Type getSymbolKindType() {
        return symbolKindAdt;
    }

    public static TypeStore getStore() {
        return store;
    }
}

