/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadPool {
    private NamedThreadPool() {
    }

    public static ExecutorService single(String name) {
        return Executors.newSingleThreadExecutor(NamedThreadPool.factory(name, false));
    }

    public static ExecutorService cached(String name) {
        return Executors.newCachedThreadPool(NamedThreadPool.factory(name, false));
    }

    public static ExecutorService cachedDaemon(String name) {
        return Executors.newCachedThreadPool(NamedThreadPool.factory(name, true));
    }

    private static ThreadFactory factory(String name, boolean daemon) {
        AtomicInteger counter = new AtomicInteger(0);
        ThreadGroup group = new ThreadGroup(name);
        return r -> {
            Thread t = new Thread(group, r, name + "-" + counter.incrementAndGet());
            t.setDaemon(daemon);
            return t;
        };
    }
}

