/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SelectionRange;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;
import org.rascalmpl.vscode.lsp.util.locations.Locations;

public class SelectionRanges {
    private SelectionRanges() {
    }

    public static SelectionRange toSelectionRange(Position origin, IList ranges, ColumnMaps columns) {
        if (ranges.isEmpty()) {
            return SelectionRanges.empty(origin);
        }
        try {
            List<Range> lspRanges = ranges.stream().map(ISourceLocation.class::cast).map(l -> Locations.toRange(l, columns)).collect(Collectors.toList());
            return SelectionRanges.toSelectionRange(origin, lspRanges);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("List of selection ranges should only contain source locations", e);
        }
    }

    public static SelectionRange toSelectionRange(Position origin, List<Range> ranges) {
        if (ranges.isEmpty()) {
            return SelectionRanges.empty(origin);
        }
        Iterator<Range> reversed = SelectionRanges.reverse(ranges).iterator();
        SelectionRange selectionRange = new SelectionRange(reversed.next(), null);
        while (reversed.hasNext()) {
            selectionRange = new SelectionRange(reversed.next(), selectionRange);
        }
        return selectionRange;
    }

    private static <T> Iterable<T> reverse(final List<T> list) {
        return () -> new Iterator<T>(){
            int current;
            {
                this.current = list.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.current >= 0;
            }

            @Override
            public T next() {
                try {
                    return list.get(this.current--);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }
        };
    }

    public static IList uniqueTreeLocations(IList trees) {
        return (IList)trees.stream().filter(Objects::nonNull).filter(ITree.class::isInstance).map(ITree.class::cast).map(TreeAdapter::getLocation).distinct().collect(IRascalValueFactory.getInstance().listWriter());
    }

    public static SelectionRange empty(Position p) {
        return new SelectionRange(new Range(p, p), null);
    }
}

