/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util;

import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.PolyNull;

public class Versioned<T> {
    private final int version;
    private final T object;
    private final long timestamp;

    public Versioned(int version, T object) {
        this(version, object, System.currentTimeMillis());
    }

    public Versioned(int version, T object, long timestamp) {
        this.version = version;
        this.object = object;
        this.timestamp = timestamp;
    }

    public int version() {
        return this.version;
    }

    public T get() {
        return this.object;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.format("%s [version %d]", this.object, this.version);
    }

    public static <T> AtomicReference<Versioned<T>> atomic(int version, T object) {
        return new AtomicReference<Versioned<T>>(new Versioned<T>(version, object));
    }

    public static <T> boolean replaceIfNewer(AtomicReference<@PolyNull Versioned<T>> current, Versioned<T> maybeNewer) {
        Versioned<T> old;
        while ((old = current.get()) == null || old.version() < maybeNewer.version()) {
            if (!current.compareAndSet(old, maybeNewer)) continue;
            return true;
        }
        return false;
    }
}

