/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util.locations;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.util.locations.LineColumnOffsetMap;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.vscode.lsp.uri.LSPOpenFileResolver;

public class Locations {
    private static final Logger logger = LogManager.getLogger(Locations.class);
    private static final IRascalValueFactory VF = IRascalValueFactory.getInstance();
    private static final String OPAQUE_SCHEME = "opaque-lsp-";

    public static ISourceLocation toClientLocation(ISourceLocation loc) {
        if ((loc = LSPOpenFileResolver.stripLspPrefix(loc)).getScheme().equals("project")) {
            return Locations.toPhysicalIfPossible(loc);
        }
        return loc;
    }

    public static ISourceLocation toPhysicalIfPossible(ISourceLocation loc) {
        try {
            ISourceLocation physical = URIResolverRegistry.getInstance().logicalToPhysical(loc);
            if (physical == null) {
                return loc;
            }
            return physical;
        }
        catch (IOException e) {
            return loc;
        }
    }

    public static ISourceLocation toLoc(TextDocumentItem doc) {
        return Locations.toLoc(doc.getUri());
    }

    public static ISourceLocation toLoc(TextDocumentIdentifier doc) {
        return Locations.toLoc(doc.getUri());
    }

    public static Range toRascalRange(TextDocumentIdentifier doc, Range range, ColumnMaps columns) {
        return Locations.toRascalRange(Locations.toLoc(doc), range, columns);
    }

    public static Range toRascalRange(ISourceLocation loc, Range range, ColumnMaps columns) {
        return new Range(Locations.toRascalPosition(loc, range.getStart(), columns), Locations.toRascalPosition(loc, range.getEnd(), columns));
    }

    public static Position toRascalPosition(TextDocumentIdentifier doc, Position pos, ColumnMaps columns) {
        ISourceLocation loc = Locations.toLoc(doc.getUri());
        return Locations.toRascalPosition(loc, pos, columns);
    }

    public static Position toRascalPosition(ISourceLocation doc, Position pos, ColumnMaps columns) {
        return new Position(pos.getLine() + 1, columns.get(doc).translateInverseColumn(pos.getLine(), pos.getCharacter(), false));
    }

    public static ISourceLocation toLoc(String uri) {
        return Locations.toLoc(URI.create(uri));
    }

    public static ISourceLocation toCheckedLoc(String uri) throws URISyntaxException {
        return Locations.toLoc(new URI(uri));
    }

    public static ISourceLocation toLoc(URI uri) {
        if (uri.isOpaque()) {
            try {
                uri = new URI(OPAQUE_SCHEME, uri.getScheme(), "/" + uri.getSchemeSpecificPart(), null, uri.getFragment());
            }
            catch (URISyntaxException e) {
                logger.error("Cannot convert opaque URI: {}", (Object)uri, (Object)e);
                return VF.sourceLocation(uri);
            }
        }
        return VF.sourceLocation(URI.create(uri.toASCIIString()));
    }

    public static URI toUri(ISourceLocation loc) {
        URI uri = loc.getURI();
        if (OPAQUE_SCHEME.equals(uri.getScheme())) {
            try {
                return new URI(uri.getAuthority(), uri.getPath().substring(1), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return uri;
    }

    public static Location mapValueToLocation(IValue v, ColumnMaps cm) {
        if (v instanceof ISourceLocation) {
            return Locations.toLSPLocation((ISourceLocation)v, cm);
        }
        throw new RuntimeException(String.valueOf(v) + "is not a ISourceLocation");
    }

    public static Location toLSPLocation(ISourceLocation sloc, ColumnMaps cm) {
        return new Location(Locations.toUri(sloc).toString(), Locations.toRange(sloc, cm));
    }

    public static Location toLSPLocation(ISourceLocation sloc, LineColumnOffsetMap map) {
        return new Location(Locations.toUri(sloc).toString(), Locations.toRange(sloc, map));
    }

    public static Range toRange(ISourceLocation sloc, ColumnMaps cm) {
        return Locations.toRange(sloc, cm.get(sloc));
    }

    public static Range toRange(ISourceLocation sloc, LineColumnOffsetMap map) {
        if (sloc.hasLineColumn()) {
            return new Range(Locations.toPosition(sloc, map, false), Locations.toPosition(sloc, map, true));
        }
        return new Range(new Position(0, 0), new Position(0, 0));
    }

    public static ISourceLocation setRange(ISourceLocation loc, Range lspRange, ColumnMaps columns) {
        LineColumnOffsetMap map = columns.get(loc);
        Position lspStart = lspRange.getStart();
        Position lspEnd = lspRange.getEnd();
        Pair offsetLength = map.calculateInverseOffsetLength(lspStart.getLine(), lspStart.getCharacter(), lspEnd.getLine(), lspEnd.getCharacter());
        Position rascalStart = Locations.toRascalPosition(loc, lspStart, columns);
        Position rascalEnd = Locations.toRascalPosition(loc, lspEnd, columns);
        return VF.sourceLocation(loc, ((Integer)offsetLength.getLeft()).intValue(), ((Integer)offsetLength.getRight()).intValue(), rascalStart.getLine(), rascalEnd.getLine(), rascalStart.getCharacter(), rascalEnd.getCharacter());
    }

    public static Position toPosition(ISourceLocation loc, ColumnMaps cm) {
        return Locations.toPosition(loc, cm, false);
    }

    public static Position toPosition(ISourceLocation loc, ColumnMaps cm, boolean atEnd) {
        return Locations.toPosition(loc, cm.get(loc), atEnd);
    }

    public static Position toPosition(ISourceLocation loc, LineColumnOffsetMap map, boolean atEnd) {
        int line = atEnd ? loc.getEndLine() : loc.getBeginLine();
        int column = atEnd ? loc.getEndColumn() : loc.getBeginColumn();
        return new Position(--line, map.translateColumn(line, column, atEnd));
    }
}

