/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.vscode.lsp.util.locations.impl;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.util.Iterator;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class TreeSearch {
    private TreeSearch() {
    }

    private static boolean inside(ISourceLocation loc, int line, int column) {
        if (!loc.hasLineColumn()) {
            return false;
        }
        if (line < loc.getBeginLine() || line > loc.getEndLine()) {
            return false;
        }
        if (line == loc.getBeginLine()) {
            if (line < loc.getEndLine()) {
                return loc.getBeginColumn() <= column;
            }
            assert (line == loc.getEndLine());
            return loc.getBeginColumn() <= column && column <= loc.getEndColumn();
        }
        if (line == loc.getEndLine()) {
            return column <= loc.getEndColumn();
        }
        return true;
    }

    public static IList computeFocusList(ITree tree, int line, int column) {
        IListWriter lw = IRascalValueFactory.getInstance().listWriter();
        TreeSearch.computeFocusList(lw, tree, line, column);
        return (IList)lw.done();
    }

    private static boolean computeFocusList(IListWriter focus, ITree tree, int line, int column) {
        ISourceLocation l = TreeAdapter.getLocation((ITree)tree);
        if (l == null) {
            return false;
        }
        if (TreeAdapter.isLexical((ITree)tree)) {
            if (TreeSearch.inside(l, line, column)) {
                focus.append(new IValue[]{tree});
                return true;
            }
            return false;
        }
        if (TreeAdapter.isAmb((ITree)tree) && !tree.getAlternatives().isEmpty()) {
            return TreeSearch.computeFocusList(focus, (ITree)tree.getAlternatives().iterator().next(), line, column);
        }
        if (TreeAdapter.isAppl((ITree)tree)) {
            boolean result;
            IValue child;
            ISourceLocation childLoc;
            IList children = TreeAdapter.getASTArgs((ITree)tree);
            Iterator iterator = children.iterator();
            while (!(!iterator.hasNext() || (childLoc = TreeAdapter.getLocation((ITree)((ITree)(child = (IValue)iterator.next())))) != null && TreeSearch.inside(childLoc, line, column) && (result = TreeSearch.computeFocusList(focus, (ITree)child, line, column)))) {
            }
            if (TreeSearch.inside(l, line, column)) {
                focus.append(new IValue[]{tree});
                return true;
            }
        }
        return false;
    }
}

