/*
 * Decompiled with CFR 0.152.
 */
package analysis.text.search;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.io.StandardTextReader;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TokenGroup;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.util.BytesRef;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.functions.IFunction;

public class LuceneAdapter {
    private static final String SRC_FIELD_NAME = "src";
    private static final String ID_FIELD_NAME = "$id$";
    private static final FieldType SOURCELOCATION_TYPE = LuceneAdapter.makeSourceLocationType();
    private final IValueFactory vf;
    private final TypeFactory tf = TypeFactory.getInstance();
    private final Map<ISourceLocation, SingleInstanceLockFactory> lockFactories;
    private final TypeStore store = new TypeStore(new TypeStore[0]);
    private final Type Document = this.tf.abstractDataType(this.store, "Document", new Type[0]);
    private final Type docCons = this.tf.constructor(this.store, this.Document, "document", new Object[]{this.tf.sourceLocationType(), "src"});
    private final Type Term = this.tf.abstractDataType(this.store, "Term", new Type[0]);
    private final Type termCons = this.tf.constructor(this.store, this.Term, "term", new Object[]{this.tf.stringType(), "chars", this.tf.sourceLocationType(), "src", this.tf.stringType(), "kind"});
    private final StandardTextReader valueParser = new StandardTextReader();

    public LuceneAdapter(IValueFactory vf) {
        this.vf = vf;
        this.lockFactories = new HashMap<ISourceLocation, SingleInstanceLockFactory>();
    }

    public void createIndex(ISourceLocation indexFolder, ISet documents, IConstructor analyzer, IString charset, IBool inferCharset) {
        try {
            IndexWriterConfig config = new IndexWriterConfig(this.makeAnalyzer(analyzer));
            SingleInstanceLockFactory lockFactory = this.makeLockFactory(indexFolder);
            Directory dir = this.makeDirectory(indexFolder, lockFactory);
            try (IndexWriter index = new IndexWriter(dir, config);){
                for (IValue elem : documents) {
                    index.addDocument((Iterable)this.makeDocument((IConstructor)elem, charset, inferCharset));
                }
                index.commit();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("HALLO: " + String.valueOf(e));
            throw RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()), null, null);
        }
    }

    public ISet listTerms(ISourceLocation indexFolder, IString fieldName, IInteger max) {
        try {
            DirectoryReader reader = this.makeReader(indexFolder);
            ISetWriter result = this.vf.setWriter();
            Fields fields = MultiFields.getFields((IndexReader)reader);
            for (String label : fields) {
                BytesRef bytes;
                Terms terms;
                if (!label.equals(fieldName.getValue()) || (terms = fields.terms(label)) == null) continue;
                TermsEnum list = terms.iterator();
                int countDown = max.intValue();
                while ((bytes = list.next()) != null && countDown-- > 0) {
                    IString val = this.vf.string(bytes.utf8ToString());
                    IInteger freq = this.vf.integer(reader.totalTermFreq(new Term(label, bytes)));
                    result.insert(new IValue[]{this.vf.tuple(new IValue[]{val, freq})});
                }
            }
            return (ISet)result.done();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()), null, null);
        }
    }

    public ISet listFields(ISourceLocation indexFolder) {
        try {
            DirectoryReader reader = this.makeReader(indexFolder);
            ISetWriter result = this.vf.setWriter();
            for (LeafReaderContext subReader : reader.leaves()) {
                LeafReader sub = subReader.reader();
                for (FieldInfo field : sub.getFieldInfos()) {
                    IString name = this.vf.string(field.name);
                    IInteger docCount = this.vf.integer(sub.getDocCount(field.name));
                    IInteger termCount = this.vf.integer(sub.getSumTotalTermFreq(field.name));
                    result.insert(new IValue[]{this.vf.tuple(new IValue[]{name, docCount, termCount})});
                }
            }
            return (ISet)result.done();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()), null, null);
        }
    }

    private Directory makeDirectory(ISourceLocation indexFolder, SingleInstanceLockFactory lockFactory) throws IOException {
        return new SourceLocationDirectory(this.vf, (LockFactory)lockFactory, indexFolder);
    }

    public IList searchDocument(final ISourceLocation doc, IString query, IConstructor analyzer, IInteger max, IString charset, IBool inferCharset) {
        IList iList;
        block11: {
            String entireDocument = Prelude.readFile((IValueFactory)this.vf, (boolean)false, (ISourceLocation)doc, (String)charset.getValue(), (boolean)inferCharset.getValue()).getValue();
            Reader reader = URIResolverRegistry.getInstance().getCharacterReader(doc, charset.getValue());
            try {
                TokenStream tokenStream = this.makeAnalyzer(analyzer).tokenStream(SRC_FIELD_NAME, reader);
                MultiFieldQueryParser parser = this.makeQueryParser(analyzer);
                Query queryExpression = parser.parse(query.getValue());
                QueryScorer scorer = new QueryScorer(queryExpression);
                final IListWriter result = this.vf.listWriter();
                Formatter formatter = new Formatter(){

                    public String highlightTerm(String originalText, TokenGroup tokenGroup) {
                        if (tokenGroup.getScore(tokenGroup.getNumTokens() - 1) > 0.0f) {
                            int startOffset = tokenGroup.getStartOffset();
                            int endOffset = tokenGroup.getEndOffset();
                            result.append(new IValue[]{LuceneAdapter.this.vf.sourceLocation(doc, startOffset, endOffset - startOffset)});
                        }
                        return tokenGroup.toString();
                    }
                };
                new Highlighter(formatter, (Scorer)scorer).getBestFragments(tokenStream, entireDocument, max.intValue());
                iList = (IList)result.done();
                if (reader == null) break block11;
            }
            catch (Throwable tokenStream) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            tokenStream.addSuppressed(throwable);
                        }
                    }
                    throw tokenStream;
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()), null, null);
                }
                catch (ParseException e) {
                    int beginLine = e.currentToken.next.beginLine;
                    int beginColumn = e.currentToken.next.beginColumn;
                    throw RuntimeExceptionFactory.parseError((ISourceLocation)this.vf.sourceLocation(doc, beginLine, beginColumn));
                }
                catch (ArithmeticException e) {
                    throw RuntimeExceptionFactory.arithmeticException((String)e.getMessage(), null, null);
                }
                catch (InvalidTokenOffsetsException e) {
                    e.printStackTrace();
                    return this.vf.list(new IValue[0]);
                }
            }
            reader.close();
        }
        return iList;
    }

    public IList analyzeDocument(IString doc, IConstructor analyzer) {
        return this.analyzeDocument(URIUtil.rootLocation((String)"string"), new StringReader(doc.getValue()), analyzer);
    }

    public IList analyzeDocument(ISourceLocation doc, IConstructor analyzer) {
        IList iList;
        block8: {
            Reader reader = URIResolverRegistry.getInstance().getCharacterReader(doc);
            try {
                iList = this.analyzeDocument(doc, reader, analyzer);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()), null, null);
                }
            }
            reader.close();
        }
        return iList;
    }

    private IList analyzeDocument(ISourceLocation src, Reader doc, IConstructor analyzer) {
        try {
            Analyzer theAnalyzer = this.makeAnalyzer(analyzer);
            TokenStream tokenStream = theAnalyzer.tokenStream(SRC_FIELD_NAME, doc);
            OffsetAttribute offsetAttribute = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
            CharTermAttribute termAtt = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            TypeAttribute typeAtt = (TypeAttribute)tokenStream.addAttribute(TypeAttribute.class);
            IListWriter result = this.vf.listWriter();
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                int startOffset = offsetAttribute.startOffset();
                result.append(new IValue[]{this.vf.constructor(this.termCons, new IValue[]{this.vf.string(termAtt.toString()), this.vf.sourceLocation(src, startOffset, termAtt.length()), this.vf.string(typeAtt.type())})});
            }
            return (IList)result.done();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()), null, null);
        }
    }

    public ISet searchIndex(ISourceLocation indexFolder, IString query, IConstructor analyzer, IInteger max) {
        try {
            IndexSearcher searcher = this.makeSearcher(indexFolder);
            MultiFieldQueryParser parser = this.makeQueryParser(analyzer);
            Query queryExpression = parser.parse(query.getValue());
            TopDocs docs = searcher.search(queryExpression, max.intValue());
            ISetWriter result = this.vf.setWriter();
            for (ScoreDoc doc : docs.scoreDocs) {
                Document found = searcher.doc(doc.doc);
                String loc = found.get(ID_FIELD_NAME);
                ISourceLocation sloc = this.parseLocation(loc);
                if (loc == null) continue;
                IConstructor node = this.vf.constructor(this.docCons, new IValue[]{sloc});
                HashMap<String, IReal> params = new HashMap<String, IReal>();
                params.put("score", this.vf.real((double)doc.score));
                found.forEach(f -> {
                    String value = f.stringValue();
                    String name = f.name();
                    if (value != null && !name.equals(ID_FIELD_NAME)) {
                        params.put(name, (IReal)this.vf.string(value));
                    }
                });
                result.insert(new IValue[]{node.asWithKeywordParameters().setParameters(params)});
            }
            return (ISet)result.done();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io((IString)this.vf.string(e.getMessage()), null, null);
        }
        catch (ParseException e) {
            int beginLine = e.currentToken.next.beginLine;
            int beginColumn = e.currentToken.next.beginColumn;
            throw RuntimeExceptionFactory.parseError((ISourceLocation)this.vf.sourceLocation(indexFolder, beginLine, beginColumn));
        }
    }

    private ISourceLocation parseLocation(String loc) throws IOException {
        return (ISourceLocation)this.valueParser.read(this.vf, (Reader)new StringReader(loc));
    }

    private IndexSearcher makeSearcher(ISourceLocation indexFolder) throws IOException {
        DirectoryReader reader = this.makeReader(indexFolder);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        return searcher;
    }

    private DirectoryReader makeReader(ISourceLocation indexFolder) throws IOException {
        SingleInstanceLockFactory lockFactory = this.makeLockFactory(indexFolder);
        Directory dir = this.makeDirectory(indexFolder, lockFactory);
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        return reader;
    }

    private MultiFieldQueryParser makeQueryParser(IConstructor analyzer) throws IOException {
        Set<String> labels = this.analyzerFields(analyzer);
        Analyzer a = this.makeAnalyzer(analyzer);
        return new MultiFieldQueryParser(labels.toArray(new String[labels.size()]), a);
    }

    private SingleInstanceLockFactory makeLockFactory(ISourceLocation indexFolder) {
        SingleInstanceLockFactory lockFactory = this.lockFactories.get(indexFolder);
        if (lockFactory == null) {
            lockFactory = new SingleInstanceLockFactory();
            this.lockFactories.put(indexFolder, lockFactory);
        }
        return lockFactory;
    }

    private Set<String> analyzerFields(IConstructor node) {
        HashSet<String> result = new HashSet<String>();
        result.add(ID_FIELD_NAME);
        result.add(SRC_FIELD_NAME);
        if (node.getName().equals("fieldsAnalyzer")) {
            result.addAll(node.asWithKeywordParameters().getParameterNames());
        }
        return result;
    }

    private Analyzer makeAnalyzer(IConstructor node) throws IOException {
        switch (node.getName()) {
            case "analyzerClass": {
                return this.analyzerFromClass(((IString)node.get("analyzerClassName")).getValue());
            }
            case "analyzer": {
                return this.makeFunctionAnalyzer((IConstructor)node.get("tokenizer"), (IList)node.get("pipe"));
            }
            case "fieldsAnalyzer": {
                return this.makeFieldAnalyzer((IConstructor)node.get(SRC_FIELD_NAME), node.asWithKeywordParameters().getParameters());
            }
        }
        return new StandardAnalyzer();
    }

    private Analyzer makeFieldAnalyzer(IConstructor src, Map<String, IValue> analyzers) throws IOException {
        return new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(), this.makeFieldAnalyzers(src, analyzers));
    }

    private Map<String, Analyzer> makeFieldAnalyzers(IConstructor src, Map<String, IValue> analyzers) throws IOException {
        HashMap<String, Analyzer> analyzerMap = new HashMap<String, Analyzer>();
        analyzerMap.put(ID_FIELD_NAME, (Analyzer)new KeywordAnalyzer());
        analyzerMap.put(SRC_FIELD_NAME, this.makeAnalyzer(src));
        for (String label : analyzers.keySet()) {
            analyzerMap.put(label, this.makeAnalyzer((IConstructor)analyzers.get(label)));
        }
        return analyzerMap;
    }

    private Analyzer makeFunctionAnalyzer(IConstructor tokenizer, IList filters) throws IOException {
        Tokenizer tokens;
        Tokenizer stream = tokens = this.makeTokenizer(tokenizer);
        for (IValue elem : filters) {
            stream = this.makeFilter((TokenStream)stream, (IConstructor)elem);
        }
        Tokenizer filtered = stream;
        return new Analyzer((TokenStream)filtered){
            final /* synthetic */ TokenStream val$filtered;
            {
                this.val$filtered = tokenStream;
            }

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents(tokens, this.val$filtered);
            }
        };
    }

    private TokenStream makeFilter(TokenStream stream, IConstructor node) {
        switch (node.getName()) {
            case "filterClass": {
                return this.filterFromClass(stream, ((IString)node.get("filterClassName")).getValue());
            }
            case "editFilter": {
                return this.makeEditFilter(stream, (IFunction)node.get("editor"));
            }
            case "removeFilter": {
                return this.makeRemoveFilter(stream, (IFunction)node.get("accept"));
            }
            case "splitFilter": {
                return this.makeSplitFilter(stream, (IFunction)node.get("splitter"));
            }
            case "synonymFilter": {
                return this.makeSynonymFilter(stream, (IFunction)node.get("generator"));
            }
            case "tagFilter": {
                return this.makeTagFilter(stream, (IFunction)node.get("generator"));
            }
        }
        throw new IllegalArgumentException();
    }

    private TokenStream makeEditFilter(TokenStream stream, final IFunction function) {
        return new TokenFilter(stream){
            private final CharTermAttribute termAtt;
            {
                super(input);
                this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            }

            public boolean incrementToken() throws IOException {
                if (this.input.incrementToken()) {
                    IString token = LuceneAdapter.this.vf.string(new String(this.termAtt.buffer(), 0, this.termAtt.length()));
                    try {
                        IString result = (IString)function.call(new IValue[]{token});
                        if (result.length() == 0) {
                            this.termAtt.setEmpty();
                        } else {
                            char[] chars = result.getValue().toCharArray();
                            this.termAtt.copyBuffer(chars, 0, chars.length);
                        }
                    }
                    catch (MatchFailed matchFailed) {
                        // empty catch block
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private TokenStream makeTagFilter(TokenStream stream, final IFunction function) {
        return new TokenFilter(stream){
            private final CharTermAttribute termAtt;
            private final TypeAttribute typeAtt;
            {
                super(input);
                this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
            }

            public boolean incrementToken() throws IOException {
                if (this.input.incrementToken()) {
                    IString token = LuceneAdapter.this.vf.string(new String(this.termAtt.buffer(), 0, this.termAtt.length()));
                    IString tag = LuceneAdapter.this.vf.string(this.typeAtt.type());
                    try {
                        IString result = (IString)function.call(new IValue[]{token, tag});
                        if (result.length() != 0) {
                            this.typeAtt.setType(result.getValue());
                        }
                    }
                    catch (Throw throw_) {
                        // empty catch block
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private TokenStream makeRemoveFilter(TokenStream stream, final IFunction function) {
        return new FilteringTokenFilter(stream){
            private final CharTermAttribute termAtt;
            {
                super(in);
                this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            }

            protected boolean accept() throws IOException {
                IString token = LuceneAdapter.this.vf.string(new String(this.termAtt.buffer(), 0, this.termAtt.length()));
                try {
                    IBool result = (IBool)function.call(new IValue[]{token});
                    return result.getValue();
                }
                catch (MatchFailed e) {
                    return true;
                }
            }
        };
    }

    private TokenStream makeSplitFilter(TokenStream stream, final IFunction function) {
        return new TokenFilter(stream){
            private final CharTermAttribute termAtt;
            private PositionIncrementAttribute posAttr;
            private OffsetAttribute offsetAttr;
            private int offset;
            private IList backLog;
            {
                super(input);
                this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                this.posAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
                this.offsetAttr = (OffsetAttribute)this.getAttribute(OffsetAttribute.class);
                this.offset = 0;
            }

            public boolean incrementToken() throws IOException {
                if (this.backLog != null && !this.backLog.isEmpty()) {
                    this.popOneTerm(1);
                    return true;
                }
                if (this.input.incrementToken()) {
                    IString token = LuceneAdapter.this.vf.string(new String(this.termAtt.buffer(), 0, this.termAtt.length()));
                    try {
                        this.backLog = (IList)function.call(new IValue[]{token});
                        if (this.backLog.length() <= 0) {
                            return true;
                        }
                        this.offset = this.offsetAttr.startOffset();
                        this.popOneTerm(1);
                    }
                    catch (Throw e) {
                        return true;
                    }
                    return true;
                }
                return false;
            }

            private void popOneTerm(int distance) {
                IString newTerm = (IString)this.backLog.get(0);
                this.backLog = this.backLog.delete(0);
                char[] charArray = newTerm.getValue().toCharArray();
                int len = charArray.length;
                this.termAtt.resizeBuffer(len);
                this.termAtt.copyBuffer(charArray, 0, len);
                this.offsetAttr.setOffset(this.offset, len + this.offset);
                this.offset += len;
                this.posAttr.setPositionIncrement(distance);
            }
        };
    }

    private TokenStream makeSynonymFilter(TokenStream stream, final IFunction function) {
        return new TokenFilter(stream){
            private final CharTermAttribute termAtt;
            private PositionIncrementAttribute posAttr;
            private IList backLog;
            {
                super(input);
                this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                this.posAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
            }

            public boolean incrementToken() throws IOException {
                if (this.backLog != null && !this.backLog.isEmpty()) {
                    this.popOneTerm(0);
                    return true;
                }
                if (this.input.incrementToken()) {
                    IString token = LuceneAdapter.this.vf.string(new String(this.termAtt.buffer(), 0, this.termAtt.length()));
                    try {
                        this.backLog = (IList)function.call(new IValue[]{token});
                        if (this.backLog.length() <= 0) {
                            return true;
                        }
                        this.popOneTerm(1);
                    }
                    catch (Throw e) {
                        return true;
                    }
                    return true;
                }
                return false;
            }

            private void popOneTerm(int distance) {
                IString newTerm = (IString)this.backLog.get(0);
                this.backLog = this.backLog.delete(0);
                char[] charArray = newTerm.getValue().toCharArray();
                this.termAtt.resizeBuffer(charArray.length);
                this.termAtt.copyBuffer(charArray, 0, charArray.length);
                this.posAttr.setPositionIncrement(distance);
            }
        };
    }

    private Tokenizer makeTokenizer(IConstructor node) {
        switch (node.getName()) {
            case "tokenizerClass": {
                return this.tokenizerFromClass(((IString)node.get("tokenizerClassName")).getValue());
            }
            case "tokenizer": {
                return this.makeTokenizer((IFunction)node.get("tokenizerFunction"));
            }
        }
        throw new IllegalArgumentException();
    }

    private Tokenizer makeTokenizer(final IFunction function) {
        return new Tokenizer(){
            private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
            private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
            private Iterator<IValue> result;

            public void reset() throws IOException {
                super.reset();
                this.result = null;
                this.clearAttributes();
            }

            public boolean incrementToken() throws IOException {
                if (this.result == null) {
                    IString parameter = LuceneAdapter.this.vf.string(Prelude.consumeInputStream((Reader)this.input));
                    try {
                        IList terms = (IList)function.call(new IValue[]{parameter});
                        this.result = terms.iterator();
                    }
                    catch (Throwable e) {
                        this.result = LuceneAdapter.this.vf.list(new IValue[]{LuceneAdapter.this.vf.constructor(LuceneAdapter.this.termCons, new IValue[]{parameter, LuceneAdapter.this.vf.sourceLocation(URIUtil.rootLocation((String)"error"), 0, parameter.length()), LuceneAdapter.this.vf.string("parse-error")})}).iterator();
                    }
                }
                if (this.result.hasNext()) {
                    IConstructor termCons = (IConstructor)this.result.next();
                    char[] token = ((IString)termCons.get(0)).getValue().toCharArray();
                    this.termAtt.copyBuffer(token, 0, token.length);
                    this.termAtt.setLength(token.length);
                    this.typeAtt.setType(((IString)termCons.get(2)).getValue());
                    int start = ((ISourceLocation)termCons.get(1)).getOffset();
                    this.offsetAtt.setOffset(start, start + token.length);
                    return true;
                }
                return false;
            }
        };
    }

    private TokenStream filterFromClass(TokenStream stream, String filterClass) {
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass(filterClass);
            return (TokenStream)cls.getConstructor(TokenStream.class).newInstance(stream);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(filterClass, e);
        }
    }

    private Analyzer analyzerFromClass(String analyzerClass) {
        return this.fromClass(Analyzer.class, analyzerClass);
    }

    private Tokenizer tokenizerFromClass(String analyzerClass) {
        return this.fromClass(Tokenizer.class, analyzerClass);
    }

    private <T> T fromClass(Class<T> clz, String name) {
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass(name);
            return (T)cls.newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(name, e);
        }
    }

    private Document makeDocument(IConstructor elem, IString charset, IBool inferCharset) {
        Document luceneDoc = new Document();
        ISourceLocation loc = (ISourceLocation)elem.get(SRC_FIELD_NAME);
        StringField idField = new StringField(ID_FIELD_NAME, loc.toString(), Field.Store.YES);
        luceneDoc.add((IndexableField)idField);
        if (URIResolverRegistry.getInstance().exists(loc)) {
            Field srcField = new Field(SRC_FIELD_NAME, Prelude.readFile((IValueFactory)this.vf, (boolean)false, (ISourceLocation)loc, (String)charset.getValue(), (boolean)inferCharset.getValue()).getValue(), (IndexableFieldType)SOURCELOCATION_TYPE);
            luceneDoc.add((IndexableField)srcField);
        }
        IWithKeywordParameters kws = elem.asWithKeywordParameters();
        for (String label : kws.getParameterNames()) {
            IValue val = kws.getParameter(label);
            if (val.getType().isString()) {
                luceneDoc.add((IndexableField)new Field(label, ((IString)val).getValue(), (IndexableFieldType)TextField.TYPE_STORED));
                continue;
            }
            if (val.getType().isSourceLocation()) {
                luceneDoc.add((IndexableField)new Field(label, Prelude.readFile((IValueFactory)this.vf, (boolean)false, (ISourceLocation)((ISourceLocation)val), (String)charset.getValue(), (boolean)inferCharset.getValue()).getValue(), (IndexableFieldType)SOURCELOCATION_TYPE));
                continue;
            }
            luceneDoc.add((IndexableField)new Field(label, val.toString(), (IndexableFieldType)TextField.TYPE_STORED));
        }
        return luceneDoc;
    }

    private static FieldType makeSourceLocationType() {
        FieldType sourceLocationType = new FieldType();
        sourceLocationType.setStored(false);
        sourceLocationType.setStoreTermVectors(true);
        sourceLocationType.setStoreTermVectorPositions(true);
        sourceLocationType.setStoreTermVectorOffsets(true);
        sourceLocationType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        sourceLocationType.freeze();
        return sourceLocationType;
    }

    private static class SourceLocationDirectory
    extends BaseDirectory {
        private final ISourceLocation src;
        private final URIResolverRegistry reg;
        private final AtomicLong nextTempFileCounter = new AtomicLong();
        private final IValueFactory vf;

        public SourceLocationDirectory(IValueFactory vf, LockFactory lockFactory, ISourceLocation src) throws IOException {
            super(lockFactory);
            this.vf = vf;
            this.src = src;
            this.reg = URIResolverRegistry.getInstance();
            if (!this.reg.exists(src)) {
                this.reg.mkDirectory(src);
            }
        }

        public String toString() {
            return this.src.toString();
        }

        public String[] listAll() throws IOException {
            return this.reg.listEntries(this.src);
        }

        public void deleteFile(String name) throws IOException {
            this.reg.remove(this.location(name), true);
        }

        public long fileLength(String name) throws IOException {
            try {
                return Prelude.__getFileSize((IValueFactory)this.vf, (ISourceLocation)this.location(name)).longValue();
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            return new SourceLocationIndexOutput(this.location(name));
        }

        private ISourceLocation location(String name) {
            return URIUtil.getChildLocation((ISourceLocation)this.src, (String)name);
        }

        public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
            this.ensureOpen();
            while (true) {
                try {
                    String name = IndexFileNames.segmentFileName((String)prefix, (String)(suffix + "_" + Long.toString(this.nextTempFileCounter.getAndIncrement(), 36)), (String)"tmp");
                    return this.createOutput(name, context);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    continue;
                }
                break;
            }
        }

        public void sync(Collection<String> names) throws IOException {
        }

        public void syncMetaData() throws IOException {
        }

        public void rename(String source, String dest) throws IOException {
            this.reg.rename(this.location(source), this.location(dest), true);
        }

        public IndexInput openInput(String name, IOContext context) throws IOException {
            return new SourceLocationIndexInput(this.location(name));
        }

        public void close() throws IOException {
            this.isOpen = false;
        }
    }

    private static class SourceLocationIndexInput
    extends IndexInput {
        private final byte[] input;
        private final int start;
        private final int end;
        private int cursor;

        public SourceLocationIndexInput(ISourceLocation src) throws IOException {
            super(src.toString());
            SourceLocationByteReader bytes = new SourceLocationByteReader(src);
            this.input = bytes.getByteArray();
            this.cursor = this.start = 0;
            this.end = bytes.size();
        }

        private SourceLocationIndexInput(String name, byte[] input, int sliceStart, int cursor, int sliceEnd) {
            super(name);
            this.input = input;
            this.start = sliceStart;
            this.cursor = cursor;
            this.end = sliceEnd;
        }

        public void close() throws IOException {
        }

        public long getFilePointer() {
            return this.cursor - this.start;
        }

        public void seek(long pos) throws IOException {
            if (pos + (long)this.start > (long)this.end) {
                throw new EOFException();
            }
            if (pos > Integer.MAX_VALUE) {
                throw new IOException("SourceLocationIndexInput supports files up to MAX_INT bytes");
            }
            this.cursor = (int)(pos + (long)this.start);
        }

        public long length() {
            return this.end - this.start;
        }

        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            if (offset + length > 0x7FFFFFF7L) {
                throw new IOException("SourceLocationIndexInput supports files up to MAX_INT bytes");
            }
            int newSliceStart = (int)((long)this.start + offset);
            int newSliceEnd = (int)((long)this.start + offset + length);
            return new SourceLocationIndexInput(sliceDescription, this.input, newSliceStart, newSliceStart, newSliceEnd);
        }

        public byte readByte() throws IOException {
            if (this.cursor > this.end) {
                throw new EOFException();
            }
            return this.input[this.cursor++];
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            if (this.cursor + len > this.end) {
                throw new EOFException();
            }
            System.arraycopy(this.input, this.cursor, b, offset, len);
            this.cursor += len;
        }

        public IndexInput clone() {
            return new SourceLocationIndexInput(this.toString() + "-clone", this.input, this.start, this.cursor, this.end);
        }

        private static final class SourceLocationByteReader {
            private static final int MAX_ARRAY = 0x7FFFFFF7;
            private static final int CHUNK_SIZE = 8192;
            private byte[] buf = new byte[16384];
            private int count;

            private SourceLocationByteReader(ISourceLocation src) throws IOException {
                try (InputStream in = URIResolverRegistry.getInstance().getInputStream(src);){
                    int read;
                    while ((read = in.read(this.buf, this.count, 8192)) != -1) {
                        this.count += read;
                        this.grow(this.count + 8192);
                    }
                }
            }

            private void grow(int required) {
                if (required < 0) {
                    throw new OutOfMemoryError();
                }
                if (required > this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, Math.min(Math.max(required, this.buf.length << 1), 0x7FFFFFF7));
                }
            }

            private byte[] getByteArray() {
                return this.buf;
            }

            private int size() {
                return this.count;
            }
        }
    }

    private static class SourceLocationIndexOutput
    extends OutputStreamIndexOutput {
        public SourceLocationIndexOutput(ISourceLocation src) throws IOException {
            super(src.toString(), src.toString(), URIResolverRegistry.getInstance().getOutputStream(src, false), 8192);
        }
    }
}

