/*
 * Decompiled with CFR 0.152.
 */
package analysis.text.stemming;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.HashMap;
import java.util.Map;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.KpStemmer;
import org.tartarus.snowball.ext.LovinsStemmer;
import org.tartarus.snowball.ext.PorterStemmer;

public class Snowball {
    private final IValueFactory vf;
    private final Map<String, SnowballProgram> stemmers = new HashMap<String, SnowballProgram>();

    public Snowball(IValueFactory vf) {
        this.vf = vf;
        this.stemmers.put("kp", (SnowballProgram)new KpStemmer());
        this.stemmers.put("porter", (SnowballProgram)new PorterStemmer());
        this.stemmers.put("lovins", (SnowballProgram)new LovinsStemmer());
    }

    public IString stem(IString word, IConstructor language) {
        SnowballProgram stemmer = this.getStemmerFor(language);
        return this.stem(word, stemmer);
    }

    private IString stem(IString word, SnowballProgram stemmer) {
        stemmer.setCurrent(word.getValue());
        stemmer.stem();
        return this.vf.string(stemmer.getCurrent());
    }

    private SnowballProgram getStemmerFor(IConstructor language) {
        try {
            String name = language.getName();
            SnowballProgram program = this.stemmers.get(name);
            if (program == null) {
                program = (SnowballProgram)Class.forName("org.tartarus.snowball.ext." + this.capitalize(name) + "Stemmer").newInstance();
                this.stemmers.put(name, program);
            }
            return program;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)language, null, null);
        }
    }

    private String capitalize(String input) {
        if (input.length() == 0) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public IString kraaijPohlmannStemmer(IString word) {
        return this.stem(word, this.stemmers.get("kp"));
    }

    public IString porterStemmer(IString word) {
        return this.stem(word, this.stemmers.get("porter"));
    }

    public IString lovinsStemmer(IString word) {
        return this.stem(word, this.stemmers.get("lovins"));
    }
}

