---
title: "module analysis::text::search::Grammars"
id: Grammars
slug: /Packages/org.rascalmpl.rascal-lucene/API/analysis/text/search/Grammars
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.rascal-lucene-0.1.0</div>

Bridges Rascal grammars and parser generation to the Lucene "Analyzer" and "Tokenizer" interfaces.
#### Usage

```rascal
import analysis::text::search::Grammars;
```

#### Dependencies
```rascal
extend analysis::text::search::Lucene;
import ParseTree;
import String;
```

#### Description


By leveraging the information in ParseTree instances we can provide, selectively, tokens for any source file that
we have a grammar for:
* [Analyzer From Grammar](../../../../../..//Packages/org.rascalmpl.rascal-lucene/API/analysis/text/search/Grammars.md#analysis-text-search-Grammars-analyzerFromGrammar) combines a [Tokenizer From Grammar](../../../../../..//Packages/org.rascalmpl.rascal-lucene/API/analysis/text/search/Grammars.md#analysis-text-search-Grammars-tokenizerFromGrammar) with a [Lower Case Filter](../../../../../..//Packages/org.rascalmpl.rascal-lucene/API/analysis/text/search/Lucene.md#analysis-text-search-Lucene-lowerCaseFilter). It makes an entire source file searchable.
* [Identifier Analyzer From Grammar](../../../../../..//Packages/org.rascalmpl.rascal-lucene/API/analysis/text/search/Grammars.md#analysis-text-search-Grammars-identifierAnalyzerFromGrammar) selects only the identifiers in the source text, ignoring keywords and comments and such.
* [Comment Analyzer From Grammar](../../../../../..//Packages/org.rascalmpl.rascal-lucene/API/analysis/text/search/Grammars.md#analysis-text-search-Grammars-commentAnalyzerFromGrammar) focuses on the words in source code comments.

This functionality is based on the [Lucene](../../../../../../Packages/org.rascalmpl.rascal-lucene//API/analysis/text/search/Lucene.md) module, and its underlying adapter that bridges Rascal callbacks
to Lucene's search framework.


## function analyzerFromGrammar {#analysis-text-search-Grammars-analyzerFromGrammar}

```rascal
Analyzer analyzerFromGrammar(type[&T <: Tree] grammar)
```

## function identifierAnalyzerFromGrammar {#analysis-text-search-Grammars-identifierAnalyzerFromGrammar}

```rascal
Analyzer identifierAnalyzerFromGrammar(type[&T <: Tree] grammar)
```

## function commentAnalyzerFromGrammar {#analysis-text-search-Grammars-commentAnalyzerFromGrammar}

```rascal
Analyzer commentAnalyzerFromGrammar(type[&T <: Tree] grammar)
```

## function tokenizerFromGrammar {#analysis-text-search-Grammars-tokenizerFromGrammar}

Use a generate parser as a Lucene tokenizer. Skipping nothing.

```rascal
Tokenizer tokenizerFromGrammar(type[&T <: Tree] grammar)
```

## function identifierTokenizerFromGrammar {#analysis-text-search-Grammars-identifierTokenizerFromGrammar}

Use a generated parser as a Lucene tokenizer, and skip all keywords and punctuation.

```rascal
Tokenizer identifierTokenizerFromGrammar(type[&T <: Tree] grammar)
```

## function commentTokenizerFromGrammar {#analysis-text-search-Grammars-commentTokenizerFromGrammar}

Use a generated parser as a Lucene tokenizer, and skip all keywords and punctuation.

```rascal
Tokenizer commentTokenizerFromGrammar(type[&T <: Tree] grammar)
```

## function tokens {#analysis-text-search-Grammars-tokens}

```rascal
list[Tree] tokens(amb({Tree x, *_}), bool(Tree) isTokenPredicate)

default list[Tree] tokens(Tree tok, bool(Tree) isTokenPredicate)
```

## function isTokenType {#analysis-text-search-Grammars-isTokenType}

```rascal
bool isTokenType(lit(_))

bool isTokenType(cilit(_))

bool isTokenType(lex(_))

bool isTokenType(layouts(_))

bool isTokenType(label(str _, Symbol s))

default bool isTokenType(Symbol _)
```

## function isToken {#analysis-text-search-Grammars-isToken}

```rascal
bool isToken(appl(prod(Symbol s, _, _), _))

bool isToken(char(_))

default bool isToken(Tree _)
```

## function isLexical {#analysis-text-search-Grammars-isLexical}

```rascal
bool isLexical(appl(prod(Symbol s, _, _), _))

default bool isLexical(Tree _)
```

## function isComment {#analysis-text-search-Grammars-isComment}

```rascal
bool isComment(Tree t)

default bool isComment(Tree _)
```

