---
title: "module analysis::text::search::LuceneTest"
id: LuceneTest
slug: /Packages/org.rascalmpl.rascal-lucene/API/analysis/text/search/LuceneTest
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.rascal-lucene-0.1.0</div>

#### Usage

```rascal
import analysis::text::search::LuceneTest;
```

#### Dependencies
```rascal
import analysis::text::search::Grammars;
import lang::pico::\syntax::Main;
import util::FileSystem;
import IO;
import List;
```


## syntax WordSplitter {#analysis-text-search-LuceneTest-WordSplitter}

```rascal
lexical WordSplitter = Word* words;
```

## syntax Word {#analysis-text-search-LuceneTest-Word}

```rascal
lexical Word 
  = [A-Za-z0-9\-]+ !>> [A-Za-z0-9]
  | ![A-Za-z0-9\-]+ !>> ![A-Za-z0-9]
  ;
```

## data Document {#analysis-text-search-LuceneTest-Document}

```rascal
data Document (loc comments = |unknown:///|, str extra = "")
```

## data Analyzer {#analysis-text-search-LuceneTest-Analyzer}

```rascal
data Analyzer (Analyzer comments = standardAnalyzer(), Analyzer extra = standardAnalyzer())
```

## function abFilter {#analysis-text-search-LuceneTest-abFilter}

```rascal
str abFilter(str token)
```

## function utFilter {#analysis-text-search-LuceneTest-utFilter}

```rascal
bool utFilter(str token)
```

## function lauSplitDanda {#analysis-text-search-LuceneTest-lauSplitDanda}

```rascal
list[str] lauSplitDanda("laudanda")
```

## function an {#analysis-text-search-LuceneTest-an}

```rascal
Analyzer  an()
```

## function commentAnalyzer {#analysis-text-search-LuceneTest-commentAnalyzer}

```rascal
Analyzer  commentAnalyzer()
```

## function wordSplitFilter {#analysis-text-search-LuceneTest-wordSplitFilter}

```rascal
Filter wordSplitFilter()
```

## function extraAnalyzer {#analysis-text-search-LuceneTest-extraAnalyzer}

```rascal
Analyzer  extraAnalyzer()
```

## function indexAnalyzer {#analysis-text-search-LuceneTest-indexAnalyzer}

```rascal
Analyzer indexAnalyzer()
```

## function picoIndex {#analysis-text-search-LuceneTest-picoIndex}

```rascal
bool picoIndex()
```

## function picoSearch {#analysis-text-search-LuceneTest-picoSearch}

```rascal
void picoSearch(str term)
```

## function extraSearch {#analysis-text-search-LuceneTest-extraSearch}

```rascal
void extraSearch()
```

## function main {#analysis-text-search-LuceneTest-main}

```rascal
void main()
```

# Tests
## test extraTermsTest {#analysis-text-search-LuceneTest-extraTermsTest}

```rascal
test bool extraTermsTest() = listTerms(indexFolder, "extra") == {
  <"est",1>,
  <"tbmen",1>,
  <"vires",1>,
  <"dbndb",1>,
  <"voluntbs",1>,
  <"desint",1>,
  <"lbu",1>
};
```

## test identifierTest {#analysis-text-search-LuceneTest-identifierTest}

```rascal
test bool identifierTest() = picoIndex() && document(loc l) <- searchIndex(indexFolder, "src:repnr") && l == |project://rascal-lucene/src/analysis/text/search/testdata/Fac.pico|;
```

## test analyzerTest1 {#analysis-text-search-LuceneTest-analyzerTest1}

```rascal
test bool analyzerTest1() = picoIndex() && size(analyzeDocument(|project://rascal-lucene/src/analysis/text/search/testdata/Fac.pico|, analyzer=an())) == 25;
```

## test analyzerTest2 {#analysis-text-search-LuceneTest-analyzerTest2}

```rascal
test bool analyzerTest2() = picoIndex() &&  size(analyzeDocument(|project://rascal-lucene/src/analysis/text/search/testdata/Fac.pico|, analyzer=commentAnalyzer())) == 7;
```

## test searchDocTest1 {#analysis-text-search-LuceneTest-searchDocTest1}

```rascal
test bool searchDocTest1() = picoIndex() && size(searchDocument(|project://rascal-lucene/src/analysis/text/search/testdata/Fac.pico|, "repnr", analyzer=an())) == 5;
```

## test searchDocTest2 {#analysis-text-search-LuceneTest-searchDocTest2}

```rascal
test bool searchDocTest2() = picoIndex() && size(searchDocument(|project://rascal-lucene/src/analysis/text/search/testdata/Fac.pico|, "repnr", analyzer=commentAnalyzer())) == 0;
```

## test searchDocTest3 {#analysis-text-search-LuceneTest-searchDocTest3}

```rascal
test bool searchDocTest3() = picoIndex() && size(searchDocument(|project://rascal-lucene/src/analysis/text/search/testdata/Fac.pico|, "check", analyzer=commentAnalyzer())) == 1;
```

