---
title: "module analysis::text::stemming::Snowball"
id: Snowball
slug: /Packages/org.rascalmpl.rascal-lucene/API/analysis/text/stemming/Snowball
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-0.41.2</div> <div class="theme-doc-version-badge badge badge--secondary">org.rascalmpl.rascal-lucene-0.1.0</div>

Provides the library of stemmers written in the Snowball languages, and compiled to Java, which are
distributed with Lucene as a Rascal module.
#### Usage

```rascal
import analysis::text::stemming::Snowball;
```



See [the Snowball homepage](http://snowball.tartarus.org) for more informations

#### Examples



```rascal-shell 
rascal>import analysis::text::stemming::Snowball;
ok
rascal>stem("bikes")
str: "bike"
───
bike
───
```


## data Language {#analysis-text-stemming-Snowball-Language}

```rascal
data Language  
     = armenian()
     | basque()
     | catalan()
     | danish()
     | dutch()
     | english()
     | finnish()
     | french()
     | german()
     | german2()
     | hungarian()
     | irish()
     | italian()
     | lithuanian()
     | norwegian()
     | portugese()
     | romanian()
     | russian()
     | spanish()
     | swedish()
     | turkish()
     ;
```

## function stem {#analysis-text-stemming-Snowball-stem}

Stemming algorithms from the Tartarus Snowball [the Snowball homepage](http://snowball.tartarus.org) for different languages.

```rascal
str stem(str word, Language lang=english())
```


This library wrapped into a single function supports Armenian, Basque, Catalan, Danish,
Dutch, English, Finnish, French, German, Hungarian, Irish, Italian, Lithuanian, Norwegian, Portugese,
Romanian, Russian, Spanish, Swedish and Turkish.

## function kraaijPohlmannStemmer {#analysis-text-stemming-Snowball-kraaijPohlmannStemmer}

Kraaij-Pohlmann is a well-known stemmer for the Dutch language.

```rascal
str kraaijPohlmannStemmer(str word)
```


See http://snowball.tartarus.org/algorithms/kraaij_pohlmann/stemmer.html

## function porterStemmer {#analysis-text-stemming-Snowball-porterStemmer}

Porter stemming is a "standard" stemming algorithm for English of sorts.

```rascal
str porterStemmer(str word)
```


See http://snowball.tartarus.org/algorithms/porter/stemmer.html for more information.

## function lovinsStemmer {#analysis-text-stemming-Snowball-lovinsStemmer}

Lovins designed the first stemmer according to the Tartarus website.

```rascal
str lovinsStemmer(str word)
```


See http://snowball.tartarus.org/algorithms/lovins/stemmer.html

