/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.maven.MojoUtils;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.project.ProjectURIResolver;

@Mojo(name="tutor", inheritByDefault=false, defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CompileRascalDocumentation
extends AbstractMojo {
    private static final String UNEXPECTED_ERROR = "unexpected error during Rascal compiler run";
    private static final String MAIN_COMPILER_MODULE = "lang::rascal::tutor::Compiler";
    private static final ISourceLocation[] MAIN_COMPILER_SEARCH_PATH = new ISourceLocation[]{URIUtil.correctLocation((String)"lib", (String)"rascal-tutor", (String)""), URIUtil.correctLocation((String)"lib", (String)"rascal", (String)"")};
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="bin", required=true, defaultValue="${project.build.outputDirectory}")
    private String bin;
    @Parameter(property="srcs", required=true)
    private List<String> srcs;
    @Parameter(property="ignores", required=true)
    private List<String> ignores;
    @Parameter(property="libs", required=false)
    private List<String> libs;
    @Parameter(property="errorsAsWarnings", required=false, defaultValue="false")
    private boolean errorsAsWarnings;
    @Parameter(property="warningsAsErrors", required=false, defaultValue="false")
    private boolean warningsAsErrors;
    @Parameter(property="enableStandardLibrary", required=false, defaultValue="true")
    private boolean enableStandardLibrary;
    @Parameter(property="isPackageCourse", required=false, defaultValue="true")
    private boolean isPackageCourse;
    @Parameter(property="packageName", required=true, defaultValue="${project.artifactId}")
    private String packageName;
    @Parameter(property="packageVersion", required=true, defaultValue="${project.version}")
    private String packageVersion;
    @Parameter(property="packageGroup", required=true, defaultValue="${project.groupId}")
    private String packageGroup;
    @Parameter(property="license", required=false, defaultValue="${project.basedir}/LICENSE.md")
    private String licenseFile;
    @Parameter(property="funding", required=false, defaultValue="${project.basedir}/FUNDING.md")
    private String funding;
    @Parameter(property="citation", required=false, defaultValue="${project.basedir}/CITATION.md")
    private String citation;
    @Parameter(property="releaseNotes", required=false, defaultValue="${project.basedir}/RELEASE-NOTES.md")
    private String releaseNotes;
    @Parameter(property="issues", required=false)
    private String issues;
    @Parameter(property="sources", required=false)
    private String sources;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        try {
            ISourceLocation binLoc = URIUtil.getChildLocation((ISourceLocation)MojoUtils.location(this.bin), (String)"docs");
            List<ISourceLocation> srcLocs = MojoUtils.locations(this.srcs);
            List<ISourceLocation> libLocs = MojoUtils.locations(this.libs);
            List<ISourceLocation> ignoredLocs = MojoUtils.locations(this.ignores);
            List<ISourceLocation> classpath = this.collectClasspath();
            if (System.getProperty("rascal.documentation.skip") != null || System.getProperty("rascal.tutor.skip") != null) {
                this.getLog().info((CharSequence)"Skipping Rascal Documentation compiler completely");
                return;
            }
            this.getLog().info((CharSequence)"configuring paths");
            for (ISourceLocation src : srcLocs) {
                this.getLog().info((CharSequence)("\tregistered source location: " + src));
            }
            this.getLog().info((CharSequence)"checking if any files need compilation");
            MojoUtils.collectDependentArtifactLibraries(this.project, libLocs);
            for (ISourceLocation lib : libLocs) {
                this.getLog().info((CharSequence)("\tregistered library location: " + lib));
            }
            List<ISourceLocation> compilerClassPath = this.collectPluginClasspath();
            PathConfig pcfg = new PathConfig(srcLocs, libLocs, binLoc, ignoredLocs, compilerClassPath, classpath);
            this.getLog().info((CharSequence)("Paths have been configured: " + pcfg));
            URIResolverRegistry.getInstance().registerLogical((ILogicalSourceLocationResolver)new ProjectURIResolver(MojoUtils.location(this.project.getBasedir().getCanonicalFile().toString()), this.project.getName()));
            Evaluator eval = MojoUtils.makeEvaluator(this.getLog(), this.session, MAIN_COMPILER_SEARCH_PATH, MAIN_COMPILER_MODULE);
            IList messages = this.runCompiler(eval.getMonitor(), (IEvaluator<Result<IValue>>)eval, pcfg);
            this.getLog().info((CharSequence)"Tutor is done, reporting errors now.");
            this.handleMessages(pcfg, messages);
            this.getLog().info((CharSequence)"Error reporting done");
            return;
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException(UNEXPECTED_ERROR, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(UNEXPECTED_ERROR, (Exception)e);
        }
        catch (Throw e) {
            this.getLog().error((CharSequence)(e.getLocation() + ": " + e.getMessage()));
            this.getLog().error((CharSequence)e.getTrace().toString());
            throw new MojoExecutionException(UNEXPECTED_ERROR, (Exception)((Object)e));
        }
    }

    private List<ISourceLocation> collectClasspath() throws URISyntaxException {
        LinkedList<ISourceLocation> builder = new LinkedList<ISourceLocation>();
        boolean dependsOnRascal = false;
        builder.add(MojoUtils.location(this.bin));
        if ("org.rascalmpl".equals(this.project.getGroupId()) && "rascal".equals(this.project.getArtifactId())) {
            File r = new File(this.project.getBuild().getOutputDirectory());
            if (!this.enableStandardLibrary) {
                builder.add(URIUtil.createFileLocation((String)r.getAbsolutePath()));
            }
            dependsOnRascal = true;
        }
        for (Object o : this.project.getArtifacts()) {
            Artifact a = (Artifact)o;
            File file = a.getFile().getAbsoluteFile();
            if ("org.rascalmpl".equals(a.getGroupId()) && "rascal".equals(a.getArtifactId())) {
                dependsOnRascal = true;
                if (!this.enableStandardLibrary) continue;
                builder.add(URIUtil.createFileLocation((String)file.getAbsolutePath()));
                continue;
            }
            builder.add(URIUtil.createFileLocation((String)file.getAbsolutePath()));
        }
        if (!dependsOnRascal) {
            this.getLog().info((CharSequence)"Current project does not have a dependency on org.rascalmpl:rascal");
        }
        return builder;
    }

    private List<ISourceLocation> collectPluginClasspath() throws URISyntaxException {
        LinkedList<ISourceLocation> builder = new LinkedList<ISourceLocation>();
        builder.add(MojoUtils.location(IValue.class.getProtectionDomain().getCodeSource().getLocation().getPath()));
        builder.add(MojoUtils.location(Evaluator.class.getProtectionDomain().getCodeSource().getLocation().getPath()));
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IList runCompiler(IRascalMonitor monitor, IEvaluator<Result<IValue>> eval, PathConfig pcfg) throws URISyntaxException, IOException {
        try {
            IConstructor pc = pcfg.asConstructor();
            pc = (IConstructor)pc.asWithKeywordParameters().setParameter("isPackageCourse", (IValue)eval.getValueFactory().bool(this.isPackageCourse));
            pc = (IConstructor)pc.asWithKeywordParameters().setParameter("packageName", (IValue)eval.getValueFactory().string(this.packageName));
            pc = (IConstructor)pc.asWithKeywordParameters().setParameter("packageVersion", (IValue)eval.getValueFactory().string(this.packageVersion));
            pc = (IConstructor)pc.asWithKeywordParameters().setParameter("packageGroup", (IValue)eval.getValueFactory().string(this.packageGroup));
            pc = (IConstructor)pc.asWithKeywordParameters().setParameter("packageRoot", (IValue)URIUtil.createFileLocation((String)this.project.getBasedir().getCanonicalPath()));
            if (this.sources != null) {
                pc = (IConstructor)pc.asWithKeywordParameters().setParameter("sources", (IValue)MojoUtils.location(this.sources));
            }
            if (this.issues != null) {
                pc = (IConstructor)pc.asWithKeywordParameters().setParameter("issues", (IValue)MojoUtils.location(this.issues));
            }
            pc = (IConstructor)pc.asWithKeywordParameters().setParameter("license", (IValue)MojoUtils.location(this.licenseFile));
            pc = (IConstructor)pc.asWithKeywordParameters().setParameter("funding", (IValue)MojoUtils.location(this.funding));
            pc = (IConstructor)pc.asWithKeywordParameters().setParameter("citation", (IValue)MojoUtils.location(this.citation));
            pc = (IConstructor)pc.asWithKeywordParameters().setParameter("releaseNotes", (IValue)MojoUtils.location(this.releaseNotes));
            eval.getErrorPrinter().println(pc);
            IList iList = (IList)eval.call(monitor, "compile", new IValue[]{pc});
            return iList;
        }
        finally {
            eval.getErrorPrinter().flush();
            eval.getOutPrinter().flush();
        }
    }

    private void handleMessages(PathConfig pcfg, IList messages) throws MojoExecutionException {
        int maxLine = 0;
        int maxColumn = 0;
        boolean hasErrors = false;
        for (IValue error : messages) {
            ISourceLocation loc = (ISourceLocation)((IConstructor)error).get("at");
            if (loc.hasLineColumn()) {
                maxLine = Math.max(loc.getBeginLine(), maxLine);
                maxColumn = Math.max(loc.getBeginColumn(), maxColumn);
                continue;
            }
            this.getLog().error((CharSequence)("loc without line/column: " + loc));
        }
        int lineWidth = (int)Math.log10(maxLine + 1) + 1;
        int colWidth = (int)Math.log10(maxColumn + 1) + 1;
        for (IValue error : messages) {
            IConstructor msg = (IConstructor)error;
            String type = msg.getName();
            boolean isError = type.equals("error");
            boolean isWarning = type.equals("warning");
            hasErrors |= isError || this.warningsAsErrors && isWarning;
            ISourceLocation loc = (ISourceLocation)msg.get("at");
            int col = 0;
            int line = 0;
            if (loc.hasLineColumn()) {
                col = loc.getBeginColumn();
                line = loc.getBeginLine();
            }
            String output = CompileRascalDocumentation.abbreviate(loc, pcfg) + ":" + String.format("%0" + lineWidth + "d", line) + ":" + String.format("%0" + colWidth + "d", col) + ": " + ((IString)msg.get("msg")).getValue();
            if (isError) {
                this.getLog().error((CharSequence)("  " + output));
                continue;
            }
            if (isWarning) {
                this.getLog().warn((CharSequence)output);
                continue;
            }
            this.getLog().info((CharSequence)("   " + output));
        }
        if (hasErrors && !this.errorsAsWarnings) {
            this.getLog().error((CharSequence)"More than zero errors!");
            throw new MojoExecutionException("Tutor compiler found compile-time errors");
        }
    }

    private static String abbreviate(ISourceLocation loc, PathConfig pcfg) {
        for (IValue src : pcfg.getSrcs()) {
            String path = ((ISourceLocation)src).getURI().getPath();
            if (!loc.getPath().startsWith(path)) continue;
            return URIUtil.getLocationName((ISourceLocation)((ISourceLocation)src)) + "/" + loc.getPath().substring(path.length());
        }
        return loc.getPath();
    }
}

