/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.maven.MojoUtils;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.util.ConcurrentSoftReferenceObjectPool;
import org.rascalmpl.values.ValueFactoryFactory;

@Mojo(name="compile", inheritByDefault=false, defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CompileRascalMojo
extends AbstractMojo {
    private static final String UNEXPECTED_ERROR = "unexpected error during Rascal compiler run";
    private static final String MAIN_COMPILER_MODULE = "lang::rascalcore::check::Checker";
    private static final String COMPILER_CONFIG_MODULE = "lang::rascalcore::check::RascalConfig";
    private static final ISourceLocation[] MAIN_COMPILER_SEARCH_PATH = new ISourceLocation[]{URIUtil.correctLocation((String)"lib", (String)"typepal", (String)""), URIUtil.correctLocation((String)"lib", (String)"rascal-core", (String)"")};
    private static final URIResolverRegistry reg = URIResolverRegistry.getInstance();
    private static final IValueFactory VF = ValueFactoryFactory.getValueFactory();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="bin", required=true)
    private String bin;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="resources", required=true)
    private String resources;
    @Parameter(defaultValue="${project.basedir}/generated-sources", property="generatedSources", required=true)
    private String generatedSources;
    @Parameter(property="srcs", required=true)
    private List<String> srcs;
    @Parameter(property="srcIgnores", required=false)
    private List<String> srcIgnores;
    @Parameter(property="libs", required=false)
    private List<String> libs;
    @Parameter(defaultValue="false", property="verbose", required=true)
    private boolean verbose;
    @Parameter(property="errorsAsWarnings", required=false, defaultValue="false")
    private boolean errorsAsWarnings;
    @Parameter(property="warningsAsErrors", required=false, defaultValue="false")
    private boolean warningsAsErrors;
    @Parameter(property="enableStandardLibrary", required=false, defaultValue="true")
    private boolean enableStandardLibrary;
    @Parameter(property="parallel", required=false, defaultValue="false")
    private boolean parallel;
    @Parameter(property="parallelMax", required=false, defaultValue="4")
    private int parallelMax;
    @Parameter(property="parallelPreChecks", required=false)
    private List<String> parallelPreChecks;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;

    private Evaluator makeEvaluator(IRascalMonitor monitor, PrintWriter err, PrintWriter out, MavenSession session) throws URISyntaxException, FactTypeUseException, IOException {
        return MojoUtils.makeEvaluator(this.getLog(), session, monitor, err, out, MAIN_COMPILER_SEARCH_PATH, MAIN_COMPILER_MODULE, COMPILER_CONFIG_MODULE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        try {
            ISourceLocation binLoc = MojoUtils.location(this.bin);
            ISourceLocation resourcesLoc = MojoUtils.location(this.resources);
            if (!binLoc.equals(resourcesLoc)) {
                this.getLog().info((CharSequence)("bin      : " + binLoc));
                this.getLog().info((CharSequence)("resources: " + resourcesLoc));
                this.getLog().error((Throwable)new IllegalArgumentException("resources target must be equal to bin"));
                throw new MojoExecutionException("Rascal compiler detected configuration errors");
            }
            ISourceLocation generatedSourcesLoc = MojoUtils.location(this.generatedSources);
            List<ISourceLocation> srcLocs = MojoUtils.locations(this.srcs);
            List<ISourceLocation> ignoredLocs = MojoUtils.locations(this.srcIgnores);
            List<ISourceLocation> libLocs = MojoUtils.locations(this.libs);
            if (System.getProperty("rascal.compile.skip") != null) {
                this.getLog().info((CharSequence)"Skipping Rascal compiler completely");
                return;
            }
            this.getLog().info((CharSequence)"configuring paths");
            for (ISourceLocation iSourceLocation : srcLocs) {
                this.getLog().info((CharSequence)("\tregistered source location: " + iSourceLocation));
            }
            for (ISourceLocation iSourceLocation : ignoredLocs) {
                this.getLog().warn((CharSequence)("\tignoring sources in: " + iSourceLocation));
            }
            this.getLog().info((CharSequence)"Checking if any files need compilation...");
            IList todoList = this.getTodoList(binLoc, srcLocs, ignoredLocs);
            if (!todoList.isEmpty()) {
                this.getLog().info((CharSequence)"Stale source files have been found:");
                for (IValue todo : todoList) {
                    this.getLog().info((CharSequence)("\t" + todo));
                }
            } else {
                this.getLog().info((CharSequence)"No stale source files have been found, skipping compilation.");
                return;
            }
            if (this.enableStandardLibrary) {
                libLocs.add(URIUtil.correctLocation((String)"lib", (String)"rascal", (String)""));
            }
            MojoUtils.collectDependentArtifactLibraries(this.project, libLocs);
            for (ISourceLocation lib : libLocs) {
                this.getLog().info((CharSequence)("\tregistered library location: " + lib));
            }
            this.getLog().info((CharSequence)"Paths have been configured.");
            PathConfig pathConfig = new PathConfig(srcLocs, libLocs, binLoc);
            IList messages = this.runChecker(this.verbose, todoList, pathConfig, generatedSourcesLoc);
            this.getLog().info((CharSequence)("Checker is done, reporting errors now." + (this.errorsAsWarnings ? " Errors are being deescalated to warnings." : "") + (this.warningsAsErrors ? " Warnings are beging escalated to errors. " : "")));
            try {
                if (!this.handleMessages(pathConfig, messages)) {
                    throw new MojoExecutionException("Rascal compiler found compile-time errors");
                }
            }
            finally {
                this.getLog().info((CharSequence)"Error reporting is done.");
            }
            return;
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException(UNEXPECTED_ERROR, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(UNEXPECTED_ERROR, (Exception)e);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException(UNEXPECTED_ERROR, (Exception)((Object)e));
        }
        catch (Throw e) {
            this.getLog().error((CharSequence)(e.getLocation() + ": " + e.getMessage()));
            this.getLog().error((CharSequence)e.getTrace().toString());
            throw new MojoExecutionException(UNEXPECTED_ERROR, (Exception)((Object)e));
        }
        catch (Throwable e) {
            throw new MojoExecutionException(UNEXPECTED_ERROR, e);
        }
    }

    private int parallelAmount() {
        long result = Runtime.getRuntime().availableProcessors();
        if (result < 2L) {
            return 1;
        }
        if ((result = Math.min(result, Runtime.getRuntime().maxMemory() / 0x200000L)) < 2L) {
            return 1;
        }
        return (int)Math.min((long)this.parallelMax, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeLog(Consumer<Log> action) {
        Log log;
        Log log2 = log = this.getLog();
        synchronized (log2) {
            action.accept(log);
        }
    }

    private IList runChecker(boolean verbose, IList todoList, PathConfig pcfg, ISourceLocation generatedSourcesLoc) throws IOException, URISyntaxException, Exception {
        if (!this.parallel || todoList.size() <= 10 || this.parallelAmount() <= 1) {
            return this.runCheckerSingleThreaded(verbose, todoList, pcfg, generatedSourcesLoc);
        }
        return this.runCheckerMultithreaded(verbose, todoList, pcfg, generatedSourcesLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IList runCheckerMultithreaded(boolean verbose, IList todoList, PathConfig pcfg, ISourceLocation generatedSourcesLoc) throws Exception {
        ImmutableTriple<IRascalMonitor, PrintWriter, PrintWriter> streams = MojoUtils.calculateMonitor(this.getLog(), this.session);
        ConcurrentSoftReferenceObjectPool<Evaluator> evaluators = this.createEvaluatorPool((IRascalMonitor)streams.left, (PrintWriter)streams.middle, (PrintWriter)streams.right);
        IConstructor pathConfig = this.expandPathConfig(pcfg, generatedSourcesLoc);
        IConstructor config = (IConstructor)evaluators.useAndReturn(e -> this.makeCompilerConfig((Evaluator)e, verbose, pathConfig));
        ConcurrentLinkedQueue parallelReports = new ConcurrentLinkedQueue();
        IListWriter start = VF.listWriter();
        List<IList> chunks = this.splitTodoList(todoList, this.parallelPreChecks, start);
        IList initialTodo = (IList)start.done();
        AtomicReference<Object> failure = new AtomicReference<Object>(null);
        ExecutorService executor = Executors.newFixedThreadPool(this.parallelAmount());
        try {
            Semaphore prePhaseDone = new Semaphore(0);
            if (!initialTodo.isEmpty()) {
                executor.execute(() -> {
                    try {
                        this.safeLog(l -> l.info((CharSequence)("Running pre-phase on: " + initialTodo.stream().map(f -> "\n\t" + f).reduce("", String::concat))));
                        parallelReports.add((IList)evaluators.useAndReturn(eval -> this.runCheckerSingle(eval.getMonitor(), initialTodo, (IEvaluator<Result<IValue>>)eval, config)));
                        this.safeLog(l -> l.info((CharSequence)"Finished running the pre-phase checker"));
                    }
                    catch (Exception e) {
                        this.safeLog(l -> l.info((CharSequence)"Failure executing pre-phase:", (Throwable)e));
                        failure.compareAndSet(null, e);
                    }
                    finally {
                        prePhaseDone.release(chunks.size() + 1);
                    }
                });
                Thread.sleep(100L);
            } else {
                prePhaseDone.release(chunks.size() + 1);
            }
            if (!chunks.isEmpty()) {
                this.safeLog(l -> l.debug((CharSequence)("Preparing checker for in " + chunks.size() + " parallel threads")));
                try {
                    ArrayList<ISourceLocation> binFolders = new ArrayList<ISourceLocation>();
                    ArrayList<ISourceLocation> generateSourcesFolders = new ArrayList<ISourceLocation>();
                    Semaphore done = new Semaphore(0);
                    for (IList todo : chunks) {
                        ISourceLocation myBin = VF.sourceLocation("tmp", "", "tmp-" + System.identityHashCode(todo) + "-" + Instant.now().getEpochSecond());
                        ISourceLocation mySources = VF.sourceLocation("tmp", "", "tmp-srcs-" + System.identityHashCode(todo) + "-" + Instant.now().getEpochSecond());
                        binFolders.add(myBin);
                        generateSourcesFolders.add(mySources);
                        PathConfig myConfig = new PathConfig(pcfg.getSrcs(), pcfg.getLibs().append((IValue)pcfg.getBin()), myBin);
                        executor.execute(() -> {
                            try {
                                Thread.sleep(1000L);
                                this.safeLog(l -> l.debug((CharSequence)"Starting fresh evaluator"));
                                parallelReports.add((IList)evaluators.useAndReturn(e -> {
                                    try {
                                        prePhaseDone.acquire();
                                        this.safeLog(l -> l.debug((CharSequence)("Starting checking chunk with " + todo.size() + " entries")));
                                        IConstructor epcfg = this.expandPathConfig(myConfig, mySources);
                                        IConstructor myCompilerConfig = this.makeCompilerConfig((Evaluator)e, verbose, epcfg);
                                        return this.runCheckerSingle(e.getMonitor(), todo, (IEvaluator<Result<IValue>>)e, myCompilerConfig);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        return VF.list(new IValue[0]);
                                    }
                                }));
                            }
                            catch (Exception e2) {
                                this.safeLog(l -> l.error((CharSequence)"Failure executing:", (Throwable)e2));
                                failure.compareAndSet(null, e2);
                            }
                            finally {
                                done.release();
                            }
                        });
                    }
                    done.acquire(chunks.size());
                    this.mergeOutputFolders(pcfg.getBin(), binFolders, false);
                    this.mergeOutputFolders(generatedSourcesLoc, generateSourcesFolders, true);
                }
                catch (IOException | InterruptedException | URISyntaxException e2) {
                    this.getLog().error((CharSequence)"Failed post-processing evaluator", (Throwable)e2);
                    failure.compareAndSet(null, e2);
                }
            }
            prePhaseDone.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            executor.shutdown();
        }
        if (failure.get() != null) {
            throw (Exception)failure.get();
        }
        return (IList)parallelReports.stream().flatMap(ms -> ms.stream()).collect(VF.listWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IList runCheckerSingleThreaded(boolean verbose, IList todoList, PathConfig pcfg, ISourceLocation generatedSourcesLoc) throws URISyntaxException, IOException {
        this.getLog().info((CharSequence)"Running checker in single threaded mode");
        ImmutableTriple<IRascalMonitor, PrintWriter, PrintWriter> streams = MojoUtils.calculateMonitor(this.getLog(), this.session);
        try {
            Evaluator eval = this.makeEvaluator((IRascalMonitor)streams.left, (PrintWriter)streams.middle, (PrintWriter)streams.right, this.session);
            IConstructor pcfgCons = this.expandPathConfig(pcfg, generatedSourcesLoc);
            IConstructor singleConfig = this.makeCompilerConfig(eval, verbose, pcfgCons);
            IList iList = this.runCheckerSingle(eval.getMonitor(), todoList, (IEvaluator<Result<IValue>>)eval, singleConfig);
            return iList;
        }
        finally {
            ((IRascalMonitor)streams.left).endAllJobs();
        }
    }

    private IConstructor makeCompilerConfig(Evaluator eval, boolean verbose, IConstructor pcfgCons) {
        return (IConstructor)eval.call("rascalCompilerConfig", new IValue[]{pcfgCons}).asWithKeywordParameters().setParameter("verbose", (IValue)VF.bool(verbose)).asWithKeywordParameters().setParameter("logPathConfig", (IValue)VF.bool(verbose)).asWithKeywordParameters().setParameter("logWrittenFiles", (IValue)VF.bool(verbose));
    }

    private IConstructor expandPathConfig(PathConfig pcfg, ISourceLocation generatedSourcesLoc) {
        return (IConstructor)((IConstructor)pcfg.asConstructor().asWithKeywordParameters().setParameter("resources", (IValue)pcfg.getBin())).asWithKeywordParameters().setParameter("generatedSources", (IValue)generatedSourcesLoc);
    }

    private ConcurrentSoftReferenceObjectPool<Evaluator> createEvaluatorPool(IRascalMonitor monitor, PrintWriter err, PrintWriter out) {
        return new ConcurrentSoftReferenceObjectPool(1L, TimeUnit.MINUTES, 1, this.parallelAmount(), () -> {
            try {
                return this.makeEvaluator(monitor, err, out, this.session);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void mergeOutputFolders(ISourceLocation bin, List<ISourceLocation> binFolders, boolean ignoreMissing) throws IOException {
        for (ISourceLocation b : binFolders) {
            this.getLog().info((CharSequence)("Copying tpls from " + b + " to " + bin));
            if (reg.isDirectory(b)) {
                CompileRascalMojo.mergeOutputFolders(bin, b);
                continue;
            }
            if (ignoreMissing) continue;
            throw new IOException("The " + b + " folder did not exist");
        }
    }

    private static void mergeOutputFolders(ISourceLocation dst, ISourceLocation src) throws IOException {
        for (String entry : reg.listEntries(src)) {
            ISourceLocation srcEntry = URIUtil.getChildLocation((ISourceLocation)src, (String)entry);
            ISourceLocation dstEntry = URIUtil.getChildLocation((ISourceLocation)dst, (String)entry);
            if (reg.isDirectory(srcEntry)) {
                if (!reg.exists(dstEntry)) {
                    reg.mkDirectory(dstEntry);
                }
                CompileRascalMojo.mergeOutputFolders(dstEntry, srcEntry);
            } else if (!reg.exists(dstEntry)) {
                reg.copy(srcEntry, dstEntry, true, true);
            }
            try {
                reg.remove(srcEntry, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IList runCheckerSingle(IRascalMonitor monitor, IList todoList, IEvaluator<Result<IValue>> eval, IConstructor compilerConfig) {
        try {
            IList iList = (IList)eval.call(monitor, "check", new IValue[]{todoList, compilerConfig});
            return iList;
        }
        finally {
            eval.getErrorPrinter().flush();
            eval.getOutPrinter().flush();
        }
    }

    private List<IList> splitTodoList(IList todoList, List<String> parallelPreList, IListWriter start) {
        Set reserved = parallelPreList.stream().map(MojoUtils::location).collect(Collectors.toSet());
        start.appendAll(reserved);
        int chunkSize = todoList.size() / this.parallelAmount();
        if (chunkSize < 10) {
            chunkSize = 10;
        }
        int currentChunkSize = 0;
        IListWriter currentChunk = VF.listWriter();
        ArrayList<IList> result = new ArrayList<IList>();
        for (IValue todo : todoList.stream().sorted(Comparator.comparing(v -> ((ISourceLocation)v).getPath())).collect(Collectors.toList())) {
            ISourceLocation module = (ISourceLocation)todo;
            if (reserved.contains(module)) continue;
            currentChunk.append(new IValue[]{module});
            if (currentChunkSize++ <= chunkSize) continue;
            result.add((IList)currentChunk.done());
            currentChunkSize = 0;
            currentChunk = VF.listWriter();
        }
        if (currentChunkSize > 0) {
            result.add((IList)currentChunk.done());
        }
        return result;
    }

    private IList getTodoList(ISourceLocation binLoc, List<ISourceLocation> srcLocs, List<ISourceLocation> ignoredLocs) throws InclusionScanException, URISyntaxException {
        StaleSourceScanner scanner = new StaleSourceScanner(100L);
        scanner.addSourceMapping(new SourceMapping(){

            public Set<File> getTargetFiles(File targetDir, String source) throws InclusionScanException {
                File file = new File(source);
                String name = file.getName();
                if (name.endsWith(".rsc")) {
                    return Set.of(new File(targetDir, new File(file.getParentFile(), "$" + name.substring(0, name.length() - ".rsc".length()) + ".tpl").getPath()));
                }
                return Set.of();
            }
        });
        binLoc = URIUtil.getChildLocation((ISourceLocation)binLoc, (String)"rascal");
        HashSet staleSources = new HashSet();
        for (ISourceLocation src : srcLocs) {
            staleSources.addAll(scanner.getIncludedSources(new File(src.getURI()), new File(binLoc.getURI())));
        }
        IListWriter filteredStaleSources = ValueFactoryFactory.getValueFactory().listWriter();
        for (File file : staleSources) {
            ISourceLocation loc = URIUtil.createFileLocation((String)file.getAbsolutePath());
            if (!ignoredLocs.stream().noneMatch(l -> this.isIgnoredBy((ISourceLocation)l, loc))) continue;
            filteredStaleSources.append(new IValue[]{loc});
        }
        return (IList)filteredStaleSources.done();
    }

    private boolean isIgnoredBy(ISourceLocation prefix, ISourceLocation loc) {
        assert (prefix.getScheme().equals("file"));
        assert (loc.getScheme().equals("file"));
        String prefixPath = prefix.getPath();
        String locPath = loc.getPath();
        return locPath.startsWith(prefixPath);
    }

    private boolean handleMessages(PathConfig pcfg, IList moduleMessages) throws MojoExecutionException {
        int maxLine = 0;
        int maxColumn = 0;
        boolean hasErrors = false;
        for (IValue val : moduleMessages) {
            ISet messages = (ISet)((IConstructor)val).get("messages");
            for (IValue error : messages) {
                ISourceLocation loc = (ISourceLocation)((IConstructor)error).get("at");
                if (loc.hasLineColumn()) {
                    maxLine = Math.max(loc.getBeginLine(), maxLine);
                    maxColumn = Math.max(loc.getBeginColumn(), maxColumn);
                    continue;
                }
                this.getLog().error((CharSequence)("loc without line/column: " + loc));
            }
        }
        int lineWidth = (int)Math.log10(maxLine + 1) + 1;
        int colWidth = (int)Math.log10(maxColumn + 1) + 1;
        for (IValue val : moduleMessages) {
            ISourceLocation module = (ISourceLocation)((IConstructor)val).get("src");
            ISet messages = (ISet)((IConstructor)val).get("messages");
            if (!messages.isEmpty()) {
                this.getLog().info((CharSequence)("Warnings and errors for " + CompileRascalMojo.abbreviate(module.top(), pcfg)));
            }
            Stream<IConstructor> sortedStream = messages.stream().map(IConstructor.class::cast).sorted((m1, m2) -> {
                ISourceLocation l1 = (ISourceLocation)m1.get("at");
                ISourceLocation l2 = (ISourceLocation)m2.get("at");
                if (l1.getBeginLine() == l2.getBeginLine()) {
                    return Integer.compare(l1.getBeginColumn(), l2.getBeginColumn());
                }
                return Integer.compare(l1.getBeginLine(), l2.getBeginLine());
            });
            for (IConstructor msg : sortedStream.collect(Collectors.toList())) {
                String type = msg.getName();
                boolean isError = type.equals("error");
                boolean isWarning = type.equals("warning");
                hasErrors |= isError || this.warningsAsErrors;
                ISourceLocation loc = (ISourceLocation)msg.get("at");
                int col = 0;
                int line = 0;
                if (loc.hasLineColumn()) {
                    col = loc.getBeginColumn();
                    line = loc.getBeginLine();
                }
                String output = CompileRascalMojo.abbreviate(loc, pcfg) + ":" + String.format("%0" + lineWidth + "d", line) + ":" + String.format("%0" + colWidth + "d", col) + ": " + ((IString)msg.get("msg")).getValue();
                if (isError) {
                    this.getLog().error((CharSequence)("  " + output));
                    continue;
                }
                if (isWarning) {
                    this.getLog().warn((CharSequence)output);
                    continue;
                }
                this.getLog().info((CharSequence)("   " + output));
            }
        }
        return !hasErrors || this.errorsAsWarnings;
    }

    private static String abbreviate(ISourceLocation loc, PathConfig pcfg) {
        for (IValue src : pcfg.getSrcs()) {
            String path = ((ISourceLocation)src).getURI().getPath();
            if (!loc.getPath().startsWith(path)) continue;
            return loc.getPath().substring(path.length());
        }
        return loc.getPath();
    }
}

