/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateSourcesUsingRascalMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="mainModule", required=true)
    private String mainModule;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (System.getProperty("rascal.generate.skip") != null) {
            return;
        }
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        this.getLog().info((CharSequence)("Using " + javaBin + " as java process for nested jvm call"));
        LinkedList<String> command = new LinkedList<String>();
        command.add(javaBin);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!key.equals("user.dir")) {
                command.add("-D" + key + "=" + value);
            }
        }));
        command.add("-cp");
        command.add(this.collectClasspath());
        command.add("org.rascalmpl.shell.RascalShell");
        command.add(this.mainModule);
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(this.project.getBasedir());
            Process process = builder.inheritIO().start();
            int result = process.waitFor();
            if (result != 0) {
                throw new MojoExecutionException("Generate sources failed to complete");
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        catch (InterruptedException e) {
            this.getLog().warn((Throwable)e);
        }
    }

    private String collectClasspath() {
        StringBuilder builder = new StringBuilder();
        for (Artifact a : this.project.getArtifacts()) {
            File file = a.getFile().getAbsoluteFile();
            this.getLog().debug((CharSequence)("Adding " + file + " to classpath"));
            builder.append(File.pathSeparator + file.getAbsolutePath());
        }
        return builder.toString().substring(1);
    }
}

