/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.maven;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.io.StandardTextReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.OSUtils;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.maven.MojoRascalMonitor;
import org.rascalmpl.repl.streams.RedErrorWriter;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.jar.JarURIResolver;
import org.rascalmpl.values.ValueFactoryFactory;

public class MojoUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safeLog(Log log, Consumer<Log> action) {
        Log log2 = log;
        synchronized (log2) {
            action.accept(log);
        }
    }

    private static void addSearchPath(Log log, Evaluator eval, ISourceLocation loc) {
        MojoUtils.safeLog(log, l -> l.info((CharSequence)("\trascal module path addition: " + loc)));
        eval.addRascalSearchPath(loc);
    }

    static IRascalMonitor buildMonitor(MavenSession session, Log log) {
        return session.getRequest().isInteractiveMode() ? MojoUtils.getTerminalProgressBarInstance() : new MojoRascalMonitor(log, false);
    }

    static ImmutableTriple<IRascalMonitor, PrintWriter, PrintWriter> calculateMonitor(Log log, MavenSession session) {
        IRascalMonitor monitor = MojoUtils.buildMonitor(session, log);
        PrintWriter out = monitor instanceof PrintWriter ? (PrintWriter)monitor : new PrintWriter(System.out);
        PrintWriter err = monitor instanceof PrintWriter ? new PrintWriter((Writer)new RedErrorWriter((Writer)out), true) : new PrintWriter(System.err, true);
        return ImmutableTriple.of((Object)monitor, (Object)err, (Object)out);
    }

    static Evaluator makeEvaluator(Log log, MavenSession session, ISourceLocation[] searchPath, String ... importedModules) throws URISyntaxException, FactTypeUseException, IOException {
        ImmutableTriple<IRascalMonitor, PrintWriter, PrintWriter> streams = MojoUtils.calculateMonitor(log, session);
        return MojoUtils.makeEvaluator(log, session, (IRascalMonitor)streams.left, (PrintWriter)streams.middle, (PrintWriter)streams.right, searchPath, importedModules);
    }

    static Evaluator makeEvaluator(Log log, MavenSession session, IRascalMonitor monitor, PrintWriter out, PrintWriter err, ISourceLocation[] searchPath, String ... importedModules) throws URISyntaxException, FactTypeUseException, IOException {
        MojoUtils.safeLog(log, l -> l.info((CharSequence)"Start loading the compiler..."));
        GlobalEnvironment heap = new GlobalEnvironment();
        Evaluator eval = new Evaluator(ValueFactoryFactory.getValueFactory(), Reader.nullReader(), err, out, monitor, new ModuleEnvironment("***MVN Rascal Compiler***", heap), heap);
        eval.getConfiguration().setRascalJavaClassPathProperty(MojoUtils.toClassPath(ValueFactoryFactory.class, IValueFactory.class));
        eval.setMonitor(monitor);
        for (ISourceLocation iSourceLocation : searchPath) {
            MojoUtils.addSearchPath(log, eval, iSourceLocation);
        }
        MojoUtils.addSearchPath(log, eval, URIUtil.rootLocation((String)"std"));
        for (String string : importedModules) {
            MojoUtils.safeLog(log, l -> l.info((CharSequence)("\timporting " + string)));
            eval.doImport(monitor, new String[]{string});
        }
        MojoUtils.safeLog(log, l -> l.info((CharSequence)"Done loading the compiler."));
        return eval;
    }

    private static IRascalMonitor getTerminalProgressBarInstance() {
        return MonitorInstanceHolder.monitor;
    }

    private static String toClassPath(Class<?> ... clazz) {
        return Arrays.stream(clazz).map(c -> c.getProtectionDomain().getCodeSource().getLocation()).map(u -> {
            try {
                return u.toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).map(File::new).map(File::toString).collect(Collectors.joining(System.getProperty("path.separator")));
    }

    static ISourceLocation location(String file) {
        if (file.trim().startsWith("|") && file.trim().endsWith("|")) {
            try {
                return (ISourceLocation)new StandardTextReader().read(ValueFactoryFactory.getValueFactory(), (Reader)new StringReader(file));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return URIUtil.createFileLocation((String)file);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static List<ISourceLocation> locations(List<String> files) {
        return files.stream().map(MojoUtils::location).collect(Collectors.toCollection(ArrayList::new));
    }

    static void collectDependentArtifactLibraries(MavenProject project, List<ISourceLocation> libLocs) throws URISyntaxException, IOException {
        RascalManifest mf = new RascalManifest();
        Set projects = libLocs.stream().map(arg_0 -> ((RascalManifest)mf).getProjectName(arg_0)).collect(Collectors.toSet());
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        for (Object o : project.getArtifacts()) {
            String projectName;
            Artifact a = (Artifact)o;
            File file = a.getFile().getAbsoluteFile();
            ISourceLocation jarLoc = JarURIResolver.jarify((ISourceLocation)MojoUtils.location(file.toString()));
            if (!reg.exists(URIUtil.getChildLocation((ISourceLocation)jarLoc, (String)"META-INF/RASCAL.MF")) || projects.contains(projectName = mf.getProjectName(jarLoc))) continue;
            libLocs.add(jarLoc);
            projects.add(projectName);
        }
    }

    private static class MonitorInstanceHolder {
        static IRascalMonitor monitor;

        private MonitorInstanceHolder() {
        }

        static {
            try {
                TerminalBuilder terminal = TerminalBuilder.builder();
                if (OSUtils.IS_WINDOWS) {
                    terminal.encoding(StandardCharsets.UTF_8);
                }
                monitor = IRascalMonitor.buildConsoleMonitor((Terminal)terminal.build(), (boolean)false);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not build terminal", e);
            }
        }
    }
}

